@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getInstances.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of Instance IDs.
 * @property instanceId The first ID of the resource
 * @property instances A list of Instance Entries. Each element contains the following attributes:
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property renewStatus
 */
public data class GetInstancesResult(
    public val id: String,
    public val ids: List<String>,
    public val instanceId: String? = null,
    public val instances: List<GetInstancesInstance>,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val renewStatus: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.threatdetection.outputs.GetInstancesResult): GetInstancesResult = GetInstancesResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceId = javaType.instanceId().map({ args0 -> args0 }).orElse(null),
            instances = javaType.instances().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.threatdetection.kotlin.outputs.GetInstancesInstance.Companion.toKotlin(args0)
                })
            }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            renewStatus = javaType.renewStatus().map({ args0 -> args0 }).orElse(null),
        )
    }
}
