@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getLogShipper.
 * @property authStatus Log Analysis Service authorization status.
 * @property buyStatus Cloud Security Center purchase status.
 * @property enable
 * @property id The provider-assigned unique ID for this managed resource.
 * @property openStatus Log analysis shipping activation status.
 * @property slsProjectStatus Log analysis project status.
 * @property slsServiceStatus Log Analysis Service is activated.
 * @property status The current service enable status.
 */
public data class GetLogShipperResult(
    public val authStatus: String,
    public val buyStatus: String,
    public val enable: String? = null,
    public val id: String,
    public val openStatus: String,
    public val slsProjectStatus: String,
    public val slsServiceStatus: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.threatdetection.outputs.GetLogShipperResult): GetLogShipperResult = GetLogShipperResult(
            authStatus = javaType.authStatus(),
            buyStatus = javaType.buyStatus(),
            enable = javaType.enable().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            openStatus = javaType.openStatus(),
            slsProjectStatus = javaType.slsProjectStatus(),
            slsServiceStatus = javaType.slsServiceStatus(),
            status = javaType.status(),
        )
    }
}
