@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id The ID of the Vul Whitelist.
 * @property reason Reason for adding whitelist.
 * @property targetInfo Set the effective range of the whitelist.
 * @property vulWhitelistId The ID of the Vul Whitelist.
 * @property whitelist Information about the vulnerability to be added to the whitelist.
 */
public data class GetVulWhitelistsWhitelist(
    public val id: String,
    public val reason: String,
    public val targetInfo: String,
    public val vulWhitelistId: String,
    public val whitelist: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.threatdetection.outputs.GetVulWhitelistsWhitelist): GetVulWhitelistsWhitelist = GetVulWhitelistsWhitelist(
            id = javaType.id(),
            reason = javaType.reason(),
            targetInfo = javaType.targetInfo(),
            vulWhitelistId = javaType.vulWhitelistId(),
            whitelist = javaType.whitelist(),
        )
    }
}
