@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property defenceMode The prevention mode.
 * @property dir The directory that has web tamper proofing enabled.
 * @property exclusiveDir The directory that has web tamper proofing disabled.
 * @property exclusiveFile The file that has web tamper proofing disabled. **Note:** If the value of `mode` is `blacklist`, this parameter is returned.
 * @property exclusiveFileType The type of the file that has web tamper proofing disabled. **Note:** If the value of `mode` is `blacklist`, this parameter is returned.
 * @property id The ID of the resource.
 * @property inclusiveFileType The type of the file that has web tamper proofing enabled. **Note:** If the value of `mode` is `whitelist`, this parameter is returned.
 * @property localBackupDir The local path to the backup files of the protected directory.
 * @property mode The protection mode of web tamper proofing.
 * @property uuid The UUID of the server that has web tamper proofing enabled.
 */
public data class GetWebLockConfigsConfig(
    public val defenceMode: String,
    public val dir: String,
    public val exclusiveDir: String,
    public val exclusiveFile: String,
    public val exclusiveFileType: String,
    public val id: String,
    public val inclusiveFileType: String,
    public val localBackupDir: String,
    public val mode: String,
    public val uuid: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.threatdetection.outputs.GetWebLockConfigsConfig): GetWebLockConfigsConfig = GetWebLockConfigsConfig(
            defenceMode = javaType.defenceMode(),
            dir = javaType.dir(),
            exclusiveDir = javaType.exclusiveDir(),
            exclusiveFile = javaType.exclusiveFile(),
            exclusiveFileType = javaType.exclusiveFileType(),
            id = javaType.id(),
            inclusiveFileType = javaType.inclusiveFileType(),
            localBackupDir = javaType.localBackupDir(),
            mode = javaType.mode(),
            uuid = javaType.uuid(),
        )
    }
}
