@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getWebLockConfigs.
 * @property configs A list of Web Lock Config Entries. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of Web Lock Config IDs.
 * @property lang
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property remark
 * @property sourceIp
 * @property status
 */
public data class GetWebLockConfigsResult(
    public val configs: List<GetWebLockConfigsConfig>,
    public val id: String,
    public val ids: List<String>,
    public val lang: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val remark: String? = null,
    public val sourceIp: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.threatdetection.outputs.GetWebLockConfigsResult): GetWebLockConfigsResult = GetWebLockConfigsResult(
            configs = javaType.configs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.threatdetection.kotlin.outputs.GetWebLockConfigsConfig.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            lang = javaType.lang().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            remark = javaType.remark().map({ args0 -> args0 }).orElse(null),
            sourceIp = javaType.sourceIp().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
