@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.threatdetection.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property burp Burp counter.
 * @property portraitOption Social traceability.
 * @property trojanGit Git countered.
 */
public data class HoneypotPresetMeta(
    public val burp: String,
    public val portraitOption: Boolean? = null,
    public val trojanGit: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.threatdetection.outputs.HoneypotPresetMeta): HoneypotPresetMeta = HoneypotPresetMeta(
            burp = javaType.burp(),
            portraitOption = javaType.portraitOption().map({ args0 -> args0 }).orElse(null),
            trojanGit = javaType.trojanGit().map({ args0 -> args0 }).orElse(null),
        )
    }
}
