@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.tsdb.kotlin

import com.pulumi.alicloud.tsdb.InstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Time Series Database (TSDB) Instance resource.
 * For information about Time Series Database (TSDB) Instance and how to use it, see [What is Time Series Database (TSDB)](https://www.alibabacloud.com/help/en/doc-detail/55652.htm).
 * > **NOTE:** Available in v1.112.0+.
 * > **DEPRECATED:**  This resource has been [deprecated](https://www.alibabacloud.com/en/notice/0313tsdb?_p_lc=1) from version `1.223.1`.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = alicloud.tsdb.getZones({});
 * const exampleNetwork = new alicloud.vpc.Network("example", {
 *     cidrBlock: "192.168.0.0/16",
 *     name: "tf-testaccTsdbInstance",
 * });
 * const exampleSwitch = new alicloud.vpc.Switch("example", {
 *     availabilityZone: example.then(example => example.ids?.[0]),
 *     cidrBlock: "192.168.1.0/24",
 *     vpcId: exampleNetwork.id,
 * });
 * const exampleInstance = new alicloud.tsdb.Instance("example", {
 *     paymentType: "PayAsYouGo",
 *     vswitchId: exampleSwitch.id,
 *     instanceStorage: "50",
 *     instanceClass: "tsdb.1x.basic",
 *     engineType: "tsdb_tsdb",
 *     instanceAlias: "tf-testaccTsdbInstance",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.tsdb.get_zones()
 * example_network = alicloud.vpc.Network("example",
 *     cidr_block="192.168.0.0/16",
 *     name="tf-testaccTsdbInstance")
 * example_switch = alicloud.vpc.Switch("example",
 *     availability_zone=example.ids[0],
 *     cidr_block="192.168.1.0/24",
 *     vpc_id=example_network.id)
 * example_instance = alicloud.tsdb.Instance("example",
 *     payment_type="PayAsYouGo",
 *     vswitch_id=example_switch.id,
 *     instance_storage="50",
 *     instance_class="tsdb.1x.basic",
 *     engine_type="tsdb_tsdb",
 *     instance_alias="tf-testaccTsdbInstance")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = AliCloud.Tsdb.GetZones.Invoke();
 *     var exampleNetwork = new AliCloud.Vpc.Network("example", new()
 *     {
 *         CidrBlock = "192.168.0.0/16",
 *         Name = "tf-testaccTsdbInstance",
 *     });
 *     var exampleSwitch = new AliCloud.Vpc.Switch("example", new()
 *     {
 *         AvailabilityZone = example.Apply(getZonesResult => getZonesResult.Ids[0]),
 *         CidrBlock = "192.168.1.0/24",
 *         VpcId = exampleNetwork.Id,
 *     });
 *     var exampleInstance = new AliCloud.Tsdb.Instance("example", new()
 *     {
 *         PaymentType = "PayAsYouGo",
 *         VswitchId = exampleSwitch.Id,
 *         InstanceStorage = "50",
 *         InstanceClass = "tsdb.1x.basic",
 *         EngineType = "tsdb_tsdb",
 *         InstanceAlias = "tf-testaccTsdbInstance",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/tsdb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := tsdb.GetZones(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleNetwork, err := vpc.NewNetwork(ctx, "example", &vpc.NetworkArgs{
 * 			CidrBlock: pulumi.String("192.168.0.0/16"),
 * 			Name:      pulumi.String("tf-testaccTsdbInstance"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleSwitch, err := vpc.NewSwitch(ctx, "example", &vpc.SwitchArgs{
 * 			AvailabilityZone: pulumi.String(example.Ids[0]),
 * 			CidrBlock:        pulumi.String("192.168.1.0/24"),
 * 			VpcId:            exampleNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = tsdb.NewInstance(ctx, "example", &tsdb.InstanceArgs{
 * 			PaymentType:     pulumi.String("PayAsYouGo"),
 * 			VswitchId:       exampleSwitch.ID(),
 * 			InstanceStorage: pulumi.String("50"),
 * 			InstanceClass:   pulumi.String("tsdb.1x.basic"),
 * 			EngineType:      pulumi.String("tsdb_tsdb"),
 * 			InstanceAlias:   pulumi.String("tf-testaccTsdbInstance"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.tsdb.TsdbFunctions;
 * import com.pulumi.alicloud.tsdb.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.tsdb.Instance;
 * import com.pulumi.alicloud.tsdb.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = TsdbFunctions.getZones();
 *         var exampleNetwork = new Network("exampleNetwork", NetworkArgs.builder()
 *             .cidrBlock("192.168.0.0/16")
 *             .name("tf-testaccTsdbInstance")
 *             .build());
 *         var exampleSwitch = new Switch("exampleSwitch", SwitchArgs.builder()
 *             .availabilityZone(example.applyValue(getZonesResult -> getZonesResult.ids()[0]))
 *             .cidrBlock("192.168.1.0/24")
 *             .vpcId(exampleNetwork.id())
 *             .build());
 *         var exampleInstance = new Instance("exampleInstance", InstanceArgs.builder()
 *             .paymentType("PayAsYouGo")
 *             .vswitchId(exampleSwitch.id())
 *             .instanceStorage("50")
 *             .instanceClass("tsdb.1x.basic")
 *             .engineType("tsdb_tsdb")
 *             .instanceAlias("tf-testaccTsdbInstance")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleNetwork:
 *     type: alicloud:vpc:Network
 *     name: example
 *     properties:
 *       cidrBlock: 192.168.0.0/16
 *       name: tf-testaccTsdbInstance
 *   exampleSwitch:
 *     type: alicloud:vpc:Switch
 *     name: example
 *     properties:
 *       availabilityZone: ${example.ids[0]}
 *       cidrBlock: 192.168.1.0/24
 *       vpcId: ${exampleNetwork.id}
 *   exampleInstance:
 *     type: alicloud:tsdb:Instance
 *     name: example
 *     properties:
 *       paymentType: PayAsYouGo
 *       vswitchId: ${exampleSwitch.id}
 *       instanceStorage: '50'
 *       instanceClass: tsdb.1x.basic
 *       engineType: tsdb_tsdb
 *       instanceAlias: tf-testaccTsdbInstance
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: alicloud:tsdb:getZones
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * TSDB Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:tsdb/instance:Instance example <id>
 * ```
 * @property appKey The app key.
 * @property diskCategory The disk type of instance. Valid when the engine type is `tsdb_influxdb`. `cloud_ssd` refers to SSD disk, `cloud_efficiency` refers to efficiency disk, `cloud_essd` refers to ESSD PL1 disk. Valid values: `cloud_efficiency`, `cloud_essd`, `cloud_ssd`.
 * @property duration The duration.
 * @property engineType The engine type of instance Enumerative: `tsdb_tsdb` refers to TSDB, `tsdb_influxdb` refers to TSDB for InfluxDB️.
 * @property instanceAlias The alias of the instance.
 * @property instanceClass The specification of the instance.
 * - Following enumerative value for TSDB for InfluxDB️ standart edition:
 * - `influxdata.n1.mxlarge` refers to 2 CPU 8GB memory;
 * - `influxdata.n1.xlarge` refers to 4 CPU 16GB memory;
 * - `influxdata.n1.2xlarge` refers to 8 CPU 32 GB memory;
 * - `influxdata.n1.4xlarge` refers to 16 CPU 64 GB memory;
 * - `influxdata.n1.8xlarge` refers to 32 CPU 128 GB memory;
 * - `influxdata.n1.16xlarge` refers to 64 CPU 256 GB memory.
 * - Following enumerative value for TSDB for InfluxDB High-availability edition:
 * - `influxdata.n1.mxlarge_ha` refers to 2 CPU 8GB memory;
 * - `influxdata.n1.xlarge_ha` refers to 4 CPU 16GB memory;
 * - `influxdata.n1.2xlarge_ha` refers to 8 CPU 32 GB memory;
 * - `influxdata.n1.4xlarge_ha` refers to 16 CPU 64 GB memory;
 * - `influxdata.n1.8xlarge_ha` refers to 32 CPU 128 GB memory;
 * - `influxdata.n1.16xlarge_ha` refers to 64 CPU 256 GB memory.
 * - Following enumerative value for TSDB:
 * - `tsdb.1x.basic` refers to basic edition I;
 * - `tsdb.3x.basic` refers to basic edition II;
 * - `tsdb.4x.basic` refers to basic edtion III;
 * - `tsdb.12x.standard` refers to standard edition I;
 * - `tsdb.24x.standard` refers to standard edition II;
 * - `tsdb.48x.large` refers to ultimate edition I;
 * - `tsdb.96x.large` refers to ultimate edition II.
 * @property instanceStorage The storage capacity of the instance. Unit: GB. For example, the value 50 indicates 50 GB. Does not support shrink storage.
 * @property paymentType The billing method. Valid values: `PayAsYouGo` and `Subscription`. The `PayAsYouGo` value indicates the pay-as-you-go method, and the `Subscription` value indicates the subscription method.
 * @property vswitchId The vswitch id.
 * @property zoneId The zone ID of the instance.
 */
public data class InstanceArgs(
    public val appKey: Output<String>? = null,
    public val diskCategory: Output<String>? = null,
    public val duration: Output<String>? = null,
    public val engineType: Output<String>? = null,
    public val instanceAlias: Output<String>? = null,
    public val instanceClass: Output<String>? = null,
    public val instanceStorage: Output<String>? = null,
    public val paymentType: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.tsdb.InstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.tsdb.InstanceArgs =
        com.pulumi.alicloud.tsdb.InstanceArgs.builder()
            .appKey(appKey?.applyValue({ args0 -> args0 }))
            .diskCategory(diskCategory?.applyValue({ args0 -> args0 }))
            .duration(duration?.applyValue({ args0 -> args0 }))
            .engineType(engineType?.applyValue({ args0 -> args0 }))
            .instanceAlias(instanceAlias?.applyValue({ args0 -> args0 }))
            .instanceClass(instanceClass?.applyValue({ args0 -> args0 }))
            .instanceStorage(instanceStorage?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceArgs].
 */
@PulumiTagMarker
public class InstanceArgsBuilder internal constructor() {
    private var appKey: Output<String>? = null

    private var diskCategory: Output<String>? = null

    private var duration: Output<String>? = null

    private var engineType: Output<String>? = null

    private var instanceAlias: Output<String>? = null

    private var instanceClass: Output<String>? = null

    private var instanceStorage: Output<String>? = null

    private var paymentType: Output<String>? = null

    private var vswitchId: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value The app key.
     */
    @JvmName("dykjgrnaqgheqeee")
    public suspend fun appKey(`value`: Output<String>) {
        this.appKey = value
    }

    /**
     * @param value The disk type of instance. Valid when the engine type is `tsdb_influxdb`. `cloud_ssd` refers to SSD disk, `cloud_efficiency` refers to efficiency disk, `cloud_essd` refers to ESSD PL1 disk. Valid values: `cloud_efficiency`, `cloud_essd`, `cloud_ssd`.
     */
    @JvmName("ifxbafnyehbbqkkg")
    public suspend fun diskCategory(`value`: Output<String>) {
        this.diskCategory = value
    }

    /**
     * @param value The duration.
     */
    @JvmName("onhubqdqsedwxwtm")
    public suspend fun duration(`value`: Output<String>) {
        this.duration = value
    }

    /**
     * @param value The engine type of instance Enumerative: `tsdb_tsdb` refers to TSDB, `tsdb_influxdb` refers to TSDB for InfluxDB️.
     */
    @JvmName("opxrkixrkfhadrlb")
    public suspend fun engineType(`value`: Output<String>) {
        this.engineType = value
    }

    /**
     * @param value The alias of the instance.
     */
    @JvmName("patckqeoqxlfmhpi")
    public suspend fun instanceAlias(`value`: Output<String>) {
        this.instanceAlias = value
    }

    /**
     * @param value The specification of the instance.
     * - Following enumerative value for TSDB for InfluxDB️ standart edition:
     * - `influxdata.n1.mxlarge` refers to 2 CPU 8GB memory;
     * - `influxdata.n1.xlarge` refers to 4 CPU 16GB memory;
     * - `influxdata.n1.2xlarge` refers to 8 CPU 32 GB memory;
     * - `influxdata.n1.4xlarge` refers to 16 CPU 64 GB memory;
     * - `influxdata.n1.8xlarge` refers to 32 CPU 128 GB memory;
     * - `influxdata.n1.16xlarge` refers to 64 CPU 256 GB memory.
     * - Following enumerative value for TSDB for InfluxDB High-availability edition:
     * - `influxdata.n1.mxlarge_ha` refers to 2 CPU 8GB memory;
     * - `influxdata.n1.xlarge_ha` refers to 4 CPU 16GB memory;
     * - `influxdata.n1.2xlarge_ha` refers to 8 CPU 32 GB memory;
     * - `influxdata.n1.4xlarge_ha` refers to 16 CPU 64 GB memory;
     * - `influxdata.n1.8xlarge_ha` refers to 32 CPU 128 GB memory;
     * - `influxdata.n1.16xlarge_ha` refers to 64 CPU 256 GB memory.
     * - Following enumerative value for TSDB:
     * - `tsdb.1x.basic` refers to basic edition I;
     * - `tsdb.3x.basic` refers to basic edition II;
     * - `tsdb.4x.basic` refers to basic edtion III;
     * - `tsdb.12x.standard` refers to standard edition I;
     * - `tsdb.24x.standard` refers to standard edition II;
     * - `tsdb.48x.large` refers to ultimate edition I;
     * - `tsdb.96x.large` refers to ultimate edition II.
     */
    @JvmName("jtgxrliudgfdfqui")
    public suspend fun instanceClass(`value`: Output<String>) {
        this.instanceClass = value
    }

    /**
     * @param value The storage capacity of the instance. Unit: GB. For example, the value 50 indicates 50 GB. Does not support shrink storage.
     */
    @JvmName("enyenbimcwmboamc")
    public suspend fun instanceStorage(`value`: Output<String>) {
        this.instanceStorage = value
    }

    /**
     * @param value The billing method. Valid values: `PayAsYouGo` and `Subscription`. The `PayAsYouGo` value indicates the pay-as-you-go method, and the `Subscription` value indicates the subscription method.
     */
    @JvmName("vnoykrmopuatwtqg")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value The vswitch id.
     */
    @JvmName("ilvmshubbrpgjohi")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The zone ID of the instance.
     */
    @JvmName("xikoqxnlstfbhckm")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value The app key.
     */
    @JvmName("kwmxytysqkoklqxy")
    public suspend fun appKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appKey = mapped
    }

    /**
     * @param value The disk type of instance. Valid when the engine type is `tsdb_influxdb`. `cloud_ssd` refers to SSD disk, `cloud_efficiency` refers to efficiency disk, `cloud_essd` refers to ESSD PL1 disk. Valid values: `cloud_efficiency`, `cloud_essd`, `cloud_ssd`.
     */
    @JvmName("tdjerimrcunbyegr")
    public suspend fun diskCategory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskCategory = mapped
    }

    /**
     * @param value The duration.
     */
    @JvmName("ehgqcmqnmtxsxuwu")
    public suspend fun duration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.duration = mapped
    }

    /**
     * @param value The engine type of instance Enumerative: `tsdb_tsdb` refers to TSDB, `tsdb_influxdb` refers to TSDB for InfluxDB️.
     */
    @JvmName("wjqmqtwqdgavcmju")
    public suspend fun engineType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engineType = mapped
    }

    /**
     * @param value The alias of the instance.
     */
    @JvmName("idcijsrahuybdhve")
    public suspend fun instanceAlias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceAlias = mapped
    }

    /**
     * @param value The specification of the instance.
     * - Following enumerative value for TSDB for InfluxDB️ standart edition:
     * - `influxdata.n1.mxlarge` refers to 2 CPU 8GB memory;
     * - `influxdata.n1.xlarge` refers to 4 CPU 16GB memory;
     * - `influxdata.n1.2xlarge` refers to 8 CPU 32 GB memory;
     * - `influxdata.n1.4xlarge` refers to 16 CPU 64 GB memory;
     * - `influxdata.n1.8xlarge` refers to 32 CPU 128 GB memory;
     * - `influxdata.n1.16xlarge` refers to 64 CPU 256 GB memory.
     * - Following enumerative value for TSDB for InfluxDB High-availability edition:
     * - `influxdata.n1.mxlarge_ha` refers to 2 CPU 8GB memory;
     * - `influxdata.n1.xlarge_ha` refers to 4 CPU 16GB memory;
     * - `influxdata.n1.2xlarge_ha` refers to 8 CPU 32 GB memory;
     * - `influxdata.n1.4xlarge_ha` refers to 16 CPU 64 GB memory;
     * - `influxdata.n1.8xlarge_ha` refers to 32 CPU 128 GB memory;
     * - `influxdata.n1.16xlarge_ha` refers to 64 CPU 256 GB memory.
     * - Following enumerative value for TSDB:
     * - `tsdb.1x.basic` refers to basic edition I;
     * - `tsdb.3x.basic` refers to basic edition II;
     * - `tsdb.4x.basic` refers to basic edtion III;
     * - `tsdb.12x.standard` refers to standard edition I;
     * - `tsdb.24x.standard` refers to standard edition II;
     * - `tsdb.48x.large` refers to ultimate edition I;
     * - `tsdb.96x.large` refers to ultimate edition II.
     */
    @JvmName("qdchrirrqfiglyld")
    public suspend fun instanceClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceClass = mapped
    }

    /**
     * @param value The storage capacity of the instance. Unit: GB. For example, the value 50 indicates 50 GB. Does not support shrink storage.
     */
    @JvmName("dajbouxkhscnitvk")
    public suspend fun instanceStorage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceStorage = mapped
    }

    /**
     * @param value The billing method. Valid values: `PayAsYouGo` and `Subscription`. The `PayAsYouGo` value indicates the pay-as-you-go method, and the `Subscription` value indicates the subscription method.
     */
    @JvmName("bwxwuwasptusdpfo")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value The vswitch id.
     */
    @JvmName("kjcvtshirdbtemgs")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value The zone ID of the instance.
     */
    @JvmName("orkagleihtipccwq")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): InstanceArgs = InstanceArgs(
        appKey = appKey,
        diskCategory = diskCategory,
        duration = duration,
        engineType = engineType,
        instanceAlias = instanceAlias,
        instanceClass = instanceClass,
        instanceStorage = instanceStorage,
        paymentType = paymentType,
        vswitchId = vswitchId,
        zoneId = zoneId,
    )
}
