@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.tsdb.kotlin

import com.pulumi.alicloud.tsdb.TsdbFunctions.getInstancesPlain
import com.pulumi.alicloud.tsdb.TsdbFunctions.getZonesPlain
import com.pulumi.alicloud.tsdb.kotlin.inputs.GetInstancesPlainArgs
import com.pulumi.alicloud.tsdb.kotlin.inputs.GetInstancesPlainArgsBuilder
import com.pulumi.alicloud.tsdb.kotlin.inputs.GetZonesPlainArgs
import com.pulumi.alicloud.tsdb.kotlin.inputs.GetZonesPlainArgsBuilder
import com.pulumi.alicloud.tsdb.kotlin.outputs.GetInstancesResult
import com.pulumi.alicloud.tsdb.kotlin.outputs.GetZonesResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.tsdb.kotlin.outputs.GetInstancesResult.Companion.toKotlin as getInstancesResultToKotlin
import com.pulumi.alicloud.tsdb.kotlin.outputs.GetZonesResult.Companion.toKotlin as getZonesResultToKotlin

public object TsdbFunctions {
    /**
     * This data source provides the Time Series Database (TSDB) Instances of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.112.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.tsdb.getInstances({
     *     ids: ["example_value"],
     * });
     * export const firstTsdbInstanceId = example.then(example => example.instances?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.tsdb.get_instances(ids=["example_value"])
     * pulumi.export("firstTsdbInstanceId", example.instances[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Tsdb.GetInstances.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_value",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstTsdbInstanceId"] = example&#46;Apply(getInstancesResult => getInstancesResult&#46;Instances[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/tsdb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := tsdb.GetInstances(ctx, &tsdb.GetInstancesArgs{
     * 			Ids: []string{
     * 				"example_value",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstTsdbInstanceId", example.Instances[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.tsdb.TsdbFunctions;
     * import com.pulumi.alicloud.tsdb.inputs.GetInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = TsdbFunctions.getInstances(GetInstancesArgs.builder()
     *             .ids("example_value")
     *             .build());
     *         ctx.export("firstTsdbInstanceId", example.applyValue(getInstancesResult -> getInstancesResult.instances()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:tsdb:getInstances
     *       Arguments:
     *         ids:
     *           - example_value
     * outputs:
     *   firstTsdbInstanceId: ${example.instances[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstances.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: GetInstancesPlainArgs): GetInstancesResult =
        getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())

    /**
     * @see [getInstances].
     * @param appKey The app key.
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param engineType The engine type of instance. Enumerative: `tsdb_tsdb` refers to TSDB, `tsdb_influxdb` refers to TSDB for InfluxDB️.
     * @param ids A list of Instance IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param queryStr The query str.
     * @param status Instance status, enumerative: `ACTIVATION`, `DELETED`, `CREATING`, `CLASS_CHANGING`, `LOCKED`.
     * @param statusList The status list.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(
        appKey: String? = null,
        enableDetails: Boolean? = null,
        engineType: String? = null,
        ids: List<String>? = null,
        outputFile: String? = null,
        queryStr: String? = null,
        status: String? = null,
        statusList: String? = null,
    ): GetInstancesResult {
        val argument = GetInstancesPlainArgs(
            appKey = appKey,
            enableDetails = enableDetails,
            engineType = engineType,
            ids = ids,
            outputFile = outputFile,
            queryStr = queryStr,
            status = status,
            statusList = statusList,
        )
        return getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstances].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;tsdb&#46;kotlin&#46;inputs&#46;GetInstancesPlainArgs].
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: suspend GetInstancesPlainArgsBuilder.() -> Unit): GetInstancesResult {
        val builder = GetInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstancesResultToKotlin(getInstancesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the available zones with the Time Series Database (TSDB) Instance of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.112.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.tsdb.getZones({});
     * export const firstTsdbZonesId = example.then(example => example.zones?.[0]?.zoneId);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.tsdb.get_zones()
     * pulumi.export("firstTsdbZonesId", example.zones[0].zone_id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Tsdb.GetZones.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstTsdbZonesId"] = example&#46;Apply(getZonesResult => getZonesResult&#46;Zones[0]?.ZoneId),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/tsdb"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := tsdb.GetZones(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstTsdbZonesId", example.Zones[0].ZoneId)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.tsdb.TsdbFunctions;
     * import com.pulumi.alicloud.tsdb.inputs.GetZonesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = TsdbFunctions.getZones();
     *         ctx.export("firstTsdbZonesId", example.applyValue(getZonesResult -> getZonesResult.zones()[0].zoneId()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:tsdb:getZones
     *       Arguments: {}
     * outputs:
     *   firstTsdbZonesId: ${example.zones[0].zoneId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getZones.
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(argument: GetZonesPlainArgs): GetZonesResult =
        getZonesResultToKotlin(getZonesPlain(argument.toJava()).await())

    /**
     * @see [getZones].
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(outputFile: String? = null): GetZonesResult {
        val argument = GetZonesPlainArgs(
            outputFile = outputFile,
        )
        return getZonesResultToKotlin(getZonesPlain(argument.toJava()).await())
    }

    /**
     * @see [getZones].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;tsdb&#46;kotlin&#46;inputs&#46;GetZonesPlainArgs].
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(argument: suspend GetZonesPlainArgsBuilder.() -> Unit): GetZonesResult {
        val builder = GetZonesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getZonesResultToKotlin(getZonesPlain(builtArgument.toJava()).await())
    }
}
