@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.tsdb.kotlin.inputs

import com.pulumi.alicloud.tsdb.inputs.GetInstancesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInstances.
 * @property appKey The app key.
 * @property enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property engineType The engine type of instance. Enumerative: `tsdb_tsdb` refers to TSDB, `tsdb_influxdb` refers to TSDB for InfluxDB️.
 * @property ids A list of Instance IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property queryStr The query str.
 * @property status Instance status, enumerative: `ACTIVATION`, `DELETED`, `CREATING`, `CLASS_CHANGING`, `LOCKED`.
 * @property statusList The status list.
 */
public data class GetInstancesPlainArgs(
    public val appKey: String? = null,
    public val enableDetails: Boolean? = null,
    public val engineType: String? = null,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val queryStr: String? = null,
    public val status: String? = null,
    public val statusList: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.tsdb.inputs.GetInstancesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.tsdb.inputs.GetInstancesPlainArgs =
        com.pulumi.alicloud.tsdb.inputs.GetInstancesPlainArgs.builder()
            .appKey(appKey?.let({ args0 -> args0 }))
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .engineType(engineType?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .queryStr(queryStr?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .statusList(statusList?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInstancesPlainArgs].
 */
@PulumiTagMarker
public class GetInstancesPlainArgsBuilder internal constructor() {
    private var appKey: String? = null

    private var enableDetails: Boolean? = null

    private var engineType: String? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var queryStr: String? = null

    private var status: String? = null

    private var statusList: String? = null

    /**
     * @param value The app key.
     */
    @JvmName("ujltjscutoapabye")
    public suspend fun appKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.appKey = mapped
    }

    /**
     * @param value Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("cggejrxbcedjhyqf")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value The engine type of instance. Enumerative: `tsdb_tsdb` refers to TSDB, `tsdb_influxdb` refers to TSDB for InfluxDB️.
     */
    @JvmName("cunqxuoxtimuedox")
    public suspend fun engineType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.engineType = mapped
    }

    /**
     * @param value A list of Instance IDs.
     */
    @JvmName("yivflweukydakbhk")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Instance IDs.
     */
    @JvmName("gnuxwcipljobktio")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("vffhrrdyepichdrj")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The query str.
     */
    @JvmName("mhwufkapngurjnkw")
    public suspend fun queryStr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.queryStr = mapped
    }

    /**
     * @param value Instance status, enumerative: `ACTIVATION`, `DELETED`, `CREATING`, `CLASS_CHANGING`, `LOCKED`.
     */
    @JvmName("gffrrohpigjeqtvn")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value The status list.
     */
    @JvmName("taxftaxmlmurlrqd")
    public suspend fun statusList(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.statusList = mapped
    }

    internal fun build(): GetInstancesPlainArgs = GetInstancesPlainArgs(
        appKey = appKey,
        enableDetails = enableDetails,
        engineType = engineType,
        ids = ids,
        outputFile = outputFile,
        queryStr = queryStr,
        status = status,
        statusList = statusList,
    )
}
