@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.tsdb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property autoRenew Auto renew.
 * @property cpuNumber The cpu core number of instance.
 * @property diskCategory The disk type of instance. `cloud_ssd` refers to SSD disk, `cloud_efficiency` refers to efficiency disk,cloud_essd refers to ESSD PL1 disk.
 * @property engineType The engine type of instance. Enumerative: `tsdb_tsdb` refers to TSDB, `tsdb_influxdb` refers to TSDB for InfluxDB️.
 * @property expiredTime Instance expiration time.
 * @property id The ID of the Instance.
 * @property instanceAlias The alias of the instance.
 * @property instanceClass The specification of the instance.
 * @property instanceId The ID of the instance.
 * @property instanceStorage The storage capacity of the instance. Unit: GB. For example, the value 50 indicates 50 GB.
 * @property memorySize The memory size of instance.
 * @property networkType Instance network type.
 * @property paymentType The billing method. Valid values: `PayAsYouGo` and `Subscription`. The `PayAsYouGo` value indicates the pay-as-you-go method, and the `Subscription` value indicates the subscription method.
 * @property status Instance status, enumerative: ACTIVATION,DELETED, CREATING,CLASS_CHANGING,LOCKED.
 * @property vpcConnectionAddress The vpc connection address of instance.
 * @property vpcId The ID of the virtual private cloud (VPC) that is connected to the instance.
 * @property vswitchId The vswitch id.
 * @property zoneId The zone ID of the instance.
 */
public data class GetInstancesInstance(
    public val autoRenew: String,
    public val cpuNumber: String,
    public val diskCategory: String,
    public val engineType: String,
    public val expiredTime: Int,
    public val id: String,
    public val instanceAlias: String,
    public val instanceClass: String,
    public val instanceId: String,
    public val instanceStorage: String,
    public val memorySize: String,
    public val networkType: String,
    public val paymentType: String,
    public val status: String,
    public val vpcConnectionAddress: String,
    public val vpcId: String,
    public val vswitchId: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.tsdb.outputs.GetInstancesInstance): GetInstancesInstance = GetInstancesInstance(
            autoRenew = javaType.autoRenew(),
            cpuNumber = javaType.cpuNumber(),
            diskCategory = javaType.diskCategory(),
            engineType = javaType.engineType(),
            expiredTime = javaType.expiredTime(),
            id = javaType.id(),
            instanceAlias = javaType.instanceAlias(),
            instanceClass = javaType.instanceClass(),
            instanceId = javaType.instanceId(),
            instanceStorage = javaType.instanceStorage(),
            memorySize = javaType.memorySize(),
            networkType = javaType.networkType(),
            paymentType = javaType.paymentType(),
            status = javaType.status(),
            vpcConnectionAddress = javaType.vpcConnectionAddress(),
            vpcId = javaType.vpcId(),
            vswitchId = javaType.vswitchId(),
            zoneId = javaType.zoneId(),
        )
    }
}
