@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.tsdb.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getInstances.
 * @property appKey
 * @property enableDetails
 * @property engineType
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property instances
 * @property outputFile
 * @property queryStr
 * @property status
 * @property statusList
 */
public data class GetInstancesResult(
    public val appKey: String? = null,
    public val enableDetails: Boolean? = null,
    public val engineType: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val instances: List<GetInstancesInstance>,
    public val outputFile: String? = null,
    public val queryStr: String? = null,
    public val status: String? = null,
    public val statusList: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.tsdb.outputs.GetInstancesResult): GetInstancesResult = GetInstancesResult(
            appKey = javaType.appKey().map({ args0 -> args0 }).orElse(null),
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            engineType = javaType.engineType().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instances = javaType.instances().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.tsdb.kotlin.outputs.GetInstancesInstance.Companion.toKotlin(args0)
                })
            }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            queryStr = javaType.queryStr().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            statusList = javaType.statusList().map({ args0 -> args0 }).orElse(null),
        )
    }
}
