@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.videosurveillance.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SystemGroup].
 */
@PulumiTagMarker
public class SystemGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SystemGroupArgs = SystemGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SystemGroupArgsBuilder.() -> Unit) {
        val builder = SystemGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SystemGroup {
        val builtJavaResource =
            com.pulumi.alicloud.videosurveillance.SystemGroup(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SystemGroup(builtJavaResource)
    }
}

/**
 * Provides a Video Surveillance System Group resource.
 * For information about Video Surveillance System Group and how to use it, see [What is Group](https://help.aliyun.com/product/108765.html).
 * > **NOTE:** Available in v1.135.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.videosurveillance.SystemGroup("default", {
 *     groupName: "your_group_name",
 *     inProtocol: "rtmp",
 *     outProtocol: "flv",
 *     playDomain: "your_plan_domain",
 *     pushDomain: "your_push_domain",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.videosurveillance.SystemGroup("default",
 *     group_name="your_group_name",
 *     in_protocol="rtmp",
 *     out_protocol="flv",
 *     play_domain="your_plan_domain",
 *     push_domain="your_push_domain")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.VideoSurveillance.SystemGroup("default", new()
 *     {
 *         GroupName = "your_group_name",
 *         InProtocol = "rtmp",
 *         OutProtocol = "flv",
 *         PlayDomain = "your_plan_domain",
 *         PushDomain = "your_push_domain",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/videosurveillance"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := videosurveillance.NewSystemGroup(ctx, "default", &videosurveillance.SystemGroupArgs{
 * 			GroupName:   pulumi.String("your_group_name"),
 * 			InProtocol:  pulumi.String("rtmp"),
 * 			OutProtocol: pulumi.String("flv"),
 * 			PlayDomain:  pulumi.String("your_plan_domain"),
 * 			PushDomain:  pulumi.String("your_push_domain"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.videosurveillance.SystemGroup;
 * import com.pulumi.alicloud.videosurveillance.SystemGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new SystemGroup("default", SystemGroupArgs.builder()
 *             .groupName("your_group_name")
 *             .inProtocol("rtmp")
 *             .outProtocol("flv")
 *             .playDomain("your_plan_domain")
 *             .pushDomain("your_push_domain")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:videosurveillance:SystemGroup
 *     properties:
 *       groupName: your_group_name
 *       inProtocol: rtmp
 *       outProtocol: flv
 *       playDomain: your_plan_domain
 *       pushDomain: your_push_domain
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Video Surveillance System Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:videosurveillance/systemGroup:SystemGroup example <id>
 * ```
 */
public class SystemGroup internal constructor(
    override val javaResource: com.pulumi.alicloud.videosurveillance.SystemGroup,
) : KotlinCustomResource(javaResource, SystemGroupMapper) {
    /**
     * The space within the device status update of the callback, need to start with http:// or https:// at the beginning.
     */
    public val callback: Output<String>?
        get() = javaResource.callback().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The capture image.
     */
    public val captureImage: Output<Int>
        get() = javaResource.captureImage().applyValue({ args0 -> args0 })

    /**
     * The capture interval.
     */
    public val captureInterval: Output<Int>
        get() = javaResource.captureInterval().applyValue({ args0 -> args0 })

    /**
     * The capture oss bucket.
     */
    public val captureOssBucket: Output<String>
        get() = javaResource.captureOssBucket().applyValue({ args0 -> args0 })

    /**
     * The capture oss path.
     */
    public val captureOssPath: Output<String>
        get() = javaResource.captureOssPath().applyValue({ args0 -> args0 })

    /**
     * The capture video.
     */
    public val captureVideo: Output<Int>
        get() = javaResource.captureVideo().applyValue({ args0 -> args0 })

    /**
     * The description of Group.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to open Group.
     */
    public val enabled: Output<Boolean>
        get() = javaResource.enabled().applyValue({ args0 -> args0 })

    /**
     * The Group Name.
     */
    public val groupName: Output<String>
        get() = javaResource.groupName().applyValue({ args0 -> args0 })

    /**
     * The use of the access protocol support gb28181, Real Time Messaging Protocol (rtmp). Valid values: `gb28181`, `rtmp`.
     */
    public val inProtocol: Output<String>
        get() = javaResource.inProtocol().applyValue({ args0 -> args0 })

    /**
     * Whether to enable on-demand streaming. Default value:`false`.
     */
    public val lazyPull: Output<Boolean>
        get() = javaResource.lazyPull().applyValue({ args0 -> args0 })

    /**
     * The playback protocol used by the space, multiple values are separated by commas (,). Valid values: `flv`,`hls`, `rtmp`.
     */
    public val outProtocol: Output<String>
        get() = javaResource.outProtocol().applyValue({ args0 -> args0 })

    /**
     * The domain name of plan streaming used by the group.
     */
    public val playDomain: Output<String>
        get() = javaResource.playDomain().applyValue({ args0 -> args0 })

    /**
     * The domain name of push streaming used by the group.
     */
    public val pushDomain: Output<String>
        get() = javaResource.pushDomain().applyValue({ args0 -> args0 })

    /**
     * Whether to open Group. Valid values: `on`,`off`.
     */
    public val status: Output<Boolean>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object SystemGroupMapper : ResourceMapper<SystemGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.videosurveillance.SystemGroup::class == javaResource::class

    override fun map(javaResource: Resource): SystemGroup = SystemGroup(
        javaResource as
            com.pulumi.alicloud.videosurveillance.SystemGroup,
    )
}

/**
 * @see [SystemGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SystemGroup].
 */
public suspend fun systemGroup(name: String, block: suspend SystemGroupResourceBuilder.() -> Unit): SystemGroup {
    val builder = SystemGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SystemGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun systemGroup(name: String): SystemGroup {
    val builder = SystemGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
