@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.videosurveillance.kotlin

import com.pulumi.alicloud.videosurveillance.SystemGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Video Surveillance System Group resource.
 * For information about Video Surveillance System Group and how to use it, see [What is Group](https://help.aliyun.com/product/108765.html).
 * > **NOTE:** Available in v1.135.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.videosurveillance.SystemGroup("default", {
 *     groupName: "your_group_name",
 *     inProtocol: "rtmp",
 *     outProtocol: "flv",
 *     playDomain: "your_plan_domain",
 *     pushDomain: "your_push_domain",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.videosurveillance.SystemGroup("default",
 *     group_name="your_group_name",
 *     in_protocol="rtmp",
 *     out_protocol="flv",
 *     play_domain="your_plan_domain",
 *     push_domain="your_push_domain")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.VideoSurveillance.SystemGroup("default", new()
 *     {
 *         GroupName = "your_group_name",
 *         InProtocol = "rtmp",
 *         OutProtocol = "flv",
 *         PlayDomain = "your_plan_domain",
 *         PushDomain = "your_push_domain",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/videosurveillance"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := videosurveillance.NewSystemGroup(ctx, "default", &videosurveillance.SystemGroupArgs{
 * 			GroupName:   pulumi.String("your_group_name"),
 * 			InProtocol:  pulumi.String("rtmp"),
 * 			OutProtocol: pulumi.String("flv"),
 * 			PlayDomain:  pulumi.String("your_plan_domain"),
 * 			PushDomain:  pulumi.String("your_push_domain"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.videosurveillance.SystemGroup;
 * import com.pulumi.alicloud.videosurveillance.SystemGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new SystemGroup("default", SystemGroupArgs.builder()
 *             .groupName("your_group_name")
 *             .inProtocol("rtmp")
 *             .outProtocol("flv")
 *             .playDomain("your_plan_domain")
 *             .pushDomain("your_push_domain")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:videosurveillance:SystemGroup
 *     properties:
 *       groupName: your_group_name
 *       inProtocol: rtmp
 *       outProtocol: flv
 *       playDomain: your_plan_domain
 *       pushDomain: your_push_domain
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Video Surveillance System Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:videosurveillance/systemGroup:SystemGroup example <id>
 * ```
 * @property callback The space within the device status update of the callback, need to start with http:// or https:// at the beginning.
 * @property description The description of Group.
 * @property enabled Whether to open Group.
 * @property groupName The Group Name.
 * @property inProtocol The use of the access protocol support gb28181, Real Time Messaging Protocol (rtmp). Valid values: `gb28181`, `rtmp`.
 * @property outProtocol The playback protocol used by the space, multiple values are separated by commas (,). Valid values: `flv`,`hls`, `rtmp`.
 * @property playDomain The domain name of plan streaming used by the group.
 * @property pushDomain The domain name of push streaming used by the group.
 */
public data class SystemGroupArgs(
    public val callback: Output<String>? = null,
    public val description: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
    public val groupName: Output<String>? = null,
    public val inProtocol: Output<String>? = null,
    public val outProtocol: Output<String>? = null,
    public val playDomain: Output<String>? = null,
    public val pushDomain: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.videosurveillance.SystemGroupArgs> {
    override fun toJava(): com.pulumi.alicloud.videosurveillance.SystemGroupArgs =
        com.pulumi.alicloud.videosurveillance.SystemGroupArgs.builder()
            .callback(callback?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .groupName(groupName?.applyValue({ args0 -> args0 }))
            .inProtocol(inProtocol?.applyValue({ args0 -> args0 }))
            .outProtocol(outProtocol?.applyValue({ args0 -> args0 }))
            .playDomain(playDomain?.applyValue({ args0 -> args0 }))
            .pushDomain(pushDomain?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SystemGroupArgs].
 */
@PulumiTagMarker
public class SystemGroupArgsBuilder internal constructor() {
    private var callback: Output<String>? = null

    private var description: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var groupName: Output<String>? = null

    private var inProtocol: Output<String>? = null

    private var outProtocol: Output<String>? = null

    private var playDomain: Output<String>? = null

    private var pushDomain: Output<String>? = null

    /**
     * @param value The space within the device status update of the callback, need to start with http:// or https:// at the beginning.
     */
    @JvmName("okerbhvpnvnucxra")
    public suspend fun callback(`value`: Output<String>) {
        this.callback = value
    }

    /**
     * @param value The description of Group.
     */
    @JvmName("jaiojbguxvxwsgoa")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Whether to open Group.
     */
    @JvmName("dfyrcmhrsjvwldht")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The Group Name.
     */
    @JvmName("uaassagmkeufjqwq")
    public suspend fun groupName(`value`: Output<String>) {
        this.groupName = value
    }

    /**
     * @param value The use of the access protocol support gb28181, Real Time Messaging Protocol (rtmp). Valid values: `gb28181`, `rtmp`.
     */
    @JvmName("rvxtrakdyrbuofmt")
    public suspend fun inProtocol(`value`: Output<String>) {
        this.inProtocol = value
    }

    /**
     * @param value The playback protocol used by the space, multiple values are separated by commas (,). Valid values: `flv`,`hls`, `rtmp`.
     */
    @JvmName("ferlavrcswgbyyjb")
    public suspend fun outProtocol(`value`: Output<String>) {
        this.outProtocol = value
    }

    /**
     * @param value The domain name of plan streaming used by the group.
     */
    @JvmName("eqydiegvuhlxqjcm")
    public suspend fun playDomain(`value`: Output<String>) {
        this.playDomain = value
    }

    /**
     * @param value The domain name of push streaming used by the group.
     */
    @JvmName("eqehqixoiekffctn")
    public suspend fun pushDomain(`value`: Output<String>) {
        this.pushDomain = value
    }

    /**
     * @param value The space within the device status update of the callback, need to start with http:// or https:// at the beginning.
     */
    @JvmName("vilgkfceliipjlsc")
    public suspend fun callback(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.callback = mapped
    }

    /**
     * @param value The description of Group.
     */
    @JvmName("twecmowdloqibgfl")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Whether to open Group.
     */
    @JvmName("hlyppplkebkfoytj")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The Group Name.
     */
    @JvmName("wxrvfwkumbdwewum")
    public suspend fun groupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupName = mapped
    }

    /**
     * @param value The use of the access protocol support gb28181, Real Time Messaging Protocol (rtmp). Valid values: `gb28181`, `rtmp`.
     */
    @JvmName("rsitogyapnklrseg")
    public suspend fun inProtocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inProtocol = mapped
    }

    /**
     * @param value The playback protocol used by the space, multiple values are separated by commas (,). Valid values: `flv`,`hls`, `rtmp`.
     */
    @JvmName("kcwvyxmhvlcwclid")
    public suspend fun outProtocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outProtocol = mapped
    }

    /**
     * @param value The domain name of plan streaming used by the group.
     */
    @JvmName("qgfepxpnodoklimk")
    public suspend fun playDomain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.playDomain = mapped
    }

    /**
     * @param value The domain name of push streaming used by the group.
     */
    @JvmName("avrmqnxrpvpouxai")
    public suspend fun pushDomain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pushDomain = mapped
    }

    internal fun build(): SystemGroupArgs = SystemGroupArgs(
        callback = callback,
        description = description,
        enabled = enabled,
        groupName = groupName,
        inProtocol = inProtocol,
        outProtocol = outProtocol,
        playDomain = playDomain,
        pushDomain = pushDomain,
    )
}
