@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.videosurveillance.kotlin

import com.pulumi.alicloud.videosurveillance.VideosurveillanceFunctions.getServicePlain
import com.pulumi.alicloud.videosurveillance.VideosurveillanceFunctions.getSystemGroupsPlain
import com.pulumi.alicloud.videosurveillance.kotlin.inputs.GetServicePlainArgs
import com.pulumi.alicloud.videosurveillance.kotlin.inputs.GetServicePlainArgsBuilder
import com.pulumi.alicloud.videosurveillance.kotlin.inputs.GetSystemGroupsPlainArgs
import com.pulumi.alicloud.videosurveillance.kotlin.inputs.GetSystemGroupsPlainArgsBuilder
import com.pulumi.alicloud.videosurveillance.kotlin.outputs.GetServiceResult
import com.pulumi.alicloud.videosurveillance.kotlin.outputs.GetSystemGroupsResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.videosurveillance.kotlin.outputs.GetServiceResult.Companion.toKotlin as getServiceResultToKotlin
import com.pulumi.alicloud.videosurveillance.kotlin.outputs.GetSystemGroupsResult.Companion.toKotlin as getSystemGroupsResultToKotlin

public object VideosurveillanceFunctions {
    /**
     * Using this data source can open Video Surveillance System service automatically. If the service has been opened, it will return opened.
     * For information about Video Surveillance System and how to use it, see [What is VS](https://help.aliyun.com/product/108765.html).
     * > **NOTE:** Available in v1.116.0+
     * > **NOTE:** The Video Surveillance System service is not support in the international site.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const open = alicloud.videosurveillance.getService({
     *     enable: "On",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * open = alicloud.videosurveillance.get_service(enable="On")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var open = AliCloud.VideoSurveillance.GetService.Invoke(new()
     *     {
     *         Enable = "On",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/videosurveillance"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := videosurveillance.GetService(ctx, &videosurveillance.GetServiceArgs{
     * 			Enable: pulumi.StringRef("On"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.videosurveillance.VideosurveillanceFunctions;
     * import com.pulumi.alicloud.videosurveillance.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var open = VideosurveillanceFunctions.getService(GetServiceArgs.builder()
     *             .enable("On")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   open:
     *     fn::invoke:
     *       Function: alicloud:videosurveillance:getService
     *       Arguments:
     *         enable: On
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getService.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: GetServicePlainArgs): GetServiceResult =
        getServiceResultToKotlin(getServicePlain(argument.toJava()).await())

    /**
     * @see [getService].
     * @param enable Setting the value to `On` to enable the service. If has been enabled, return the result. Valid values: `On` or `Off`. Default to `Off`.
     * > **NOTE:** Setting `enable = "On"` to open the Video Surveillance (VS) service that means you have read and agreed the [VS Terms of Service](https://help.aliyun.com/document_detail/109213.html). The service can not closed once it is opened.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(enable: String? = null): GetServiceResult {
        val argument = GetServicePlainArgs(
            enable = enable,
        )
        return getServiceResultToKotlin(getServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getService].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;videosurveillance&#46;kotlin&#46;inputs&#46;GetServicePlainArgs].
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: suspend GetServicePlainArgsBuilder.() -> Unit): GetServiceResult {
        val builder = GetServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceResultToKotlin(getServicePlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Video Surveillance System Groups of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.135.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const defaultSystemGroup = new alicloud.videosurveillance.SystemGroup("default", {
     *     groupName: "groupname",
     *     inProtocol: "rtmp",
     *     outProtocol: "flv",
     *     playDomain: "your_plan_domain",
     *     pushDomain: "your_push_domain",
     * });
     * const default = alicloud.videosurveillance.getSystemGroupsOutput({
     *     ids: [defaultSystemGroup&#46;id],
     * });
     * export const vsGroup = _default.apply(_default => _default.ids?.[0]);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default_system_group = alicloud.videosurveillance.SystemGroup("default",
     *     group_name="groupname",
     *     in_protocol="rtmp",
     *     out_protocol="flv",
     *     play_domain="your_plan_domain",
     *     push_domain="your_push_domain")
     * default = alicloud.videosurveillance.get_system_groups_output(ids=[default_system_group&#46;id])
     * pulumi.export("vsGroup", default.ids[0])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var defaultSystemGroup = new AliCloud.VideoSurveillance.SystemGroup("default", new()
     *     {
     *         GroupName = "groupname",
     *         InProtocol = "rtmp",
     *         OutProtocol = "flv",
     *         PlayDomain = "your_plan_domain",
     *         PushDomain = "your_push_domain",
     *     });
     *     var @default = AliCloud.VideoSurveillance.GetSystemGroups.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             defaultSystemGroup.Id,
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["vsGroup"] = @default&#46;Apply(@default => @default&#46;Apply(getSystemGroupsResult => getSystemGroupsResult&#46;Ids[0])),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/videosurveillance"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * defaultSystemGroup, err := videosurveillance.NewSystemGroup(ctx, "default", &videosurveillance.SystemGroupArgs{
     * GroupName: pulumi.String("groupname"),
     * InProtocol: pulumi.String("rtmp"),
     * OutProtocol: pulumi.String("flv"),
     * PlayDomain: pulumi.String("your_plan_domain"),
     * PushDomain: pulumi.String("your_push_domain"),
     * })
     * if err != nil {
     * return err
     * }
     * _default := videosurveillance.GetSystemGroupsOutput(ctx, videosurveillance.GetSystemGroupsOutputArgs{
     * Ids: pulumi.StringArray{
     * defaultSystemGroup.ID(),
     * },
     * }, nil);
     * ctx.Export("vsGroup", _default.ApplyT(func(_default videosurveillance.GetSystemGroupsResult) (*string, error) {
     * return &default.Ids[0], nil
     * }).(pulumi.StringPtrOutput))
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.videosurveillance.SystemGroup;
     * import com.pulumi.alicloud.videosurveillance.SystemGroupArgs;
     * import com.pulumi.alicloud.videosurveillance.VideosurveillanceFunctions;
     * import com.pulumi.alicloud.videosurveillance.inputs.GetSystemGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var defaultSystemGroup = new SystemGroup("defaultSystemGroup", SystemGroupArgs.builder()
     *             .groupName("groupname")
     *             .inProtocol("rtmp")
     *             .outProtocol("flv")
     *             .playDomain("your_plan_domain")
     *             .pushDomain("your_push_domain")
     *             .build());
     *         final var default = VideosurveillanceFunctions.getSystemGroups(GetSystemGroupsArgs.builder()
     *             .ids(defaultSystemGroup.id())
     *             .build());
     *         ctx.export("vsGroup", default_.applyValue(default_ -> default_.ids()[0]));
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   defaultSystemGroup:
     *     type: alicloud:videosurveillance:SystemGroup
     *     name: default
     *     properties:
     *       groupName: groupname
     *       inProtocol: rtmp
     *       outProtocol: flv
     *       playDomain: your_plan_domain
     *       pushDomain: your_push_domain
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:videosurveillance:getSystemGroups
     *       Arguments:
     *         ids:
     *           - ${defaultSystemGroup.id}
     * outputs:
     *   vsGroup: ${default.ids[0]}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSystemGroups.
     * @return A collection of values returned by getSystemGroups.
     */
    public suspend fun getSystemGroups(argument: GetSystemGroupsPlainArgs): GetSystemGroupsResult =
        getSystemGroupsResultToKotlin(getSystemGroupsPlain(argument.toJava()).await())

    /**
     * @see [getSystemGroups].
     * @param ids A list of Group IDs.
     * @param inProtocol The use of the access protocol support gb28181, Real Time Messaging Protocol (rtmp). Valid values: `gb28181`, `rtmp`.
     * @param name The name.
     * @param nameRegex A regex string to filter results by Group name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status. Valid values: `on`,`off`.
     * @return A collection of values returned by getSystemGroups.
     */
    public suspend fun getSystemGroups(
        ids: List<String>? = null,
        inProtocol: String? = null,
        name: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetSystemGroupsResult {
        val argument = GetSystemGroupsPlainArgs(
            ids = ids,
            inProtocol = inProtocol,
            name = name,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return getSystemGroupsResultToKotlin(getSystemGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getSystemGroups].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;videosurveillance&#46;kotlin&#46;inputs&#46;GetSystemGroupsPlainArgs].
     * @return A collection of values returned by getSystemGroups.
     */
    public suspend fun getSystemGroups(argument: suspend GetSystemGroupsPlainArgsBuilder.() -> Unit): GetSystemGroupsResult {
        val builder = GetSystemGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSystemGroupsResultToKotlin(getSystemGroupsPlain(builtArgument.toJava()).await())
    }
}
