@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.videosurveillance.kotlin.inputs

import com.pulumi.alicloud.videosurveillance.inputs.GetSystemGroupsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSystemGroups.
 * @property ids A list of Group IDs.
 * @property inProtocol The use of the access protocol support gb28181, Real Time Messaging Protocol (rtmp). Valid values: `gb28181`, `rtmp`.
 * @property name The name.
 * @property nameRegex A regex string to filter results by Group name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status. Valid values: `on`,`off`.
 */
public data class GetSystemGroupsPlainArgs(
    public val ids: List<String>? = null,
    public val inProtocol: String? = null,
    public val name: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.videosurveillance.inputs.GetSystemGroupsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.videosurveillance.inputs.GetSystemGroupsPlainArgs =
        com.pulumi.alicloud.videosurveillance.inputs.GetSystemGroupsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .inProtocol(inProtocol?.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSystemGroupsPlainArgs].
 */
@PulumiTagMarker
public class GetSystemGroupsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var inProtocol: String? = null

    private var name: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value A list of Group IDs.
     */
    @JvmName("evdmsyxhbhnvjrgl")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Group IDs.
     */
    @JvmName("hldftiqsbakmrpqh")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The use of the access protocol support gb28181, Real Time Messaging Protocol (rtmp). Valid values: `gb28181`, `rtmp`.
     */
    @JvmName("jjfnimgpttgqtbql")
    public suspend fun inProtocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.inProtocol = mapped
    }

    /**
     * @param value The name.
     */
    @JvmName("wrscsmgkoqpqhrlh")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value A regex string to filter results by Group name.
     */
    @JvmName("gjtprnxoprlhiigm")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ugnofxndjxtuovea")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status. Valid values: `on`,`off`.
     */
    @JvmName("xnwcukqcqjmsdogq")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetSystemGroupsPlainArgs = GetSystemGroupsPlainArgs(
        ids = ids,
        inProtocol = inProtocol,
        name = name,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
    )
}
