@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.videosurveillance.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property app The App Name of Group.
 * @property callback The space within the device status update of the callback, need to start with http:// or https:// at the beginning.
 * @property createTime The creation time of the Group.
 * @property description The description of the Group.
 * @property enabled Whether to open Group.
 * @property gbId Space of national standard ID. **NOTE:** Available only in the national standard access space.
 * @property gbIp Space of national standard signaling server address. **NOTE:** Available only in the national standard access space.
 * @property groupId The ID of Group.
 * @property groupName The name of Group.
 * @property id The ID of the Group.
 * @property inProtocol The use of the access protocol support `gb28181`,`rtmp`(Real Time Messaging Protocol).
 * @property outProtocol The use of space play Protocol multi-valued separate them with commas (,). Valid values: `flv`,`hls`, `rtmp`(Real Time Messaging Protocol).
 * @property playDomain The domain name of plan streaming used by the group.
 * @property pushDomain The domain name of push streaming used by the group.
 * @property stats The Device statistics of Group.
 */
public data class GetSystemGroupsGroup(
    public val app: String,
    public val callback: String,
    public val createTime: String,
    public val description: String,
    public val enabled: Boolean,
    public val gbId: String,
    public val gbIp: String,
    public val groupId: String,
    public val groupName: String,
    public val id: String,
    public val inProtocol: String,
    public val outProtocol: String,
    public val playDomain: String,
    public val pushDomain: String,
    public val stats: List<GetSystemGroupsGroupStat>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.videosurveillance.outputs.GetSystemGroupsGroup): GetSystemGroupsGroup = GetSystemGroupsGroup(
            app = javaType.app(),
            callback = javaType.callback(),
            createTime = javaType.createTime(),
            description = javaType.description(),
            enabled = javaType.enabled(),
            gbId = javaType.gbId(),
            gbIp = javaType.gbIp(),
            groupId = javaType.groupId(),
            groupName = javaType.groupName(),
            id = javaType.id(),
            inProtocol = javaType.inProtocol(),
            outProtocol = javaType.outProtocol(),
            playDomain = javaType.playDomain(),
            pushDomain = javaType.pushDomain(),
            stats = javaType.stats().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.videosurveillance.kotlin.outputs.GetSystemGroupsGroupStat.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
