@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.videosurveillance.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getSystemGroups.
 * @property groups
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property inProtocol
 * @property name
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property status
 */
public data class GetSystemGroupsResult(
    public val groups: List<GetSystemGroupsGroup>,
    public val id: String,
    public val ids: List<String>,
    public val inProtocol: String? = null,
    public val name: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.videosurveillance.outputs.GetSystemGroupsResult): GetSystemGroupsResult = GetSystemGroupsResult(
            groups = javaType.groups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.videosurveillance.kotlin.outputs.GetSystemGroupsGroup.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            inProtocol = javaType.inProtocol().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
