@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vod.kotlin

import com.pulumi.alicloud.vod.kotlin.outputs.DomainSource
import com.pulumi.alicloud.vod.kotlin.outputs.DomainSource.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Domain].
 */
@PulumiTagMarker
public class DomainResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainArgs = DomainArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainArgsBuilder.() -> Unit) {
        val builder = DomainArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Domain {
        val builtJavaResource = com.pulumi.alicloud.vod.Domain(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Domain(builtJavaResource)
    }
}

/**
 * Provides a VOD Domain resource.
 * For information about VOD Domain and how to use it, see [What is Domain](https://www.alibabacloud.com/help/product/29932.html).
 * > **NOTE:** Available since v1.136.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const defaultDomain = new alicloud.vod.Domain("default", {
 *     domainName: `example-${_default.result}.com`,
 *     scope: "domestic",
 *     sources: [{
 *         sourceType: "domain",
 *         sourceContent: "outin-c7405446108111ec9a7100163e0eb78b.oss-cn-beijing.aliyuncs.com",
 *         sourcePort: "443",
 *     }],
 *     tags: {
 *         Created: "terraform",
 *         For: "example",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * default_domain = alicloud.vod.Domain("default",
 *     domain_name=f"example-{default['result']}.com",
 *     scope="domestic",
 *     sources=[{
 *         "source_type": "domain",
 *         "source_content": "outin-c7405446108111ec9a7100163e0eb78b.oss-cn-beijing.aliyuncs.com",
 *         "source_port": "443",
 *     }],
 *     tags={
 *         "Created": "terraform",
 *         "For": "example",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var defaultDomain = new AliCloud.Vod.Domain("default", new()
 *     {
 *         DomainName = $"example-{@default.Result}.com",
 *         Scope = "domestic",
 *         Sources = new[]
 *         {
 *             new AliCloud.Vod.Inputs.DomainSourceArgs
 *             {
 *                 SourceType = "domain",
 *                 SourceContent = "outin-c7405446108111ec9a7100163e0eb78b.oss-cn-beijing.aliyuncs.com",
 *                 SourcePort = "443",
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Created", "terraform" },
 *             { "For", "example" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vod"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vod.NewDomain(ctx, "default", &vod.DomainArgs{
 * 			DomainName: pulumi.Sprintf("example-%v.com", _default.Result),
 * 			Scope:      pulumi.String("domestic"),
 * 			Sources: vod.DomainSourceArray{
 * 				&vod.DomainSourceArgs{
 * 					SourceType:    pulumi.String("domain"),
 * 					SourceContent: pulumi.String("outin-c7405446108111ec9a7100163e0eb78b.oss-cn-beijing.aliyuncs.com"),
 * 					SourcePort:    pulumi.String("443"),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("terraform"),
 * 				"For":     pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.vod.Domain;
 * import com.pulumi.alicloud.vod.DomainArgs;
 * import com.pulumi.alicloud.vod.inputs.DomainSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var defaultDomain = new Domain("defaultDomain", DomainArgs.builder()
 *             .domainName(String.format("example-%s.com", default_.result()))
 *             .scope("domestic")
 *             .sources(DomainSourceArgs.builder()
 *                 .sourceType("domain")
 *                 .sourceContent("outin-c7405446108111ec9a7100163e0eb78b.oss-cn-beijing.aliyuncs.com")
 *                 .sourcePort("443")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "terraform"),
 *                 Map.entry("For", "example")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultDomain:
 *     type: alicloud:vod:Domain
 *     name: default
 *     properties:
 *       domainName: example-${default.result}.com
 *       scope: domestic
 *       sources:
 *         - sourceType: domain
 *           sourceContent: outin-c7405446108111ec9a7100163e0eb78b.oss-cn-beijing.aliyuncs.com
 *           sourcePort: '443'
 *       tags:
 *         Created: terraform
 *         For: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * VOD Domain can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vod/domain:Domain example <domain_name>
 * ```
 */
public class Domain internal constructor(
    override val javaResource: com.pulumi.alicloud.vod.Domain,
) : KotlinCustomResource(javaResource, DomainMapper) {
    /**
     * The name of the certificate. The value of this parameter is returned if HTTPS is enabled.
     */
    public val certName: Output<String>
        get() = javaResource.certName().applyValue({ args0 -> args0 })

    /**
     * The URL that is used for health checks.
     */
    public val checkUrl: Output<String>?
        get() = javaResource.checkUrl().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The CNAME that is assigned to the domain name for CDN. You must add a CNAME record in the system of your Domain Name System (DNS) service provider to map the domain name for CDN to the CNAME.
     */
    public val cname: Output<String>
        get() = javaResource.cname().applyValue({ args0 -> args0 })

    /**
     * The description of the domain name for CDN.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * The domain name for CDN that you want to add to ApsaraVideo VOD. Wildcard domain names are supported. Start the domain name with a period (.). Example: `.example.com.`.
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    /**
     * The time when the domain name for CDN was added. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
     */
    public val gmtCreated: Output<String>
        get() = javaResource.gmtCreated().applyValue({ args0 -> args0 })

    /**
     * The last time when the domain name for CDN was modified. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
     */
    public val gmtModified: Output<String>
        get() = javaResource.gmtModified().applyValue({ args0 -> args0 })

    /**
     * This parameter is applicable to users of level 3 or higher in mainland China and users outside mainland China. Valid values:
     */
    public val scope: Output<String>?
        get() = javaResource.scope().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The information about the address of the origin server. For more information about the Sources parameter, See the following `Block sources`.
     */
    public val sources: Output<List<DomainSource>>
        get() = javaResource.sources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * Indicates whether the Secure Sockets Layer (SSL) certificate is enabled. Valid values: `on`,`off`.
     */
    public val sslProtocol: Output<String>
        get() = javaResource.sslProtocol().applyValue({ args0 -> args0 })

    /**
     * The public key of the certificate. The value of this parameter is returned if HTTPS is enabled.
     */
    public val sslPub: Output<String>
        get() = javaResource.sslPub().applyValue({ args0 -> args0 })

    /**
     * The status of the domain name for CDN. Valid values:
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     * * `Key`: It can be up to 64 characters in length. It cannot be a null string.
     * * `Value`: It can be up to 128 characters in length. It can be a null string.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The top-level domain name.
     */
    public val topLevelDomain: Output<String>?
        get() = javaResource.topLevelDomain().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The weight of the origin server.
     */
    public val weight: Output<String>
        get() = javaResource.weight().applyValue({ args0 -> args0 })
}

public object DomainMapper : ResourceMapper<Domain> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.vod.Domain::class == javaResource::class

    override fun map(javaResource: Resource): Domain = Domain(
        javaResource as
            com.pulumi.alicloud.vod.Domain,
    )
}

/**
 * @see [Domain].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Domain].
 */
public suspend fun domain(name: String, block: suspend DomainResourceBuilder.() -> Unit): Domain {
    val builder = DomainResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Domain].
 * @param name The _unique_ name of the resulting resource.
 */
public fun domain(name: String): Domain {
    val builder = DomainResourceBuilder()
    builder.name(name)
    return builder.build()
}
