@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vod.kotlin

import com.pulumi.alicloud.vod.DomainArgs.builder
import com.pulumi.alicloud.vod.kotlin.inputs.DomainSourceArgs
import com.pulumi.alicloud.vod.kotlin.inputs.DomainSourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a VOD Domain resource.
 * For information about VOD Domain and how to use it, see [What is Domain](https://www.alibabacloud.com/help/product/29932.html).
 * > **NOTE:** Available since v1.136.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const defaultDomain = new alicloud.vod.Domain("default", {
 *     domainName: `example-${_default.result}.com`,
 *     scope: "domestic",
 *     sources: [{
 *         sourceType: "domain",
 *         sourceContent: "outin-c7405446108111ec9a7100163e0eb78b.oss-cn-beijing.aliyuncs.com",
 *         sourcePort: "443",
 *     }],
 *     tags: {
 *         Created: "terraform",
 *         For: "example",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * default_domain = alicloud.vod.Domain("default",
 *     domain_name=f"example-{default['result']}.com",
 *     scope="domestic",
 *     sources=[{
 *         "source_type": "domain",
 *         "source_content": "outin-c7405446108111ec9a7100163e0eb78b.oss-cn-beijing.aliyuncs.com",
 *         "source_port": "443",
 *     }],
 *     tags={
 *         "Created": "terraform",
 *         "For": "example",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var defaultDomain = new AliCloud.Vod.Domain("default", new()
 *     {
 *         DomainName = $"example-{@default.Result}.com",
 *         Scope = "domestic",
 *         Sources = new[]
 *         {
 *             new AliCloud.Vod.Inputs.DomainSourceArgs
 *             {
 *                 SourceType = "domain",
 *                 SourceContent = "outin-c7405446108111ec9a7100163e0eb78b.oss-cn-beijing.aliyuncs.com",
 *                 SourcePort = "443",
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Created", "terraform" },
 *             { "For", "example" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vod"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vod.NewDomain(ctx, "default", &vod.DomainArgs{
 * 			DomainName: pulumi.Sprintf("example-%v.com", _default.Result),
 * 			Scope:      pulumi.String("domestic"),
 * 			Sources: vod.DomainSourceArray{
 * 				&vod.DomainSourceArgs{
 * 					SourceType:    pulumi.String("domain"),
 * 					SourceContent: pulumi.String("outin-c7405446108111ec9a7100163e0eb78b.oss-cn-beijing.aliyuncs.com"),
 * 					SourcePort:    pulumi.String("443"),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Created": pulumi.String("terraform"),
 * 				"For":     pulumi.String("example"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.vod.Domain;
 * import com.pulumi.alicloud.vod.DomainArgs;
 * import com.pulumi.alicloud.vod.inputs.DomainSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var defaultDomain = new Domain("defaultDomain", DomainArgs.builder()
 *             .domainName(String.format("example-%s.com", default_.result()))
 *             .scope("domestic")
 *             .sources(DomainSourceArgs.builder()
 *                 .sourceType("domain")
 *                 .sourceContent("outin-c7405446108111ec9a7100163e0eb78b.oss-cn-beijing.aliyuncs.com")
 *                 .sourcePort("443")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Created", "terraform"),
 *                 Map.entry("For", "example")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultDomain:
 *     type: alicloud:vod:Domain
 *     name: default
 *     properties:
 *       domainName: example-${default.result}.com
 *       scope: domestic
 *       sources:
 *         - sourceType: domain
 *           sourceContent: outin-c7405446108111ec9a7100163e0eb78b.oss-cn-beijing.aliyuncs.com
 *           sourcePort: '443'
 *       tags:
 *         Created: terraform
 *         For: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * VOD Domain can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vod/domain:Domain example <domain_name>
 * ```
 * @property checkUrl The URL that is used for health checks.
 * @property domainName The domain name for CDN that you want to add to ApsaraVideo VOD. Wildcard domain names are supported. Start the domain name with a period (.). Example: `.example.com.`.
 * @property scope This parameter is applicable to users of level 3 or higher in mainland China and users outside mainland China. Valid values:
 * @property sources The information about the address of the origin server. For more information about the Sources parameter, See the following `Block sources`.
 * @property tags A mapping of tags to assign to the resource.
 * * `Key`: It can be up to 64 characters in length. It cannot be a null string.
 * * `Value`: It can be up to 128 characters in length. It can be a null string.
 * @property topLevelDomain The top-level domain name.
 */
public data class DomainArgs(
    public val checkUrl: Output<String>? = null,
    public val domainName: Output<String>? = null,
    public val scope: Output<String>? = null,
    public val sources: Output<List<DomainSourceArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val topLevelDomain: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vod.DomainArgs> {
    override fun toJava(): com.pulumi.alicloud.vod.DomainArgs =
        com.pulumi.alicloud.vod.DomainArgs.builder()
            .checkUrl(checkUrl?.applyValue({ args0 -> args0 }))
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .scope(scope?.applyValue({ args0 -> args0 }))
            .sources(
                sources?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .topLevelDomain(topLevelDomain?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainArgs].
 */
@PulumiTagMarker
public class DomainArgsBuilder internal constructor() {
    private var checkUrl: Output<String>? = null

    private var domainName: Output<String>? = null

    private var scope: Output<String>? = null

    private var sources: Output<List<DomainSourceArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var topLevelDomain: Output<String>? = null

    /**
     * @param value The URL that is used for health checks.
     */
    @JvmName("fwneqecpkvnwuonk")
    public suspend fun checkUrl(`value`: Output<String>) {
        this.checkUrl = value
    }

    /**
     * @param value The domain name for CDN that you want to add to ApsaraVideo VOD. Wildcard domain names are supported. Start the domain name with a period (.). Example: `.example.com.`.
     */
    @JvmName("eijypdfljsmkynbt")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value This parameter is applicable to users of level 3 or higher in mainland China and users outside mainland China. Valid values:
     */
    @JvmName("wmnwipuowdnypkta")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value The information about the address of the origin server. For more information about the Sources parameter, See the following `Block sources`.
     */
    @JvmName("jnfcmhgduybiwjsn")
    public suspend fun sources(`value`: Output<List<DomainSourceArgs>>) {
        this.sources = value
    }

    @JvmName("nffgieksvncxsjet")
    public suspend fun sources(vararg values: Output<DomainSourceArgs>) {
        this.sources = Output.all(values.asList())
    }

    /**
     * @param values The information about the address of the origin server. For more information about the Sources parameter, See the following `Block sources`.
     */
    @JvmName("qlmxcuyapbcimjej")
    public suspend fun sources(values: List<Output<DomainSourceArgs>>) {
        this.sources = Output.all(values)
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     * * `Key`: It can be up to 64 characters in length. It cannot be a null string.
     * * `Value`: It can be up to 128 characters in length. It can be a null string.
     */
    @JvmName("rbqvdjkovrbicskl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The top-level domain name.
     */
    @JvmName("egvqkhdjjmbhyiww")
    public suspend fun topLevelDomain(`value`: Output<String>) {
        this.topLevelDomain = value
    }

    /**
     * @param value The URL that is used for health checks.
     */
    @JvmName("dhvbvrtqxvsudspx")
    public suspend fun checkUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.checkUrl = mapped
    }

    /**
     * @param value The domain name for CDN that you want to add to ApsaraVideo VOD. Wildcard domain names are supported. Start the domain name with a period (.). Example: `.example.com.`.
     */
    @JvmName("vcxknkqwjxftbhfg")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value This parameter is applicable to users of level 3 or higher in mainland China and users outside mainland China. Valid values:
     */
    @JvmName("mefxcmjcrntgyvfc")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value The information about the address of the origin server. For more information about the Sources parameter, See the following `Block sources`.
     */
    @JvmName("qroxfgyvwvsnabxm")
    public suspend fun sources(`value`: List<DomainSourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    /**
     * @param argument The information about the address of the origin server. For more information about the Sources parameter, See the following `Block sources`.
     */
    @JvmName("oypadlvmifcfgval")
    public suspend fun sources(argument: List<suspend DomainSourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DomainSourceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param argument The information about the address of the origin server. For more information about the Sources parameter, See the following `Block sources`.
     */
    @JvmName("xjmhxrjdgqesppxc")
    public suspend fun sources(vararg argument: suspend DomainSourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DomainSourceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param argument The information about the address of the origin server. For more information about the Sources parameter, See the following `Block sources`.
     */
    @JvmName("rsehryewfhsbuupj")
    public suspend fun sources(argument: suspend DomainSourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DomainSourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param values The information about the address of the origin server. For more information about the Sources parameter, See the following `Block sources`.
     */
    @JvmName("xidfyiwtsihwdiid")
    public suspend fun sources(vararg values: DomainSourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     * * `Key`: It can be up to 64 characters in length. It cannot be a null string.
     * * `Value`: It can be up to 128 characters in length. It can be a null string.
     */
    @JvmName("qvqhrykoqwffyiai")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     * * `Key`: It can be up to 64 characters in length. It cannot be a null string.
     * * `Value`: It can be up to 128 characters in length. It can be a null string.
     */
    @JvmName("wptkelfhnehrcwli")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The top-level domain name.
     */
    @JvmName("gvpbpnsbevnmpbtb")
    public suspend fun topLevelDomain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topLevelDomain = mapped
    }

    internal fun build(): DomainArgs = DomainArgs(
        checkUrl = checkUrl,
        domainName = domainName,
        scope = scope,
        sources = sources,
        tags = tags,
        topLevelDomain = topLevelDomain,
    )
}
