@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vod.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EditingProject].
 */
@PulumiTagMarker
public class EditingProjectResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EditingProjectArgs = EditingProjectArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EditingProjectArgsBuilder.() -> Unit) {
        val builder = EditingProjectArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EditingProject {
        val builtJavaResource = com.pulumi.alicloud.vod.EditingProject(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EditingProject(builtJavaResource)
    }
}

/**
 * Provides a VOD Editing Project resource.
 * For information about VOD Editing Project and how to use it, see [What is Editing Project](https://www.alibabacloud.com/help/en/apsaravideo-for-vod/latest/addeditingproject#doc-api-vod-AddEditingProject).
 * > **NOTE:** Available since v1.187.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tfexample";
 * const default = alicloud.getRegions({
 *     current: true,
 * });
 * const example = new alicloud.vod.EditingProject("example", {
 *     editingProjectName: name,
 *     title: name,
 *     timeline: `  {
 *     "VideoTracks":[
 *       {
 *         "VideoTrackClips":[
 *           {
 *           "MediaId":"0c60e6f02dae71edbfaa472190a90102",
 *           "In":2811
 *           }
 *         ]
 *       }
 *     ]
 *   }
 * `,
 *     coverUrl: "https://demo.aliyundoc.com/6AB4D0E1E1C74468883516C2349D1FC2-6-2.png",
 *     division: _default.then(_default => _default.regions?.[0]?.id),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tfexample"
 * default = alicloud.get_regions(current=True)
 * example = alicloud.vod.EditingProject("example",
 *     editing_project_name=name,
 *     title=name,
 *     timeline="""  {
 *     "VideoTracks":[
 *       {
 *         "VideoTrackClips":[
 *           {
 *           "MediaId":"0c60e6f02dae71edbfaa472190a90102",
 *           "In":2811
 *           }
 *         ]
 *       }
 *     ]
 *   }
 * """,
 *     cover_url="https://demo.aliyundoc.com/6AB4D0E1E1C74468883516C2349D1FC2-6-2.png",
 *     division=default.regions[0].id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tfexample";
 *     var @default = AliCloud.GetRegions.Invoke(new()
 *     {
 *         Current = true,
 *     });
 *     var example = new AliCloud.Vod.EditingProject("example", new()
 *     {
 *         EditingProjectName = name,
 *         Title = name,
 *         Timeline = @"  {
 *     ""VideoTracks"":[
 *       {
 *         ""VideoTrackClips"":[
 *           {
 *           ""MediaId"":""0c60e6f02dae71edbfaa472190a90102"",
 *           ""In"":2811
 *           }
 *         ]
 *       }
 *     ]
 *   }
 * ",
 *         CoverUrl = "https://demo.aliyundoc.com/6AB4D0E1E1C74468883516C2349D1FC2-6-2.png",
 *         Division = @default.Apply(@default => @default.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id)),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vod"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tfexample"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetRegions(ctx, &alicloud.GetRegionsArgs{
 * 			Current: pulumi.BoolRef(true),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vod.NewEditingProject(ctx, "example", &vod.EditingProjectArgs{
 * 			EditingProjectName: pulumi.String(name),
 * 			Title:              pulumi.String(name),
 * 			Timeline: pulumi.String(`  {
 *     "VideoTracks":[
 *       {
 *         "VideoTrackClips":[
 *           {
 *           "MediaId":"0c60e6f02dae71edbfaa472190a90102",
 *           "In":2811
 *           }
 *         ]
 *       }
 *     ]
 *   }
 * `),
 * 			CoverUrl: pulumi.String("https://demo.aliyundoc.com/6AB4D0E1E1C74468883516C2349D1FC2-6-2.png"),
 * 			Division: pulumi.String(_default.Regions[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetRegionsArgs;
 * import com.pulumi.alicloud.vod.EditingProject;
 * import com.pulumi.alicloud.vod.EditingProjectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tfexample");
 *         final var default = AlicloudFunctions.getRegions(GetRegionsArgs.builder()
 *             .current(true)
 *             .build());
 *         var example = new EditingProject("example", EditingProjectArgs.builder()
 *             .editingProjectName(name)
 *             .title(name)
 *             .timeline("""
 *   {
 *     "VideoTracks":[
 *       {
 *         "VideoTrackClips":[
 *           {
 *           "MediaId":"0c60e6f02dae71edbfaa472190a90102",
 *           "In":2811
 *           }
 *         ]
 *       }
 *     ]
 *   }
 *             """)
 *             .coverUrl("https://demo.aliyundoc.com/6AB4D0E1E1C74468883516C2349D1FC2-6-2.png")
 *             .division(default_.regions()[0].id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tfexample
 * resources:
 *   example:
 *     type: alicloud:vod:EditingProject
 *     properties:
 *       editingProjectName: ${name}
 *       title: ${name}
 *       timeline: |2
 *           {
 *             "VideoTracks":[
 *               {
 *                 "VideoTrackClips":[
 *                   {
 *                   "MediaId":"0c60e6f02dae71edbfaa472190a90102",
 *                   "In":2811
 *                   }
 *                 ]
 *               }
 *             ]
 *           }
 *       coverUrl: https://demo.aliyundoc.com/6AB4D0E1E1C74468883516C2349D1FC2-6-2.png
 *       division: ${default.regions[0].id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getRegions
 *       Arguments:
 *         current: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * VOD Editing Project can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vod/editingProject:EditingProject example <id>
 * ```
 */
public class EditingProject internal constructor(
    override val javaResource: com.pulumi.alicloud.vod.EditingProject,
) : KotlinCustomResource(javaResource, EditingProjectMapper) {
    /**
     * The thumbnail URL of the online editing project. If you do not specify this parameter and the video track in the timeline has mezzanine files, the thumbnail of the first mezzanine file in the timeline is used.
     */
    public val coverUrl: Output<String>?
        get() = javaResource.coverUrl().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The region where you want to create the online editing project.
     */
    public val division: Output<String>?
        get() = javaResource.division().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The description of the online editing project.
     */
    public val editingProjectName: Output<String>
        get() = javaResource.editingProjectName().applyValue({ args0 -> args0 })

    /**
     * The Status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The timeline of the online editing project, in JSON format. For more information about the structure, see [Timeline](https://www.alibabacloud.com/help/en/apsaravideo-for-vod/latest/basic-structures). If you do not specify this parameter, an empty timeline is created and the duration of the online editing project is zero.
     */
    public val timeline: Output<String>
        get() = javaResource.timeline().applyValue({ args0 -> args0 })

    /**
     * The title of the online editing project.
     */
    public val title: Output<String>
        get() = javaResource.title().applyValue({ args0 -> args0 })
}

public object EditingProjectMapper : ResourceMapper<EditingProject> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.vod.EditingProject::class == javaResource::class

    override fun map(javaResource: Resource): EditingProject = EditingProject(
        javaResource as
            com.pulumi.alicloud.vod.EditingProject,
    )
}

/**
 * @see [EditingProject].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EditingProject].
 */
public suspend fun editingProject(
    name: String,
    block: suspend EditingProjectResourceBuilder.() -> Unit,
): EditingProject {
    val builder = EditingProjectResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EditingProject].
 * @param name The _unique_ name of the resulting resource.
 */
public fun editingProject(name: String): EditingProject {
    val builder = EditingProjectResourceBuilder()
    builder.name(name)
    return builder.build()
}
