@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vod.kotlin

import com.pulumi.alicloud.vod.EditingProjectArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a VOD Editing Project resource.
 * For information about VOD Editing Project and how to use it, see [What is Editing Project](https://www.alibabacloud.com/help/en/apsaravideo-for-vod/latest/addeditingproject#doc-api-vod-AddEditingProject).
 * > **NOTE:** Available since v1.187.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tfexample";
 * const default = alicloud.getRegions({
 *     current: true,
 * });
 * const example = new alicloud.vod.EditingProject("example", {
 *     editingProjectName: name,
 *     title: name,
 *     timeline: `  {
 *     "VideoTracks":[
 *       {
 *         "VideoTrackClips":[
 *           {
 *           "MediaId":"0c60e6f02dae71edbfaa472190a90102",
 *           "In":2811
 *           }
 *         ]
 *       }
 *     ]
 *   }
 * `,
 *     coverUrl: "https://demo.aliyundoc.com/6AB4D0E1E1C74468883516C2349D1FC2-6-2.png",
 *     division: _default.then(_default => _default.regions?.[0]?.id),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tfexample"
 * default = alicloud.get_regions(current=True)
 * example = alicloud.vod.EditingProject("example",
 *     editing_project_name=name,
 *     title=name,
 *     timeline="""  {
 *     "VideoTracks":[
 *       {
 *         "VideoTrackClips":[
 *           {
 *           "MediaId":"0c60e6f02dae71edbfaa472190a90102",
 *           "In":2811
 *           }
 *         ]
 *       }
 *     ]
 *   }
 * """,
 *     cover_url="https://demo.aliyundoc.com/6AB4D0E1E1C74468883516C2349D1FC2-6-2.png",
 *     division=default.regions[0].id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tfexample";
 *     var @default = AliCloud.GetRegions.Invoke(new()
 *     {
 *         Current = true,
 *     });
 *     var example = new AliCloud.Vod.EditingProject("example", new()
 *     {
 *         EditingProjectName = name,
 *         Title = name,
 *         Timeline = @"  {
 *     ""VideoTracks"":[
 *       {
 *         ""VideoTrackClips"":[
 *           {
 *           ""MediaId"":""0c60e6f02dae71edbfaa472190a90102"",
 *           ""In"":2811
 *           }
 *         ]
 *       }
 *     ]
 *   }
 * ",
 *         CoverUrl = "https://demo.aliyundoc.com/6AB4D0E1E1C74468883516C2349D1FC2-6-2.png",
 *         Division = @default.Apply(@default => @default.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id)),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vod"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tfexample"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetRegions(ctx, &alicloud.GetRegionsArgs{
 * 			Current: pulumi.BoolRef(true),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vod.NewEditingProject(ctx, "example", &vod.EditingProjectArgs{
 * 			EditingProjectName: pulumi.String(name),
 * 			Title:              pulumi.String(name),
 * 			Timeline: pulumi.String(`  {
 *     "VideoTracks":[
 *       {
 *         "VideoTrackClips":[
 *           {
 *           "MediaId":"0c60e6f02dae71edbfaa472190a90102",
 *           "In":2811
 *           }
 *         ]
 *       }
 *     ]
 *   }
 * `),
 * 			CoverUrl: pulumi.String("https://demo.aliyundoc.com/6AB4D0E1E1C74468883516C2349D1FC2-6-2.png"),
 * 			Division: pulumi.String(_default.Regions[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetRegionsArgs;
 * import com.pulumi.alicloud.vod.EditingProject;
 * import com.pulumi.alicloud.vod.EditingProjectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tfexample");
 *         final var default = AlicloudFunctions.getRegions(GetRegionsArgs.builder()
 *             .current(true)
 *             .build());
 *         var example = new EditingProject("example", EditingProjectArgs.builder()
 *             .editingProjectName(name)
 *             .title(name)
 *             .timeline("""
 *   {
 *     "VideoTracks":[
 *       {
 *         "VideoTrackClips":[
 *           {
 *           "MediaId":"0c60e6f02dae71edbfaa472190a90102",
 *           "In":2811
 *           }
 *         ]
 *       }
 *     ]
 *   }
 *             """)
 *             .coverUrl("https://demo.aliyundoc.com/6AB4D0E1E1C74468883516C2349D1FC2-6-2.png")
 *             .division(default_.regions()[0].id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tfexample
 * resources:
 *   example:
 *     type: alicloud:vod:EditingProject
 *     properties:
 *       editingProjectName: ${name}
 *       title: ${name}
 *       timeline: |2
 *           {
 *             "VideoTracks":[
 *               {
 *                 "VideoTrackClips":[
 *                   {
 *                   "MediaId":"0c60e6f02dae71edbfaa472190a90102",
 *                   "In":2811
 *                   }
 *                 ]
 *               }
 *             ]
 *           }
 *       coverUrl: https://demo.aliyundoc.com/6AB4D0E1E1C74468883516C2349D1FC2-6-2.png
 *       division: ${default.regions[0].id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getRegions
 *       Arguments:
 *         current: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * VOD Editing Project can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vod/editingProject:EditingProject example <id>
 * ```
 * @property coverUrl The thumbnail URL of the online editing project. If you do not specify this parameter and the video track in the timeline has mezzanine files, the thumbnail of the first mezzanine file in the timeline is used.
 * @property division The region where you want to create the online editing project.
 * @property editingProjectName The description of the online editing project.
 * @property timeline The timeline of the online editing project, in JSON format. For more information about the structure, see [Timeline](https://www.alibabacloud.com/help/en/apsaravideo-for-vod/latest/basic-structures). If you do not specify this parameter, an empty timeline is created and the duration of the online editing project is zero.
 * @property title The title of the online editing project.
 */
public data class EditingProjectArgs(
    public val coverUrl: Output<String>? = null,
    public val division: Output<String>? = null,
    public val editingProjectName: Output<String>? = null,
    public val timeline: Output<String>? = null,
    public val title: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vod.EditingProjectArgs> {
    override fun toJava(): com.pulumi.alicloud.vod.EditingProjectArgs =
        com.pulumi.alicloud.vod.EditingProjectArgs.builder()
            .coverUrl(coverUrl?.applyValue({ args0 -> args0 }))
            .division(division?.applyValue({ args0 -> args0 }))
            .editingProjectName(editingProjectName?.applyValue({ args0 -> args0 }))
            .timeline(timeline?.applyValue({ args0 -> args0 }))
            .title(title?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EditingProjectArgs].
 */
@PulumiTagMarker
public class EditingProjectArgsBuilder internal constructor() {
    private var coverUrl: Output<String>? = null

    private var division: Output<String>? = null

    private var editingProjectName: Output<String>? = null

    private var timeline: Output<String>? = null

    private var title: Output<String>? = null

    /**
     * @param value The thumbnail URL of the online editing project. If you do not specify this parameter and the video track in the timeline has mezzanine files, the thumbnail of the first mezzanine file in the timeline is used.
     */
    @JvmName("exjkytehdntvfikq")
    public suspend fun coverUrl(`value`: Output<String>) {
        this.coverUrl = value
    }

    /**
     * @param value The region where you want to create the online editing project.
     */
    @JvmName("ufoydpwmnrikxcpj")
    public suspend fun division(`value`: Output<String>) {
        this.division = value
    }

    /**
     * @param value The description of the online editing project.
     */
    @JvmName("losupagownsoratr")
    public suspend fun editingProjectName(`value`: Output<String>) {
        this.editingProjectName = value
    }

    /**
     * @param value The timeline of the online editing project, in JSON format. For more information about the structure, see [Timeline](https://www.alibabacloud.com/help/en/apsaravideo-for-vod/latest/basic-structures). If you do not specify this parameter, an empty timeline is created and the duration of the online editing project is zero.
     */
    @JvmName("qtkojnyvcjxlmfxw")
    public suspend fun timeline(`value`: Output<String>) {
        this.timeline = value
    }

    /**
     * @param value The title of the online editing project.
     */
    @JvmName("nnxgvfyiqqkakelp")
    public suspend fun title(`value`: Output<String>) {
        this.title = value
    }

    /**
     * @param value The thumbnail URL of the online editing project. If you do not specify this parameter and the video track in the timeline has mezzanine files, the thumbnail of the first mezzanine file in the timeline is used.
     */
    @JvmName("jiwwuwgmyqtrfxoe")
    public suspend fun coverUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coverUrl = mapped
    }

    /**
     * @param value The region where you want to create the online editing project.
     */
    @JvmName("svbrjalqskgrxwgc")
    public suspend fun division(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.division = mapped
    }

    /**
     * @param value The description of the online editing project.
     */
    @JvmName("dbpqoyhgduytesft")
    public suspend fun editingProjectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.editingProjectName = mapped
    }

    /**
     * @param value The timeline of the online editing project, in JSON format. For more information about the structure, see [Timeline](https://www.alibabacloud.com/help/en/apsaravideo-for-vod/latest/basic-structures). If you do not specify this parameter, an empty timeline is created and the duration of the online editing project is zero.
     */
    @JvmName("juickrsuvgnvgrmc")
    public suspend fun timeline(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeline = mapped
    }

    /**
     * @param value The title of the online editing project.
     */
    @JvmName("lomnsuvlimtcgcsd")
    public suspend fun title(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.title = mapped
    }

    internal fun build(): EditingProjectArgs = EditingProjectArgs(
        coverUrl = coverUrl,
        division = division,
        editingProjectName = editingProjectName,
        timeline = timeline,
        title = title,
    )
}
