@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vod.kotlin

import com.pulumi.alicloud.vod.VodFunctions.getDomainsPlain
import com.pulumi.alicloud.vod.kotlin.inputs.GetDomainsPlainArgs
import com.pulumi.alicloud.vod.kotlin.inputs.GetDomainsPlainArgsBuilder
import com.pulumi.alicloud.vod.kotlin.outputs.GetDomainsResult
import com.pulumi.alicloud.vod.kotlin.outputs.GetDomainsResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

public object VodFunctions {
    /**
     * This data source provides the Vod Domains of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.136.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const defaultDomain = new alicloud.vod.Domain("default", {
     *     domainName: "your_domain_name",
     *     scope: "domestic",
     *     sources: [{
     *         sourceType: "domain",
     *         sourceContent: "your_source_content",
     *         sourcePort: "80",
     *     }],
     *     tags: {
     *         key1: "value1",
     *         key2: "value2",
     *     },
     * });
     * const default = alicloud.vod.getDomainsOutput({
     *     ids: [defaultDomain&#46;id],
     *     tags: {
     *         key1: "value1",
     *         key2: "value2",
     *     },
     * });
     * export const vodDomain = _default.apply(_default => _default.domains?.[0]);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default_domain = alicloud.vod.Domain("default",
     *     domain_name="your_domain_name",
     *     scope="domestic",
     *     sources=[{
     *         "source_type": "domain",
     *         "source_content": "your_source_content",
     *         "source_port": "80",
     *     }],
     *     tags={
     *         "key1": "value1",
     *         "key2": "value2",
     *     })
     * default = alicloud.vod.get_domains_output(ids=[default_domain&#46;id],
     *     tags={
     *         "key1": "value1",
     *         "key2": "value2",
     *     })
     * pulumi.export("vodDomain", default.domains[0])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var defaultDomain = new AliCloud.Vod.Domain("default", new()
     *     {
     *         DomainName = "your_domain_name",
     *         Scope = "domestic",
     *         Sources = new[]
     *         {
     *             new AliCloud.Vod.Inputs.DomainSourceArgs
     *             {
     *                 SourceType = "domain",
     *                 SourceContent = "your_source_content",
     *                 SourcePort = "80",
     *             },
     *         },
     *         Tags =
     *         {
     *             { "key1", "value1" },
     *             { "key2", "value2" },
     *         },
     *     });
     *     var @default = AliCloud.Vod.GetDomains.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             defaultDomain.Id,
     *         },
     *         Tags =
     *         {
     *             { "key1", "value1" },
     *             { "key2", "value2" },
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["vodDomain"] = @default&#46;Apply(@default => @default&#46;Apply(getDomainsResult => getDomainsResult&#46;Domains[0])),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vod"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		defaultDomain, err := vod.NewDomain(ctx, "default", &vod.DomainArgs{
     * 			DomainName: pulumi.String("your_domain_name"),
     * 			Scope:      pulumi.String("domestic"),
     * 			Sources: vod.DomainSourceArray{
     * 				&vod.DomainSourceArgs{
     * 					SourceType:    pulumi.String("domain"),
     * 					SourceContent: pulumi.String("your_source_content"),
     * 					SourcePort:    pulumi.String("80"),
     * 				},
     * 			},
     * 			Tags: pulumi.StringMap{
     * 				"key1": pulumi.String("value1"),
     * 				"key2": pulumi.String("value2"),
     * 			},
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_default := vod.GetDomainsOutput(ctx, vod.GetDomainsOutputArgs{
     * 			Ids: pulumi.StringArray{
     * 				defaultDomain.ID(),
     * 			},
     * 			Tags: pulumi.StringMap{
     * 				"key1": pulumi.String("value1"),
     * 				"key2": pulumi.String("value2"),
     * 			},
     * 		}, nil)
     * 		ctx.Export("vodDomain", _default.ApplyT(func(_default vod.GetDomainsResult) (vod.GetDomainsDomain, error) {
     * 			return _default.Domains[0], nil
     * 		}).(vod.GetDomainsDomainOutput))
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.vod.Domain;
     * import com.pulumi.alicloud.vod.DomainArgs;
     * import com.pulumi.alicloud.vod.inputs.DomainSourceArgs;
     * import com.pulumi.alicloud.vod.VodFunctions;
     * import com.pulumi.alicloud.vod.inputs.GetDomainsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var defaultDomain = new Domain("defaultDomain", DomainArgs.builder()
     *             .domainName("your_domain_name")
     *             .scope("domestic")
     *             .sources(DomainSourceArgs.builder()
     *                 .sourceType("domain")
     *                 .sourceContent("your_source_content")
     *                 .sourcePort("80")
     *                 .build())
     *             .tags(Map.ofEntries(
     *                 Map.entry("key1", "value1"),
     *                 Map.entry("key2", "value2")
     *             ))
     *             .build());
     *         final var default = VodFunctions.getDomains(GetDomainsArgs.builder()
     *             .ids(defaultDomain.id())
     *             .tags(Map.ofEntries(
     *                 Map.entry("key1", "value1"),
     *                 Map.entry("key2", "value2")
     *             ))
     *             .build());
     *         ctx.export("vodDomain", default_.applyValue(default_ -> default_.domains()[0]));
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   defaultDomain:
     *     type: alicloud:vod:Domain
     *     name: default
     *     properties:
     *       domainName: your_domain_name
     *       scope: domestic
     *       sources:
     *         - sourceType: domain
     *           sourceContent: your_source_content
     *           sourcePort: '80'
     *       tags:
     *         key1: value1
     *         key2: value2
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:vod:getDomains
     *       Arguments:
     *         ids:
     *           - ${defaultDomain.id}
     *         tags:
     *           key1: value1
     *           key2: value2
     * outputs:
     *   vodDomain: ${default.domains[0]}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDomains.
     * @return A collection of values returned by getDomains.
     */
    public suspend fun getDomains(argument: GetDomainsPlainArgs): GetDomainsResult =
        toKotlin(getDomainsPlain(argument.toJava()).await())

    /**
     * @see [getDomains].
     * @param domainSearchType The search method. Valid values:
     * @param ids A list of Domain IDs. Its element value is same as Domain Name.
     * @param nameRegex A regex string to filter results by Domain name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the domain name. The value of this parameter is used as a condition to filter domain names.
     * @param tags A mapping of tags to assign to the resource.
     * * `Key`: It can be up to 64 characters in length. It cannot be a null string.
     * * `Value`: It can be up to 128 characters in length. It can be a null string.
     * @return A collection of values returned by getDomains.
     */
    public suspend fun getDomains(
        domainSearchType: String? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
        tags: Map<String, String>? = null,
    ): GetDomainsResult {
        val argument = GetDomainsPlainArgs(
            domainSearchType = domainSearchType,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
            tags = tags,
        )
        return toKotlin(getDomainsPlain(argument.toJava()).await())
    }

    /**
     * @see [getDomains].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;vod&#46;kotlin&#46;inputs&#46;GetDomainsPlainArgs].
     * @return A collection of values returned by getDomains.
     */
    public suspend fun getDomains(argument: suspend GetDomainsPlainArgsBuilder.() -> Unit): GetDomainsResult {
        val builder = GetDomainsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getDomainsPlain(builtArgument.toJava()).await())
    }
}
