@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vod.kotlin.inputs

import com.pulumi.alicloud.vod.inputs.DomainSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property sourceContent The address of the origin server. You can specify an IP address or a domain name.
 * @property sourcePort The port number. You can specify port 443 or 80. **Default value: 80**. If you specify port 443, Alibaba Cloud CDN communicates with the origin server over HTTPS. You can also customize a port.
 * @property sourcePriority The priority of the origin server if multiple origin servers are specified. Valid values: `20` and `30`. **Default value: 20**. A value of 20 indicates that the origin server is the primary origin server. A value of 30 indicates that the origin server is a secondary origin server.
 * @property sourceType The type of the origin server. Valid values:
 */
public data class DomainSourceArgs(
    public val sourceContent: Output<String>,
    public val sourcePort: Output<String>,
    public val sourcePriority: Output<String>? = null,
    public val sourceType: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.vod.inputs.DomainSourceArgs> {
    override fun toJava(): com.pulumi.alicloud.vod.inputs.DomainSourceArgs =
        com.pulumi.alicloud.vod.inputs.DomainSourceArgs.builder()
            .sourceContent(sourceContent.applyValue({ args0 -> args0 }))
            .sourcePort(sourcePort.applyValue({ args0 -> args0 }))
            .sourcePriority(sourcePriority?.applyValue({ args0 -> args0 }))
            .sourceType(sourceType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainSourceArgs].
 */
@PulumiTagMarker
public class DomainSourceArgsBuilder internal constructor() {
    private var sourceContent: Output<String>? = null

    private var sourcePort: Output<String>? = null

    private var sourcePriority: Output<String>? = null

    private var sourceType: Output<String>? = null

    /**
     * @param value The address of the origin server. You can specify an IP address or a domain name.
     */
    @JvmName("sctkakcckuxhumnd")
    public suspend fun sourceContent(`value`: Output<String>) {
        this.sourceContent = value
    }

    /**
     * @param value The port number. You can specify port 443 or 80. **Default value: 80**. If you specify port 443, Alibaba Cloud CDN communicates with the origin server over HTTPS. You can also customize a port.
     */
    @JvmName("xvwytexdmcnkqdfb")
    public suspend fun sourcePort(`value`: Output<String>) {
        this.sourcePort = value
    }

    /**
     * @param value The priority of the origin server if multiple origin servers are specified. Valid values: `20` and `30`. **Default value: 20**. A value of 20 indicates that the origin server is the primary origin server. A value of 30 indicates that the origin server is a secondary origin server.
     */
    @JvmName("xxvmutynauxojaar")
    public suspend fun sourcePriority(`value`: Output<String>) {
        this.sourcePriority = value
    }

    /**
     * @param value The type of the origin server. Valid values:
     */
    @JvmName("rsisafukrawfucxh")
    public suspend fun sourceType(`value`: Output<String>) {
        this.sourceType = value
    }

    /**
     * @param value The address of the origin server. You can specify an IP address or a domain name.
     */
    @JvmName("vmplhdlvaxuerrqs")
    public suspend fun sourceContent(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceContent = mapped
    }

    /**
     * @param value The port number. You can specify port 443 or 80. **Default value: 80**. If you specify port 443, Alibaba Cloud CDN communicates with the origin server over HTTPS. You can also customize a port.
     */
    @JvmName("lobmhkliexurthpd")
    public suspend fun sourcePort(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourcePort = mapped
    }

    /**
     * @param value The priority of the origin server if multiple origin servers are specified. Valid values: `20` and `30`. **Default value: 20**. A value of 20 indicates that the origin server is the primary origin server. A value of 30 indicates that the origin server is a secondary origin server.
     */
    @JvmName("jwmvugvwcnxmdrnx")
    public suspend fun sourcePriority(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourcePriority = mapped
    }

    /**
     * @param value The type of the origin server. Valid values:
     */
    @JvmName("qtaatkvclfppbdbl")
    public suspend fun sourceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceType = mapped
    }

    internal fun build(): DomainSourceArgs = DomainSourceArgs(
        sourceContent = sourceContent ?: throw PulumiNullFieldException("sourceContent"),
        sourcePort = sourcePort ?: throw PulumiNullFieldException("sourcePort"),
        sourcePriority = sourcePriority,
        sourceType = sourceType ?: throw PulumiNullFieldException("sourceType"),
    )
}
