@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vod.kotlin.inputs

import com.pulumi.alicloud.vod.inputs.GetDomainsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDomains.
 * @property domainSearchType The search method. Valid values:
 * @property ids A list of Domain IDs. Its element value is same as Domain Name.
 * @property nameRegex A regex string to filter results by Domain name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the domain name. The value of this parameter is used as a condition to filter domain names.
 * @property tags A mapping of tags to assign to the resource.
 * * `Key`: It can be up to 64 characters in length. It cannot be a null string.
 * * `Value`: It can be up to 128 characters in length. It can be a null string.
 */
public data class GetDomainsPlainArgs(
    public val domainSearchType: String? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vod.inputs.GetDomainsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.vod.inputs.GetDomainsPlainArgs =
        com.pulumi.alicloud.vod.inputs.GetDomainsPlainArgs.builder()
            .domainSearchType(domainSearchType?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetDomainsPlainArgs].
 */
@PulumiTagMarker
public class GetDomainsPlainArgsBuilder internal constructor() {
    private var domainSearchType: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value The search method. Valid values:
     */
    @JvmName("nvlaqhngiswwfwxa")
    public suspend fun domainSearchType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.domainSearchType = mapped
    }

    /**
     * @param value A list of Domain IDs. Its element value is same as Domain Name.
     */
    @JvmName("ipqnuahhojpfohhu")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Domain IDs. Its element value is same as Domain Name.
     */
    @JvmName("wsmekbvtqncvulux")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Domain name.
     */
    @JvmName("tmqnplevcskahipx")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("nlsmvjbwbefthmlv")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the domain name. The value of this parameter is used as a condition to filter domain names.
     */
    @JvmName("bsredblwpbtadmmi")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     * * `Key`: It can be up to 64 characters in length. It cannot be a null string.
     * * `Value`: It can be up to 128 characters in length. It can be a null string.
     */
    @JvmName("njtjynjcgoapnhfs")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     * * `Key`: It can be up to 64 characters in length. It cannot be a null string.
     * * `Value`: It can be up to 128 characters in length. It can be a null string.
     */
    @JvmName("fuqjuilhcfomlpuc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetDomainsPlainArgs = GetDomainsPlainArgs(
        domainSearchType = domainSearchType,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
        tags = tags,
    )
}
