@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vod.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property sourceContent The address of the origin server. You can specify an IP address or a domain name.
 * @property sourcePort The port number. You can specify port 443 or 80. **Default value: 80**. If you specify port 443, Alibaba Cloud CDN communicates with the origin server over HTTPS. You can also customize a port.
 * @property sourcePriority The priority of the origin server if multiple origin servers are specified. Valid values: `20` and `30`. **Default value: 20**. A value of 20 indicates that the origin server is the primary origin server. A value of 30 indicates that the origin server is a secondary origin server.
 * @property sourceType The type of the origin server. Valid values:
 */
public data class DomainSource(
    public val sourceContent: String,
    public val sourcePort: String,
    public val sourcePriority: String? = null,
    public val sourceType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vod.outputs.DomainSource): DomainSource =
            DomainSource(
                sourceContent = javaType.sourceContent(),
                sourcePort = javaType.sourcePort(),
                sourcePriority = javaType.sourcePriority().map({ args0 -> args0 }).orElse(null),
                sourceType = javaType.sourceType(),
            )
    }
}
