@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vod.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property cname The CNAME that is assigned to the domain name for CDN. You must add a CNAME record in the system of your Domain Name System (DNS) service provider to map the domain name for CDN to the CNAME.
 * @property description The description of the domain name for CDN.
 * @property domainName The domain name for CDN.
 * @property gmtCreated The time when the domain name for CDN was added. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
 * @property gmtModified The last time when the domain name for CDN was modified. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
 * @property id The ID of the Domain. Its value is same as Queue Name.
 * @property sandBox Indicates whether the domain name for CDN is in a sandbox environment.
 * @property sources The information about the address of the origin server. For more information about the Sources parameter, See the following `Block sources`.
 * @property sslProtocol Indicates whether the Secure Sockets Layer (SSL) certificate is enabled. Valid values: `on`,`off`.
 * @property status The status of the resource.
 */
public data class GetDomainsDomain(
    public val cname: String,
    public val description: String,
    public val domainName: String,
    public val gmtCreated: String,
    public val gmtModified: String,
    public val id: String,
    public val sandBox: String,
    public val sources: List<GetDomainsDomainSource>,
    public val sslProtocol: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vod.outputs.GetDomainsDomain): GetDomainsDomain = GetDomainsDomain(
            cname = javaType.cname(),
            description = javaType.description(),
            domainName = javaType.domainName(),
            gmtCreated = javaType.gmtCreated(),
            gmtModified = javaType.gmtModified(),
            id = javaType.id(),
            sandBox = javaType.sandBox(),
            sources = javaType.sources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vod.kotlin.outputs.GetDomainsDomainSource.Companion.toKotlin(args0)
                })
            }),
            sslProtocol = javaType.sslProtocol(),
            status = javaType.status(),
        )
    }
}
