@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vod.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getDomains.
 * @property domainSearchType
 * @property domains
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property status
 * @property tags
 */
public data class GetDomainsResult(
    public val domainSearchType: String? = null,
    public val domains: List<GetDomainsDomain>,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vod.outputs.GetDomainsResult): GetDomainsResult = GetDomainsResult(
            domainSearchType = javaType.domainSearchType().map({ args0 -> args0 }).orElse(null),
            domains = javaType.domains().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vod.kotlin.outputs.GetDomainsDomain.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
