@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.alicloud.vpc.BgpGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a VPC Bgp Group resource.
 * For information about VPC Bgp Group and how to use it, see [What is Bgp Group](https://www.alibabacloud.com/help/en/doc-detail/91267.html).
 * > **NOTE:** Available since v1.152.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const example = alicloud.expressconnect.getPhysicalConnections({
 *     nameRegex: "^preserved-NODELETING",
 * });
 * const vlanId = new random.index.Integer("vlan_id", {
 *     max: 2999,
 *     min: 1,
 * });
 * const exampleVirtualBorderRouter = new alicloud.expressconnect.VirtualBorderRouter("example", {
 *     localGatewayIp: "10.0.0.1",
 *     peerGatewayIp: "10.0.0.2",
 *     peeringSubnetMask: "255.255.255.252",
 *     physicalConnectionId: example.then(example => example.connections?.[0]?.id),
 *     virtualBorderRouterName: name,
 *     vlanId: vlanId.id,
 *     minRxInterval: 1000,
 *     minTxInterval: 1000,
 *     detectMultiplier: 10,
 * });
 * const exampleBgpGroup = new alicloud.vpc.BgpGroup("example", {
 *     authKey: "YourPassword+12345678",
 *     bgpGroupName: name,
 *     description: name,
 *     peerAsn: 1111,
 *     routerId: exampleVirtualBorderRouter.id,
 *     isFakeAsn: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * example = alicloud.expressconnect.get_physical_connections(name_regex="^preserved-NODELETING")
 * vlan_id = random.index.Integer("vlan_id",
 *     max=2999,
 *     min=1)
 * example_virtual_border_router = alicloud.expressconnect.VirtualBorderRouter("example",
 *     local_gateway_ip="10.0.0.1",
 *     peer_gateway_ip="10.0.0.2",
 *     peering_subnet_mask="255.255.255.252",
 *     physical_connection_id=example.connections[0].id,
 *     virtual_border_router_name=name,
 *     vlan_id=vlan_id["id"],
 *     min_rx_interval=1000,
 *     min_tx_interval=1000,
 *     detect_multiplier=10)
 * example_bgp_group = alicloud.vpc.BgpGroup("example",
 *     auth_key="YourPassword+12345678",
 *     bgp_group_name=name,
 *     description=name,
 *     peer_asn=1111,
 *     router_id=example_virtual_border_router.id,
 *     is_fake_asn=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var example = AliCloud.ExpressConnect.GetPhysicalConnections.Invoke(new()
 *     {
 *         NameRegex = "^preserved-NODELETING",
 *     });
 *     var vlanId = new Random.Index.Integer("vlan_id", new()
 *     {
 *         Max = 2999,
 *         Min = 1,
 *     });
 *     var exampleVirtualBorderRouter = new AliCloud.ExpressConnect.VirtualBorderRouter("example", new()
 *     {
 *         LocalGatewayIp = "10.0.0.1",
 *         PeerGatewayIp = "10.0.0.2",
 *         PeeringSubnetMask = "255.255.255.252",
 *         PhysicalConnectionId = example.Apply(getPhysicalConnectionsResult => getPhysicalConnectionsResult.Connections[0]?.Id),
 *         VirtualBorderRouterName = name,
 *         VlanId = vlanId.Id,
 *         MinRxInterval = 1000,
 *         MinTxInterval = 1000,
 *         DetectMultiplier = 10,
 *     });
 *     var exampleBgpGroup = new AliCloud.Vpc.BgpGroup("example", new()
 *     {
 *         AuthKey = "YourPassword+12345678",
 *         BgpGroupName = name,
 *         Description = name,
 *         PeerAsn = 1111,
 *         RouterId = exampleVirtualBorderRouter.Id,
 *         IsFakeAsn = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/expressconnect"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		example, err := expressconnect.GetPhysicalConnections(ctx, &expressconnect.GetPhysicalConnectionsArgs{
 * 			NameRegex: pulumi.StringRef("^preserved-NODELETING"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		vlanId, err := random.NewInteger(ctx, "vlan_id", &random.IntegerArgs{
 * 			Max: 2999,
 * 			Min: 1,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleVirtualBorderRouter, err := expressconnect.NewVirtualBorderRouter(ctx, "example", &expressconnect.VirtualBorderRouterArgs{
 * 			LocalGatewayIp:          pulumi.String("10.0.0.1"),
 * 			PeerGatewayIp:           pulumi.String("10.0.0.2"),
 * 			PeeringSubnetMask:       pulumi.String("255.255.255.252"),
 * 			PhysicalConnectionId:    pulumi.String(example.Connections[0].Id),
 * 			VirtualBorderRouterName: pulumi.String(name),
 * 			VlanId:                  vlanId.Id,
 * 			MinRxInterval:           pulumi.Int(1000),
 * 			MinTxInterval:           pulumi.Int(1000),
 * 			DetectMultiplier:        pulumi.Int(10),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewBgpGroup(ctx, "example", &vpc.BgpGroupArgs{
 * 			AuthKey:      pulumi.String("YourPassword+12345678"),
 * 			BgpGroupName: pulumi.String(name),
 * 			Description:  pulumi.String(name),
 * 			PeerAsn:      pulumi.Int(1111),
 * 			RouterId:     exampleVirtualBorderRouter.ID(),
 * 			IsFakeAsn:    pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.expressconnect.ExpressconnectFunctions;
 * import com.pulumi.alicloud.expressconnect.inputs.GetPhysicalConnectionsArgs;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.expressconnect.VirtualBorderRouter;
 * import com.pulumi.alicloud.expressconnect.VirtualBorderRouterArgs;
 * import com.pulumi.alicloud.vpc.BgpGroup;
 * import com.pulumi.alicloud.vpc.BgpGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var example = ExpressconnectFunctions.getPhysicalConnections(GetPhysicalConnectionsArgs.builder()
 *             .nameRegex("^preserved-NODELETING")
 *             .build());
 *         var vlanId = new Integer("vlanId", IntegerArgs.builder()
 *             .max(2999)
 *             .min(1)
 *             .build());
 *         var exampleVirtualBorderRouter = new VirtualBorderRouter("exampleVirtualBorderRouter", VirtualBorderRouterArgs.builder()
 *             .localGatewayIp("10.0.0.1")
 *             .peerGatewayIp("10.0.0.2")
 *             .peeringSubnetMask("255.255.255.252")
 *             .physicalConnectionId(example.applyValue(getPhysicalConnectionsResult -> getPhysicalConnectionsResult.connections()[0].id()))
 *             .virtualBorderRouterName(name)
 *             .vlanId(vlanId.id())
 *             .minRxInterval(1000)
 *             .minTxInterval(1000)
 *             .detectMultiplier(10)
 *             .build());
 *         var exampleBgpGroup = new BgpGroup("exampleBgpGroup", BgpGroupArgs.builder()
 *             .authKey("YourPassword+12345678")
 *             .bgpGroupName(name)
 *             .description(name)
 *             .peerAsn(1111)
 *             .routerId(exampleVirtualBorderRouter.id())
 *             .isFakeAsn(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   vlanId:
 *     type: random:integer
 *     name: vlan_id
 *     properties:
 *       max: 2999
 *       min: 1
 *   exampleVirtualBorderRouter:
 *     type: alicloud:expressconnect:VirtualBorderRouter
 *     name: example
 *     properties:
 *       localGatewayIp: 10.0.0.1
 *       peerGatewayIp: 10.0.0.2
 *       peeringSubnetMask: 255.255.255.252
 *       physicalConnectionId: ${example.connections[0].id}
 *       virtualBorderRouterName: ${name}
 *       vlanId: ${vlanId.id}
 *       minRxInterval: 1000
 *       minTxInterval: 1000
 *       detectMultiplier: 10
 *   exampleBgpGroup:
 *     type: alicloud:vpc:BgpGroup
 *     name: example
 *     properties:
 *       authKey: YourPassword+12345678
 *       bgpGroupName: ${name}
 *       description: ${name}
 *       peerAsn: 1111
 *       routerId: ${exampleVirtualBorderRouter.id}
 *       isFakeAsn: true
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: alicloud:expressconnect:getPhysicalConnections
 *       Arguments:
 *         nameRegex: ^preserved-NODELETING
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * VPC Bgp Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/bgpGroup:BgpGroup example <id>
 * ```
 * @property authKey The authentication key of the BGP group.
 * @property bgpGroupName The name of the BGP group. The name must be `2` to `128` characters in length and can contain digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter but cannot start with `http://` or `https://`.
 * @property description The description of the BGP group. The description must be `2` to `256` characters in length. It must start with a letter but cannot start with `http://` or `https://`.
 * @property isFakeAsn The is fake asn. A router that runs BGP typically belongs to only one AS. In some cases, for example, the AS needs to be migrated or is merged with another AS, a new AS number replaces the original one.
 * @property localAsn The AS number on the Alibaba Cloud side.
 * @property peerAsn The AS number of the BGP peer.
 * @property routerId The ID of the VBR.
 */
public data class BgpGroupArgs(
    public val authKey: Output<String>? = null,
    public val bgpGroupName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val isFakeAsn: Output<Boolean>? = null,
    public val localAsn: Output<Int>? = null,
    public val peerAsn: Output<Int>? = null,
    public val routerId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.BgpGroupArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.BgpGroupArgs =
        com.pulumi.alicloud.vpc.BgpGroupArgs.builder()
            .authKey(authKey?.applyValue({ args0 -> args0 }))
            .bgpGroupName(bgpGroupName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .isFakeAsn(isFakeAsn?.applyValue({ args0 -> args0 }))
            .localAsn(localAsn?.applyValue({ args0 -> args0 }))
            .peerAsn(peerAsn?.applyValue({ args0 -> args0 }))
            .routerId(routerId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BgpGroupArgs].
 */
@PulumiTagMarker
public class BgpGroupArgsBuilder internal constructor() {
    private var authKey: Output<String>? = null

    private var bgpGroupName: Output<String>? = null

    private var description: Output<String>? = null

    private var isFakeAsn: Output<Boolean>? = null

    private var localAsn: Output<Int>? = null

    private var peerAsn: Output<Int>? = null

    private var routerId: Output<String>? = null

    /**
     * @param value The authentication key of the BGP group.
     */
    @JvmName("ejenmcplvatmjrux")
    public suspend fun authKey(`value`: Output<String>) {
        this.authKey = value
    }

    /**
     * @param value The name of the BGP group. The name must be `2` to `128` characters in length and can contain digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter but cannot start with `http://` or `https://`.
     */
    @JvmName("ayjplkplxhaxdyjg")
    public suspend fun bgpGroupName(`value`: Output<String>) {
        this.bgpGroupName = value
    }

    /**
     * @param value The description of the BGP group. The description must be `2` to `256` characters in length. It must start with a letter but cannot start with `http://` or `https://`.
     */
    @JvmName("vrxpjpiqbrikhqlq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The is fake asn. A router that runs BGP typically belongs to only one AS. In some cases, for example, the AS needs to be migrated or is merged with another AS, a new AS number replaces the original one.
     */
    @JvmName("ocaswwdbamkcleoc")
    public suspend fun isFakeAsn(`value`: Output<Boolean>) {
        this.isFakeAsn = value
    }

    /**
     * @param value The AS number on the Alibaba Cloud side.
     */
    @JvmName("mgrvxebrqxxqpkux")
    public suspend fun localAsn(`value`: Output<Int>) {
        this.localAsn = value
    }

    /**
     * @param value The AS number of the BGP peer.
     */
    @JvmName("uigwikxditfoaexi")
    public suspend fun peerAsn(`value`: Output<Int>) {
        this.peerAsn = value
    }

    /**
     * @param value The ID of the VBR.
     */
    @JvmName("vadfgjtgmkxiboag")
    public suspend fun routerId(`value`: Output<String>) {
        this.routerId = value
    }

    /**
     * @param value The authentication key of the BGP group.
     */
    @JvmName("dspnyysirtmntsqi")
    public suspend fun authKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authKey = mapped
    }

    /**
     * @param value The name of the BGP group. The name must be `2` to `128` characters in length and can contain digits, periods (.), underscores (_), and hyphens (-). The name must start with a letter but cannot start with `http://` or `https://`.
     */
    @JvmName("bfajejsieowrgrxb")
    public suspend fun bgpGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bgpGroupName = mapped
    }

    /**
     * @param value The description of the BGP group. The description must be `2` to `256` characters in length. It must start with a letter but cannot start with `http://` or `https://`.
     */
    @JvmName("ujbimfmislxiyrek")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The is fake asn. A router that runs BGP typically belongs to only one AS. In some cases, for example, the AS needs to be migrated or is merged with another AS, a new AS number replaces the original one.
     */
    @JvmName("ycshpvrmvyexfbpx")
    public suspend fun isFakeAsn(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isFakeAsn = mapped
    }

    /**
     * @param value The AS number on the Alibaba Cloud side.
     */
    @JvmName("vkvolsmnebtfchim")
    public suspend fun localAsn(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localAsn = mapped
    }

    /**
     * @param value The AS number of the BGP peer.
     */
    @JvmName("eslqnuetfwrfpkvw")
    public suspend fun peerAsn(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerAsn = mapped
    }

    /**
     * @param value The ID of the VBR.
     */
    @JvmName("ylcwkatqwvnhwmqx")
    public suspend fun routerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routerId = mapped
    }

    internal fun build(): BgpGroupArgs = BgpGroupArgs(
        authKey = authKey,
        bgpGroupName = bgpGroupName,
        description = description,
        isFakeAsn = isFakeAsn,
        localAsn = localAsn,
        peerAsn = peerAsn,
        routerId = routerId,
    )
}
