@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [CommonBandwithPackage].
 */
@PulumiTagMarker
public class CommonBandwithPackageResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CommonBandwithPackageArgs = CommonBandwithPackageArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CommonBandwithPackageArgsBuilder.() -> Unit) {
        val builder = CommonBandwithPackageArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CommonBandwithPackage {
        val builtJavaResource = com.pulumi.alicloud.vpc.CommonBandwithPackage(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return CommonBandwithPackage(builtJavaResource)
    }
}

/**
 *
 * ## Import
 * CBWP Common Bandwidth Package can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/commonBandwithPackage:CommonBandwithPackage example <id>
 * ```
 */
public class CommonBandwithPackage internal constructor(
    override val javaResource: com.pulumi.alicloud.vpc.CommonBandwithPackage,
) : KotlinCustomResource(javaResource, CommonBandwithPackageMapper) {
    /**
     * The maximum bandwidth of the Internet Shared Bandwidth instance. Unit: Mbit/s. Valid values: `1` to `1000`. Default value: `1`.
     */
    public val bandwidth: Output<String>
        get() = javaResource.bandwidth().applyValue({ args0 -> args0 })

    /**
     * The name of the Internet Shared Bandwidth instance. The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (\_), and hyphens (-). The name must start with a letter.
     */
    public val bandwidthPackageName: Output<String>
        get() = javaResource.bandwidthPackageName().applyValue({ args0 -> args0 })

    /**
     * The creation time.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to enable deletion protection. Valid values:
     */
    public val deletionProtection: Output<Boolean>?
        get() = javaResource.deletionProtection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The description of the Internet Shared Bandwidth instance. The description must be 2 to 256 characters in length and start with a letter. The description cannot start with `http://` or `https://`.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether to forcefully delete the Internet Shared Bandwidth instance. Valid values:
     */
    public val force: Output<String>?
        get() = javaResource.force().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The billing method of the Internet Shared Bandwidth instance. Set the value to `PayByTraffic`, which specifies the pay-by-data-transfer billing method.
     */
    public val internetChargeType: Output<String>?
        get() = javaResource.internetChargeType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The line type. Valid values:
     * - `BGP` All regions support BGP (Multi-ISP).
     * - `BGP_PRO` BGP (Multi-ISP) Pro lines are available in the China (Hong Kong), Singapore, Japan (Tokyo), Philippines (Manila), Malaysia (Kuala Lumpur), Indonesia (Jakarta), and Thailand (Bangkok) regions.
     * If you are allowed to use single-ISP bandwidth, you can also use one of the following values:
     * - `ChinaTelecom`
     * - `ChinaUnicom`
     * - `ChinaMobile`
     * - `ChinaTelecom_L2`
     * - `ChinaUnicom_L2`
     * - `ChinaMobile_L2`
     * If your services are deployed in China East 1 Finance, this parameter is required and you must set the value to `BGP_FinanceCloud`.
     */
    public val isp: Output<String>
        get() = javaResource.isp().applyValue({ args0 -> args0 })

    /**
     * . Field 'name' has been deprecated from provider version 1.120.0. New field 'bandwidth_package_name' instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.120.0. New field
      'bandwidth_package_name' instead.
  """,
    )
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The billing type of the Internet Shared Bandwidth instance. Valid values: `PayAsYouGo`, `Subscription`.
     */
    public val paymentType: Output<String>
        get() = javaResource.paymentType().applyValue({ args0 -> args0 })

    /**
     * The percentage of the minimum bandwidth commitment. Set the parameter to `20`.
     * > **NOTE:**  This parameter is available only on the Alibaba Cloud China site.
     */
    public val ratio: Output<Int>
        get() = javaResource.ratio().applyValue({ args0 -> args0 })

    /**
     * The ID of the resource group to which you want to move the resource.
     * > **NOTE:**   You can use resource groups to facilitate resource grouping and permission management for an Alibaba Cloud. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The edition of Anti-DDoS. If you do not set this parameter, Anti-DDoS Origin Basic is used. If you set the value to AntiDDoS_Enhanced, Anti-DDoS Pro(Premium) is used. It is valid when `internet_charge_type` is `PayBy95`.
     */
    public val securityProtectionTypes: Output<List<String>>?
        get() = javaResource.securityProtectionTypes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The status of the Internet Shared Bandwidth instance. Default value: `Available`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The tag of the resource
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The zone of the Internet Shared Bandwidth instance. This parameter is required if you create an Internet Shared Bandwidth instance for a cloud box.
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    public val zone: Output<String>?
        get() = javaResource.zone().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object CommonBandwithPackageMapper : ResourceMapper<CommonBandwithPackage> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.vpc.CommonBandwithPackage::class == javaResource::class

    override fun map(javaResource: Resource): CommonBandwithPackage =
        CommonBandwithPackage(javaResource as com.pulumi.alicloud.vpc.CommonBandwithPackage)
}

/**
 * @see [CommonBandwithPackage].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CommonBandwithPackage].
 */
public suspend fun commonBandwithPackage(
    name: String,
    block: suspend CommonBandwithPackageResourceBuilder.() -> Unit,
): CommonBandwithPackage {
    val builder = CommonBandwithPackageResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CommonBandwithPackage].
 * @param name The _unique_ name of the resulting resource.
 */
public fun commonBandwithPackage(name: String): CommonBandwithPackage {
    val builder = CommonBandwithPackageResourceBuilder()
    builder.name(name)
    return builder.build()
}
