@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.alicloud.vpc.CommonBandwithPackageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * CBWP Common Bandwidth Package can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/commonBandwithPackage:CommonBandwithPackage example <id>
 * ```
 * @property bandwidth The maximum bandwidth of the Internet Shared Bandwidth instance. Unit: Mbit/s. Valid values: `1` to `1000`. Default value: `1`.
 * @property bandwidthPackageName The name of the Internet Shared Bandwidth instance. The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (\_), and hyphens (-). The name must start with a letter.
 * @property deletionProtection Specifies whether to enable deletion protection. Valid values:
 * @property description The description of the Internet Shared Bandwidth instance. The description must be 2 to 256 characters in length and start with a letter. The description cannot start with `http://` or `https://`.
 * @property force Specifies whether to forcefully delete the Internet Shared Bandwidth instance. Valid values:
 * @property internetChargeType The billing method of the Internet Shared Bandwidth instance. Set the value to `PayByTraffic`, which specifies the pay-by-data-transfer billing method.
 * @property isp The line type. Valid values:
 * - `BGP` All regions support BGP (Multi-ISP).
 * - `BGP_PRO` BGP (Multi-ISP) Pro lines are available in the China (Hong Kong), Singapore, Japan (Tokyo), Philippines (Manila), Malaysia (Kuala Lumpur), Indonesia (Jakarta), and Thailand (Bangkok) regions.
 * If you are allowed to use single-ISP bandwidth, you can also use one of the following values:
 * - `ChinaTelecom`
 * - `ChinaUnicom`
 * - `ChinaMobile`
 * - `ChinaTelecom_L2`
 * - `ChinaUnicom_L2`
 * - `ChinaMobile_L2`
 * If your services are deployed in China East 1 Finance, this parameter is required and you must set the value to `BGP_FinanceCloud`.
 * @property name . Field 'name' has been deprecated from provider version 1.120.0. New field 'bandwidth_package_name' instead.
 * @property ratio The percentage of the minimum bandwidth commitment. Set the parameter to `20`.
 * > **NOTE:**  This parameter is available only on the Alibaba Cloud China site.
 * @property resourceGroupId The ID of the resource group to which you want to move the resource.
 * > **NOTE:**   You can use resource groups to facilitate resource grouping and permission management for an Alibaba Cloud. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
 * @property securityProtectionTypes The edition of Anti-DDoS. If you do not set this parameter, Anti-DDoS Origin Basic is used. If you set the value to AntiDDoS_Enhanced, Anti-DDoS Pro(Premium) is used. It is valid when `internet_charge_type` is `PayBy95`.
 * @property tags The tag of the resource
 * @property zone The zone of the Internet Shared Bandwidth instance. This parameter is required if you create an Internet Shared Bandwidth instance for a cloud box.
 * The following arguments will be discarded. Please use new fields as soon as possible:
 */
public data class CommonBandwithPackageArgs(
    public val bandwidth: Output<String>? = null,
    public val bandwidthPackageName: Output<String>? = null,
    public val deletionProtection: Output<Boolean>? = null,
    public val description: Output<String>? = null,
    public val force: Output<String>? = null,
    public val internetChargeType: Output<String>? = null,
    public val isp: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.120.0. New field
      'bandwidth_package_name' instead.
  """,
    )
    public val name: Output<String>? = null,
    public val ratio: Output<Int>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val securityProtectionTypes: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val zone: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.CommonBandwithPackageArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.CommonBandwithPackageArgs =
        com.pulumi.alicloud.vpc.CommonBandwithPackageArgs.builder()
            .bandwidth(bandwidth?.applyValue({ args0 -> args0 }))
            .bandwidthPackageName(bandwidthPackageName?.applyValue({ args0 -> args0 }))
            .deletionProtection(deletionProtection?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .force(force?.applyValue({ args0 -> args0 }))
            .internetChargeType(internetChargeType?.applyValue({ args0 -> args0 }))
            .isp(isp?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .ratio(ratio?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .securityProtectionTypes(
                securityProtectionTypes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .zone(zone?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CommonBandwithPackageArgs].
 */
@PulumiTagMarker
public class CommonBandwithPackageArgsBuilder internal constructor() {
    private var bandwidth: Output<String>? = null

    private var bandwidthPackageName: Output<String>? = null

    private var deletionProtection: Output<Boolean>? = null

    private var description: Output<String>? = null

    private var force: Output<String>? = null

    private var internetChargeType: Output<String>? = null

    private var isp: Output<String>? = null

    private var name: Output<String>? = null

    private var ratio: Output<Int>? = null

    private var resourceGroupId: Output<String>? = null

    private var securityProtectionTypes: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var zone: Output<String>? = null

    /**
     * @param value The maximum bandwidth of the Internet Shared Bandwidth instance. Unit: Mbit/s. Valid values: `1` to `1000`. Default value: `1`.
     */
    @JvmName("atitqslcstwehtsr")
    public suspend fun bandwidth(`value`: Output<String>) {
        this.bandwidth = value
    }

    /**
     * @param value The name of the Internet Shared Bandwidth instance. The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (\_), and hyphens (-). The name must start with a letter.
     */
    @JvmName("kohudwyaeqfdvwqv")
    public suspend fun bandwidthPackageName(`value`: Output<String>) {
        this.bandwidthPackageName = value
    }

    /**
     * @param value Specifies whether to enable deletion protection. Valid values:
     */
    @JvmName("wircmiiwokxtawcv")
    public suspend fun deletionProtection(`value`: Output<Boolean>) {
        this.deletionProtection = value
    }

    /**
     * @param value The description of the Internet Shared Bandwidth instance. The description must be 2 to 256 characters in length and start with a letter. The description cannot start with `http://` or `https://`.
     */
    @JvmName("cxwkdtwxibqxnfpa")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specifies whether to forcefully delete the Internet Shared Bandwidth instance. Valid values:
     */
    @JvmName("wpcdiegvipbaaxcd")
    public suspend fun force(`value`: Output<String>) {
        this.force = value
    }

    /**
     * @param value The billing method of the Internet Shared Bandwidth instance. Set the value to `PayByTraffic`, which specifies the pay-by-data-transfer billing method.
     */
    @JvmName("hxtrwyqneovbmkqx")
    public suspend fun internetChargeType(`value`: Output<String>) {
        this.internetChargeType = value
    }

    /**
     * @param value The line type. Valid values:
     * - `BGP` All regions support BGP (Multi-ISP).
     * - `BGP_PRO` BGP (Multi-ISP) Pro lines are available in the China (Hong Kong), Singapore, Japan (Tokyo), Philippines (Manila), Malaysia (Kuala Lumpur), Indonesia (Jakarta), and Thailand (Bangkok) regions.
     * If you are allowed to use single-ISP bandwidth, you can also use one of the following values:
     * - `ChinaTelecom`
     * - `ChinaUnicom`
     * - `ChinaMobile`
     * - `ChinaTelecom_L2`
     * - `ChinaUnicom_L2`
     * - `ChinaMobile_L2`
     * If your services are deployed in China East 1 Finance, this parameter is required and you must set the value to `BGP_FinanceCloud`.
     */
    @JvmName("nkksbgljyyqdsfpf")
    public suspend fun isp(`value`: Output<String>) {
        this.isp = value
    }

    /**
     * @param value . Field 'name' has been deprecated from provider version 1.120.0. New field 'bandwidth_package_name' instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.120.0. New field
      'bandwidth_package_name' instead.
  """,
    )
    @JvmName("ipytuvqslpaupqba")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The percentage of the minimum bandwidth commitment. Set the parameter to `20`.
     * > **NOTE:**  This parameter is available only on the Alibaba Cloud China site.
     */
    @JvmName("ovqfvbpyotdynhiq")
    public suspend fun ratio(`value`: Output<Int>) {
        this.ratio = value
    }

    /**
     * @param value The ID of the resource group to which you want to move the resource.
     * > **NOTE:**   You can use resource groups to facilitate resource grouping and permission management for an Alibaba Cloud. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
     */
    @JvmName("vfvvjncakjdujcua")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The edition of Anti-DDoS. If you do not set this parameter, Anti-DDoS Origin Basic is used. If you set the value to AntiDDoS_Enhanced, Anti-DDoS Pro(Premium) is used. It is valid when `internet_charge_type` is `PayBy95`.
     */
    @JvmName("ufuolxvisuihkpnn")
    public suspend fun securityProtectionTypes(`value`: Output<List<String>>) {
        this.securityProtectionTypes = value
    }

    @JvmName("afqvhtfagehbpost")
    public suspend fun securityProtectionTypes(vararg values: Output<String>) {
        this.securityProtectionTypes = Output.all(values.asList())
    }

    /**
     * @param values The edition of Anti-DDoS. If you do not set this parameter, Anti-DDoS Origin Basic is used. If you set the value to AntiDDoS_Enhanced, Anti-DDoS Pro(Premium) is used. It is valid when `internet_charge_type` is `PayBy95`.
     */
    @JvmName("pnjxigyycoeehyaq")
    public suspend fun securityProtectionTypes(values: List<Output<String>>) {
        this.securityProtectionTypes = Output.all(values)
    }

    /**
     * @param value The tag of the resource
     */
    @JvmName("bamfpdiiokaakggg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The zone of the Internet Shared Bandwidth instance. This parameter is required if you create an Internet Shared Bandwidth instance for a cloud box.
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    @JvmName("xgcdwxgnawprwrsu")
    public suspend fun zone(`value`: Output<String>) {
        this.zone = value
    }

    /**
     * @param value The maximum bandwidth of the Internet Shared Bandwidth instance. Unit: Mbit/s. Valid values: `1` to `1000`. Default value: `1`.
     */
    @JvmName("pvtvbxuwqkimrxok")
    public suspend fun bandwidth(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidth = mapped
    }

    /**
     * @param value The name of the Internet Shared Bandwidth instance. The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (\_), and hyphens (-). The name must start with a letter.
     */
    @JvmName("melrxgwbupiuxbow")
    public suspend fun bandwidthPackageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidthPackageName = mapped
    }

    /**
     * @param value Specifies whether to enable deletion protection. Valid values:
     */
    @JvmName("sjrignerslsghwib")
    public suspend fun deletionProtection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deletionProtection = mapped
    }

    /**
     * @param value The description of the Internet Shared Bandwidth instance. The description must be 2 to 256 characters in length and start with a letter. The description cannot start with `http://` or `https://`.
     */
    @JvmName("noyoooeulrjqjxlw")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specifies whether to forcefully delete the Internet Shared Bandwidth instance. Valid values:
     */
    @JvmName("lpffcvucqxoiqlxd")
    public suspend fun force(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.force = mapped
    }

    /**
     * @param value The billing method of the Internet Shared Bandwidth instance. Set the value to `PayByTraffic`, which specifies the pay-by-data-transfer billing method.
     */
    @JvmName("pnuqcatnyofaxkua")
    public suspend fun internetChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internetChargeType = mapped
    }

    /**
     * @param value The line type. Valid values:
     * - `BGP` All regions support BGP (Multi-ISP).
     * - `BGP_PRO` BGP (Multi-ISP) Pro lines are available in the China (Hong Kong), Singapore, Japan (Tokyo), Philippines (Manila), Malaysia (Kuala Lumpur), Indonesia (Jakarta), and Thailand (Bangkok) regions.
     * If you are allowed to use single-ISP bandwidth, you can also use one of the following values:
     * - `ChinaTelecom`
     * - `ChinaUnicom`
     * - `ChinaMobile`
     * - `ChinaTelecom_L2`
     * - `ChinaUnicom_L2`
     * - `ChinaMobile_L2`
     * If your services are deployed in China East 1 Finance, this parameter is required and you must set the value to `BGP_FinanceCloud`.
     */
    @JvmName("gofmgpjybhrsnkay")
    public suspend fun isp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isp = mapped
    }

    /**
     * @param value . Field 'name' has been deprecated from provider version 1.120.0. New field 'bandwidth_package_name' instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated since provider version 1.120.0. New field
      'bandwidth_package_name' instead.
  """,
    )
    @JvmName("aoqdvrmuboxdpoqp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The percentage of the minimum bandwidth commitment. Set the parameter to `20`.
     * > **NOTE:**  This parameter is available only on the Alibaba Cloud China site.
     */
    @JvmName("kknwoxthxwsqvrio")
    public suspend fun ratio(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ratio = mapped
    }

    /**
     * @param value The ID of the resource group to which you want to move the resource.
     * > **NOTE:**   You can use resource groups to facilitate resource grouping and permission management for an Alibaba Cloud. For more information, see [What is resource management?](https://www.alibabacloud.com/help/en/doc-detail/94475.html)
     */
    @JvmName("rcclukspqnmtxlvn")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The edition of Anti-DDoS. If you do not set this parameter, Anti-DDoS Origin Basic is used. If you set the value to AntiDDoS_Enhanced, Anti-DDoS Pro(Premium) is used. It is valid when `internet_charge_type` is `PayBy95`.
     */
    @JvmName("rnfqogqeqfyyaihc")
    public suspend fun securityProtectionTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityProtectionTypes = mapped
    }

    /**
     * @param values The edition of Anti-DDoS. If you do not set this parameter, Anti-DDoS Origin Basic is used. If you set the value to AntiDDoS_Enhanced, Anti-DDoS Pro(Premium) is used. It is valid when `internet_charge_type` is `PayBy95`.
     */
    @JvmName("tbluhtrdykptoerk")
    public suspend fun securityProtectionTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityProtectionTypes = mapped
    }

    /**
     * @param value The tag of the resource
     */
    @JvmName("iinybppdhrjaljfo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tag of the resource
     */
    @JvmName("tjkihbjxafpqginx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The zone of the Internet Shared Bandwidth instance. This parameter is required if you create an Internet Shared Bandwidth instance for a cloud box.
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    @JvmName("tmvkfkxfosrfgueg")
    public suspend fun zone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zone = mapped
    }

    internal fun build(): CommonBandwithPackageArgs = CommonBandwithPackageArgs(
        bandwidth = bandwidth,
        bandwidthPackageName = bandwidthPackageName,
        deletionProtection = deletionProtection,
        description = description,
        force = force,
        internetChargeType = internetChargeType,
        isp = isp,
        name = name,
        ratio = ratio,
        resourceGroupId = resourceGroupId,
        securityProtectionTypes = securityProtectionTypes,
        tags = tags,
        zone = zone,
    )
}
