@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [CommonBandwithPackageAttachment].
 */
@PulumiTagMarker
public class CommonBandwithPackageAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CommonBandwithPackageAttachmentArgs = CommonBandwithPackageAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CommonBandwithPackageAttachmentArgsBuilder.() -> Unit) {
        val builder = CommonBandwithPackageAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CommonBandwithPackageAttachment {
        val builtJavaResource =
            com.pulumi.alicloud.vpc.CommonBandwithPackageAttachment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CommonBandwithPackageAttachment(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.vpc.CommonBandwithPackage("default", {
 *     bandwidth: "3",
 *     internetChargeType: "PayByBandwidth",
 * });
 * const defaultEipAddress = new alicloud.ecs.EipAddress("default", {
 *     bandwidth: "3",
 *     internetChargeType: "PayByTraffic",
 * });
 * const defaultCommonBandwithPackageAttachment = new alicloud.vpc.CommonBandwithPackageAttachment("default", {
 *     bandwidthPackageId: _default.id,
 *     instanceId: defaultEipAddress.id,
 *     bandwidthPackageBandwidth: "2",
 *     ipType: "EIP",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.vpc.CommonBandwithPackage("default",
 *     bandwidth="3",
 *     internet_charge_type="PayByBandwidth")
 * default_eip_address = alicloud.ecs.EipAddress("default",
 *     bandwidth="3",
 *     internet_charge_type="PayByTraffic")
 * default_common_bandwith_package_attachment = alicloud.vpc.CommonBandwithPackageAttachment("default",
 *     bandwidth_package_id=default.id,
 *     instance_id=default_eip_address.id,
 *     bandwidth_package_bandwidth="2",
 *     ip_type="EIP")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Vpc.CommonBandwithPackage("default", new()
 *     {
 *         Bandwidth = "3",
 *         InternetChargeType = "PayByBandwidth",
 *     });
 *     var defaultEipAddress = new AliCloud.Ecs.EipAddress("default", new()
 *     {
 *         Bandwidth = "3",
 *         InternetChargeType = "PayByTraffic",
 *     });
 *     var defaultCommonBandwithPackageAttachment = new AliCloud.Vpc.CommonBandwithPackageAttachment("default", new()
 *     {
 *         BandwidthPackageId = @default.Id,
 *         InstanceId = defaultEipAddress.Id,
 *         BandwidthPackageBandwidth = "2",
 *         IpType = "EIP",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := vpc.NewCommonBandwithPackage(ctx, "default", &vpc.CommonBandwithPackageArgs{
 * 			Bandwidth:          pulumi.String("3"),
 * 			InternetChargeType: pulumi.String("PayByBandwidth"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultEipAddress, err := ecs.NewEipAddress(ctx, "default", &ecs.EipAddressArgs{
 * 			Bandwidth:          pulumi.String("3"),
 * 			InternetChargeType: pulumi.String("PayByTraffic"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewCommonBandwithPackageAttachment(ctx, "default", &vpc.CommonBandwithPackageAttachmentArgs{
 * 			BandwidthPackageId:        _default.ID(),
 * 			InstanceId:                defaultEipAddress.ID(),
 * 			BandwidthPackageBandwidth: pulumi.String("2"),
 * 			IpType:                    pulumi.String("EIP"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.vpc.CommonBandwithPackage;
 * import com.pulumi.alicloud.vpc.CommonBandwithPackageArgs;
 * import com.pulumi.alicloud.ecs.EipAddress;
 * import com.pulumi.alicloud.ecs.EipAddressArgs;
 * import com.pulumi.alicloud.vpc.CommonBandwithPackageAttachment;
 * import com.pulumi.alicloud.vpc.CommonBandwithPackageAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new CommonBandwithPackage("default", CommonBandwithPackageArgs.builder()
 *             .bandwidth(3)
 *             .internetChargeType("PayByBandwidth")
 *             .build());
 *         var defaultEipAddress = new EipAddress("defaultEipAddress", EipAddressArgs.builder()
 *             .bandwidth("3")
 *             .internetChargeType("PayByTraffic")
 *             .build());
 *         var defaultCommonBandwithPackageAttachment = new CommonBandwithPackageAttachment("defaultCommonBandwithPackageAttachment", CommonBandwithPackageAttachmentArgs.builder()
 *             .bandwidthPackageId(default_.id())
 *             .instanceId(defaultEipAddress.id())
 *             .bandwidthPackageBandwidth("2")
 *             .ipType("EIP")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:vpc:CommonBandwithPackage
 *     properties:
 *       bandwidth: 3
 *       internetChargeType: PayByBandwidth
 *   defaultEipAddress:
 *     type: alicloud:ecs:EipAddress
 *     name: default
 *     properties:
 *       bandwidth: '3'
 *       internetChargeType: PayByTraffic
 *   defaultCommonBandwithPackageAttachment:
 *     type: alicloud:vpc:CommonBandwithPackageAttachment
 *     name: default
 *     properties:
 *       bandwidthPackageId: ${default.id}
 *       instanceId: ${defaultEipAddress.id}
 *       bandwidthPackageBandwidth: '2'
 *       ipType: EIP
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * CBWP Common Bandwidth Package Attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/commonBandwithPackageAttachment:CommonBandwithPackageAttachment example <bandwidth_package_id>:<instance_id>
 * ```
 */
public class CommonBandwithPackageAttachment internal constructor(
    override val javaResource: com.pulumi.alicloud.vpc.CommonBandwithPackageAttachment,
) : KotlinCustomResource(javaResource, CommonBandwithPackageAttachmentMapper) {
    /**
     * The maximum bandwidth for the EIP. This value cannot be larger than the maximum bandwidth of the Internet Shared Bandwidth instance. Unit: Mbit/s.
     */
    public val bandwidthPackageBandwidth: Output<String>
        get() = javaResource.bandwidthPackageBandwidth().applyValue({ args0 -> args0 })

    /**
     * The ID of the Internet Shared Bandwidth instance.
     */
    public val bandwidthPackageId: Output<String>
        get() = javaResource.bandwidthPackageId().applyValue({ args0 -> args0 })

    /**
     * Whether to cancel the maximum bandwidth configuration for the EIP. Default: false.
     */
    public val cancelCommonBandwidthPackageIpBandwidth: Output<Boolean>?
        get() = javaResource.cancelCommonBandwidthPackageIpBandwidth().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * The ID of the EIP that you want to query.
     * You can specify up to 50 EIP IDs. Separate multiple IDs with commas (,).
     * > **NOTE:**   If both `EipAddress` and `AllocationId` are specified, you can specify up to 50 EIP IDs for `AllocationId`, and specify up to 50 EIPs for `EipAddress`.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * The type of IP address. Set the value to `EIP` to associate EIPs with the Internet Shared Bandwidth instance.
     */
    public val ipType: Output<String>?
        get() = javaResource.ipType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The status of the Internet Shared Bandwidth instance.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object CommonBandwithPackageAttachmentMapper :
    ResourceMapper<CommonBandwithPackageAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.vpc.CommonBandwithPackageAttachment::class == javaResource::class

    override fun map(javaResource: Resource): CommonBandwithPackageAttachment =
        CommonBandwithPackageAttachment(
            javaResource as
                com.pulumi.alicloud.vpc.CommonBandwithPackageAttachment,
        )
}

/**
 * @see [CommonBandwithPackageAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CommonBandwithPackageAttachment].
 */
public suspend fun commonBandwithPackageAttachment(
    name: String,
    block: suspend CommonBandwithPackageAttachmentResourceBuilder.() -> Unit,
): CommonBandwithPackageAttachment {
    val builder = CommonBandwithPackageAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CommonBandwithPackageAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun commonBandwithPackageAttachment(name: String): CommonBandwithPackageAttachment {
    val builder = CommonBandwithPackageAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
