@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.alicloud.vpc.kotlin.outputs.DhcpOptionsSetAssociateVpc
import com.pulumi.alicloud.vpc.kotlin.outputs.DhcpOptionsSetAssociateVpc.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [DhcpOptionsSet].
 */
@PulumiTagMarker
public class DhcpOptionsSetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DhcpOptionsSetArgs = DhcpOptionsSetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DhcpOptionsSetArgsBuilder.() -> Unit) {
        val builder = DhcpOptionsSetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DhcpOptionsSet {
        val builtJavaResource = com.pulumi.alicloud.vpc.DhcpOptionsSet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DhcpOptionsSet(builtJavaResource)
    }
}

/**
 * Provides a VPC Dhcp Options Set resource. DHCP option set.
 * For information about VPC Dhcp Options Set and how to use it, see [What is Dhcp Options Set](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/dhcp-options-sets-overview).
 * > **NOTE:** Available since v1.134.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const domain = config.get("domain") || "terraform-example.com";
 * const example = new alicloud.vpc.DhcpOptionsSet("example", {
 *     dhcpOptionsSetName: name,
 *     dhcpOptionsSetDescription: name,
 *     domainName: domain,
 *     domainNameServers: "100.100.2.136",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * domain = config.get("domain")
 * if domain is None:
 *     domain = "terraform-example.com"
 * example = alicloud.vpc.DhcpOptionsSet("example",
 *     dhcp_options_set_name=name,
 *     dhcp_options_set_description=name,
 *     domain_name=domain,
 *     domain_name_servers="100.100.2.136")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var domain = config.Get("domain") ?? "terraform-example.com";
 *     var example = new AliCloud.Vpc.DhcpOptionsSet("example", new()
 *     {
 *         DhcpOptionsSetName = name,
 *         DhcpOptionsSetDescription = name,
 *         DomainName = domain,
 *         DomainNameServers = "100.100.2.136",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		domain := "terraform-example.com"
 * 		if param := cfg.Get("domain"); param != "" {
 * 			domain = param
 * 		}
 * 		_, err := vpc.NewDhcpOptionsSet(ctx, "example", &vpc.DhcpOptionsSetArgs{
 * 			DhcpOptionsSetName:        pulumi.String(name),
 * 			DhcpOptionsSetDescription: pulumi.String(name),
 * 			DomainName:                pulumi.String(domain),
 * 			DomainNameServers:         pulumi.String("100.100.2.136"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.vpc.DhcpOptionsSet;
 * import com.pulumi.alicloud.vpc.DhcpOptionsSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var domain = config.get("domain").orElse("terraform-example.com");
 *         var example = new DhcpOptionsSet("example", DhcpOptionsSetArgs.builder()
 *             .dhcpOptionsSetName(name)
 *             .dhcpOptionsSetDescription(name)
 *             .domainName(domain)
 *             .domainNameServers("100.100.2.136")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 *   domain:
 *     type: string
 *     default: terraform-example.com
 * resources:
 *   example:
 *     type: alicloud:vpc:DhcpOptionsSet
 *     properties:
 *       dhcpOptionsSetName: ${name}
 *       dhcpOptionsSetDescription: ${name}
 *       domainName: ${domain}
 *       domainNameServers: 100.100.2.136
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * VPC Dhcp Options Set can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/dhcpOptionsSet:DhcpOptionsSet example <id>
 * ```
 */
public class DhcpOptionsSet internal constructor(
    override val javaResource: com.pulumi.alicloud.vpc.DhcpOptionsSet,
) : KotlinCustomResource(javaResource, DhcpOptionsSetMapper) {
    /**
     * Field 'associate_vpcs' has been deprecated from provider version 1.153.0 and it will be removed in the future version. Please use the new resource 'alicloud_vpc_dhcp_options_set_attachment' to attach DhcpOptionsSet and Vpc. See `associate_vpcs` below.
     */
    @Deprecated(
        message = """
  Field 'associate_vpcs' has been deprecated from provider version 1.153.0. Field 'associate_vpcs'
      has been deprecated from provider version 1.153.0 and it will be removed in the future
      version. Please use the new resource 'alicloud_vpc_dhcp_options_set_attachment' to attach
      DhcpOptionsSet and Vpc.
  """,
    )
    public val associateVpcs: Output<List<DhcpOptionsSetAssociateVpc>>
        get() = javaResource.associateVpcs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })

    /**
     * The description can be blank or contain 1 to 256 characters. It must start with a letter or Chinese character but cannot start with http:// or https://.
     */
    public val dhcpOptionsSetDescription: Output<String>?
        get() = javaResource.dhcpOptionsSetDescription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name must be 2 to 128 characters in length and can contain letters, Chinese characters, digits, underscores (_), and hyphens (-). It must start with a letter or a Chinese character.
     */
    public val dhcpOptionsSetName: Output<String>?
        get() = javaResource.dhcpOptionsSetName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The root domain, for example, example.com. After a DHCP options set is associated with a Virtual Private Cloud (VPC) network, the root domain in the DHCP options set is automatically synchronized to the ECS instances in the VPC network.
     */
    public val domainName: Output<String>?
        get() = javaResource.domainName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The DNS server IP addresses. Up to four DNS server IP addresses can be specified. IP addresses must be separated with commas (,).Before you specify any DNS server IP address, all ECS instances in the associated VPC network use the IP addresses of the Alibaba Cloud DNS servers, which are 100.100.2.136 and 100.100.2.138.
     */
    public val domainNameServers: Output<String>?
        get() = javaResource.domainNameServers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to PreCheck only this request, value:
     * - **true**: sends a check request and does not delete the DHCP option set. Check items include whether required parameters are filled in, request format, and restrictions. If the check fails, the corresponding error is returned. If the check passes, the error code 'DryRunOperation' is returned '.
     * - **false** (default): Sends a normal request and directly deletes the DHCP option set after checking.
     */
    public val dryRun: Output<Boolean>?
        get() = javaResource.dryRun().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The lease time of the IPv6 DHCP option set.When the lease time is set to hours: Unit: h. Value range: 24h ~ 1176h,87600h ~ 175200h. Default value: 87600h.When the lease time is set to day: Unit: d. Value range: 1d ~ 49d,3650d ~ 7300d. Default value: 3650d.
     */
    public val ipv6LeaseTime: Output<String>
        get() = javaResource.ipv6LeaseTime().applyValue({ args0 -> args0 })

    /**
     * The lease time of the IPv4 DHCP option set.When the lease time is set to hours: Unit: h. Value range: 24h ~ 1176h,87600h ~ 175200h. Default value: 87600h.When the lease time is set to day: Unit: d. Value range: 1d ~ 49d,3650d ~ 7300d. Default value: 3650d.
     */
    public val leaseTime: Output<String>
        get() = javaResource.leaseTime().applyValue({ args0 -> args0 })

    /**
     * The ID of the account to which the DHCP options set belongs.
     */
    public val ownerId: Output<Int>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    /**
     * The ID of the resource group.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Tags of the current resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })
}

public object DhcpOptionsSetMapper : ResourceMapper<DhcpOptionsSet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.vpc.DhcpOptionsSet::class == javaResource::class

    override fun map(javaResource: Resource): DhcpOptionsSet = DhcpOptionsSet(
        javaResource as
            com.pulumi.alicloud.vpc.DhcpOptionsSet,
    )
}

/**
 * @see [DhcpOptionsSet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DhcpOptionsSet].
 */
public suspend fun dhcpOptionsSet(
    name: String,
    block: suspend DhcpOptionsSetResourceBuilder.() -> Unit,
): DhcpOptionsSet {
    val builder = DhcpOptionsSetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DhcpOptionsSet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dhcpOptionsSet(name: String): DhcpOptionsSet {
    val builder = DhcpOptionsSetResourceBuilder()
    builder.name(name)
    return builder.build()
}
