@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.alicloud.vpc.DhcpOptionsSetArgs.builder
import com.pulumi.alicloud.vpc.kotlin.inputs.DhcpOptionsSetAssociateVpcArgs
import com.pulumi.alicloud.vpc.kotlin.inputs.DhcpOptionsSetAssociateVpcArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a VPC Dhcp Options Set resource. DHCP option set.
 * For information about VPC Dhcp Options Set and how to use it, see [What is Dhcp Options Set](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/dhcp-options-sets-overview).
 * > **NOTE:** Available since v1.134.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const domain = config.get("domain") || "terraform-example.com";
 * const example = new alicloud.vpc.DhcpOptionsSet("example", {
 *     dhcpOptionsSetName: name,
 *     dhcpOptionsSetDescription: name,
 *     domainName: domain,
 *     domainNameServers: "100.100.2.136",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * domain = config.get("domain")
 * if domain is None:
 *     domain = "terraform-example.com"
 * example = alicloud.vpc.DhcpOptionsSet("example",
 *     dhcp_options_set_name=name,
 *     dhcp_options_set_description=name,
 *     domain_name=domain,
 *     domain_name_servers="100.100.2.136")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var domain = config.Get("domain") ?? "terraform-example.com";
 *     var example = new AliCloud.Vpc.DhcpOptionsSet("example", new()
 *     {
 *         DhcpOptionsSetName = name,
 *         DhcpOptionsSetDescription = name,
 *         DomainName = domain,
 *         DomainNameServers = "100.100.2.136",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		domain := "terraform-example.com"
 * 		if param := cfg.Get("domain"); param != "" {
 * 			domain = param
 * 		}
 * 		_, err := vpc.NewDhcpOptionsSet(ctx, "example", &vpc.DhcpOptionsSetArgs{
 * 			DhcpOptionsSetName:        pulumi.String(name),
 * 			DhcpOptionsSetDescription: pulumi.String(name),
 * 			DomainName:                pulumi.String(domain),
 * 			DomainNameServers:         pulumi.String("100.100.2.136"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.vpc.DhcpOptionsSet;
 * import com.pulumi.alicloud.vpc.DhcpOptionsSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var domain = config.get("domain").orElse("terraform-example.com");
 *         var example = new DhcpOptionsSet("example", DhcpOptionsSetArgs.builder()
 *             .dhcpOptionsSetName(name)
 *             .dhcpOptionsSetDescription(name)
 *             .domainName(domain)
 *             .domainNameServers("100.100.2.136")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 *   domain:
 *     type: string
 *     default: terraform-example.com
 * resources:
 *   example:
 *     type: alicloud:vpc:DhcpOptionsSet
 *     properties:
 *       dhcpOptionsSetName: ${name}
 *       dhcpOptionsSetDescription: ${name}
 *       domainName: ${domain}
 *       domainNameServers: 100.100.2.136
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * VPC Dhcp Options Set can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/dhcpOptionsSet:DhcpOptionsSet example <id>
 * ```
 * @property associateVpcs Field 'associate_vpcs' has been deprecated from provider version 1.153.0 and it will be removed in the future version. Please use the new resource 'alicloud_vpc_dhcp_options_set_attachment' to attach DhcpOptionsSet and Vpc. See `associate_vpcs` below.
 * @property dhcpOptionsSetDescription The description can be blank or contain 1 to 256 characters. It must start with a letter or Chinese character but cannot start with http:// or https://.
 * @property dhcpOptionsSetName The name must be 2 to 128 characters in length and can contain letters, Chinese characters, digits, underscores (_), and hyphens (-). It must start with a letter or a Chinese character.
 * @property domainName The root domain, for example, example.com. After a DHCP options set is associated with a Virtual Private Cloud (VPC) network, the root domain in the DHCP options set is automatically synchronized to the ECS instances in the VPC network.
 * @property domainNameServers The DNS server IP addresses. Up to four DNS server IP addresses can be specified. IP addresses must be separated with commas (,).Before you specify any DNS server IP address, all ECS instances in the associated VPC network use the IP addresses of the Alibaba Cloud DNS servers, which are 100.100.2.136 and 100.100.2.138.
 * @property dryRun Whether to PreCheck only this request, value:
 * - **true**: sends a check request and does not delete the DHCP option set. Check items include whether required parameters are filled in, request format, and restrictions. If the check fails, the corresponding error is returned. If the check passes, the error code 'DryRunOperation' is returned '.
 * - **false** (default): Sends a normal request and directly deletes the DHCP option set after checking.
 * @property ipv6LeaseTime The lease time of the IPv6 DHCP option set.When the lease time is set to hours: Unit: h. Value range: 24h ~ 1176h,87600h ~ 175200h. Default value: 87600h.When the lease time is set to day: Unit: d. Value range: 1d ~ 49d,3650d ~ 7300d. Default value: 3650d.
 * @property leaseTime The lease time of the IPv4 DHCP option set.When the lease time is set to hours: Unit: h. Value range: 24h ~ 1176h,87600h ~ 175200h. Default value: 87600h.When the lease time is set to day: Unit: d. Value range: 1d ~ 49d,3650d ~ 7300d. Default value: 3650d.
 * @property resourceGroupId The ID of the resource group.
 * @property tags Tags of the current resource.
 */
public data class DhcpOptionsSetArgs(
    @Deprecated(
        message = """
  Field 'associate_vpcs' has been deprecated from provider version 1.153.0. Field 'associate_vpcs'
      has been deprecated from provider version 1.153.0 and it will be removed in the future
      version. Please use the new resource 'alicloud_vpc_dhcp_options_set_attachment' to attach
      DhcpOptionsSet and Vpc.
  """,
    )
    public val associateVpcs: Output<List<DhcpOptionsSetAssociateVpcArgs>>? = null,
    public val dhcpOptionsSetDescription: Output<String>? = null,
    public val dhcpOptionsSetName: Output<String>? = null,
    public val domainName: Output<String>? = null,
    public val domainNameServers: Output<String>? = null,
    public val dryRun: Output<Boolean>? = null,
    public val ipv6LeaseTime: Output<String>? = null,
    public val leaseTime: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.DhcpOptionsSetArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.DhcpOptionsSetArgs =
        com.pulumi.alicloud.vpc.DhcpOptionsSetArgs.builder()
            .associateVpcs(
                associateVpcs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .dhcpOptionsSetDescription(dhcpOptionsSetDescription?.applyValue({ args0 -> args0 }))
            .dhcpOptionsSetName(dhcpOptionsSetName?.applyValue({ args0 -> args0 }))
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .domainNameServers(domainNameServers?.applyValue({ args0 -> args0 }))
            .dryRun(dryRun?.applyValue({ args0 -> args0 }))
            .ipv6LeaseTime(ipv6LeaseTime?.applyValue({ args0 -> args0 }))
            .leaseTime(leaseTime?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DhcpOptionsSetArgs].
 */
@PulumiTagMarker
public class DhcpOptionsSetArgsBuilder internal constructor() {
    private var associateVpcs: Output<List<DhcpOptionsSetAssociateVpcArgs>>? = null

    private var dhcpOptionsSetDescription: Output<String>? = null

    private var dhcpOptionsSetName: Output<String>? = null

    private var domainName: Output<String>? = null

    private var domainNameServers: Output<String>? = null

    private var dryRun: Output<Boolean>? = null

    private var ipv6LeaseTime: Output<String>? = null

    private var leaseTime: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Field 'associate_vpcs' has been deprecated from provider version 1.153.0 and it will be removed in the future version. Please use the new resource 'alicloud_vpc_dhcp_options_set_attachment' to attach DhcpOptionsSet and Vpc. See `associate_vpcs` below.
     */
    @Deprecated(
        message = """
  Field 'associate_vpcs' has been deprecated from provider version 1.153.0. Field 'associate_vpcs'
      has been deprecated from provider version 1.153.0 and it will be removed in the future
      version. Please use the new resource 'alicloud_vpc_dhcp_options_set_attachment' to attach
      DhcpOptionsSet and Vpc.
  """,
    )
    @JvmName("okilmbdaxlcercgf")
    public suspend fun associateVpcs(`value`: Output<List<DhcpOptionsSetAssociateVpcArgs>>) {
        this.associateVpcs = value
    }

    @JvmName("pqquvskcklmokmmk")
    public suspend fun associateVpcs(vararg values: Output<DhcpOptionsSetAssociateVpcArgs>) {
        this.associateVpcs = Output.all(values.asList())
    }

    /**
     * @param values Field 'associate_vpcs' has been deprecated from provider version 1.153.0 and it will be removed in the future version. Please use the new resource 'alicloud_vpc_dhcp_options_set_attachment' to attach DhcpOptionsSet and Vpc. See `associate_vpcs` below.
     */
    @Deprecated(
        message = """
  Field 'associate_vpcs' has been deprecated from provider version 1.153.0. Field 'associate_vpcs'
      has been deprecated from provider version 1.153.0 and it will be removed in the future
      version. Please use the new resource 'alicloud_vpc_dhcp_options_set_attachment' to attach
      DhcpOptionsSet and Vpc.
  """,
    )
    @JvmName("vuacnpcnhgqqcgat")
    public suspend fun associateVpcs(values: List<Output<DhcpOptionsSetAssociateVpcArgs>>) {
        this.associateVpcs = Output.all(values)
    }

    /**
     * @param value The description can be blank or contain 1 to 256 characters. It must start with a letter or Chinese character but cannot start with http:// or https://.
     */
    @JvmName("lhxfjautsyvfofiq")
    public suspend fun dhcpOptionsSetDescription(`value`: Output<String>) {
        this.dhcpOptionsSetDescription = value
    }

    /**
     * @param value The name must be 2 to 128 characters in length and can contain letters, Chinese characters, digits, underscores (_), and hyphens (-). It must start with a letter or a Chinese character.
     */
    @JvmName("gqfcxpvgvesxobch")
    public suspend fun dhcpOptionsSetName(`value`: Output<String>) {
        this.dhcpOptionsSetName = value
    }

    /**
     * @param value The root domain, for example, example.com. After a DHCP options set is associated with a Virtual Private Cloud (VPC) network, the root domain in the DHCP options set is automatically synchronized to the ECS instances in the VPC network.
     */
    @JvmName("itlmnvklqsydccju")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value The DNS server IP addresses. Up to four DNS server IP addresses can be specified. IP addresses must be separated with commas (,).Before you specify any DNS server IP address, all ECS instances in the associated VPC network use the IP addresses of the Alibaba Cloud DNS servers, which are 100.100.2.136 and 100.100.2.138.
     */
    @JvmName("odyhgbygamibfkbj")
    public suspend fun domainNameServers(`value`: Output<String>) {
        this.domainNameServers = value
    }

    /**
     * @param value Whether to PreCheck only this request, value:
     * - **true**: sends a check request and does not delete the DHCP option set. Check items include whether required parameters are filled in, request format, and restrictions. If the check fails, the corresponding error is returned. If the check passes, the error code 'DryRunOperation' is returned '.
     * - **false** (default): Sends a normal request and directly deletes the DHCP option set after checking.
     */
    @JvmName("adtgxmfolkrtfvcs")
    public suspend fun dryRun(`value`: Output<Boolean>) {
        this.dryRun = value
    }

    /**
     * @param value The lease time of the IPv6 DHCP option set.When the lease time is set to hours: Unit: h. Value range: 24h ~ 1176h,87600h ~ 175200h. Default value: 87600h.When the lease time is set to day: Unit: d. Value range: 1d ~ 49d,3650d ~ 7300d. Default value: 3650d.
     */
    @JvmName("hteflbsxegviedre")
    public suspend fun ipv6LeaseTime(`value`: Output<String>) {
        this.ipv6LeaseTime = value
    }

    /**
     * @param value The lease time of the IPv4 DHCP option set.When the lease time is set to hours: Unit: h. Value range: 24h ~ 1176h,87600h ~ 175200h. Default value: 87600h.When the lease time is set to day: Unit: d. Value range: 1d ~ 49d,3650d ~ 7300d. Default value: 3650d.
     */
    @JvmName("onsckxypqflvjqfy")
    public suspend fun leaseTime(`value`: Output<String>) {
        this.leaseTime = value
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("nksgbtpruqhjindi")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value Tags of the current resource.
     */
    @JvmName("nqoeunwxnxwlbnfq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Field 'associate_vpcs' has been deprecated from provider version 1.153.0 and it will be removed in the future version. Please use the new resource 'alicloud_vpc_dhcp_options_set_attachment' to attach DhcpOptionsSet and Vpc. See `associate_vpcs` below.
     */
    @Deprecated(
        message = """
  Field 'associate_vpcs' has been deprecated from provider version 1.153.0. Field 'associate_vpcs'
      has been deprecated from provider version 1.153.0 and it will be removed in the future
      version. Please use the new resource 'alicloud_vpc_dhcp_options_set_attachment' to attach
      DhcpOptionsSet and Vpc.
  """,
    )
    @JvmName("cfrslgcurqakapqd")
    public suspend fun associateVpcs(`value`: List<DhcpOptionsSetAssociateVpcArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.associateVpcs = mapped
    }

    /**
     * @param argument Field 'associate_vpcs' has been deprecated from provider version 1.153.0 and it will be removed in the future version. Please use the new resource 'alicloud_vpc_dhcp_options_set_attachment' to attach DhcpOptionsSet and Vpc. See `associate_vpcs` below.
     */
    @Deprecated(
        message = """
  Field 'associate_vpcs' has been deprecated from provider version 1.153.0. Field 'associate_vpcs'
      has been deprecated from provider version 1.153.0 and it will be removed in the future
      version. Please use the new resource 'alicloud_vpc_dhcp_options_set_attachment' to attach
      DhcpOptionsSet and Vpc.
  """,
    )
    @JvmName("cpoqbbturvesrmet")
    public suspend fun associateVpcs(argument: List<suspend DhcpOptionsSetAssociateVpcArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DhcpOptionsSetAssociateVpcArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.associateVpcs = mapped
    }

    /**
     * @param argument Field 'associate_vpcs' has been deprecated from provider version 1.153.0 and it will be removed in the future version. Please use the new resource 'alicloud_vpc_dhcp_options_set_attachment' to attach DhcpOptionsSet and Vpc. See `associate_vpcs` below.
     */
    @Deprecated(
        message = """
  Field 'associate_vpcs' has been deprecated from provider version 1.153.0. Field 'associate_vpcs'
      has been deprecated from provider version 1.153.0 and it will be removed in the future
      version. Please use the new resource 'alicloud_vpc_dhcp_options_set_attachment' to attach
      DhcpOptionsSet and Vpc.
  """,
    )
    @JvmName("pjiyeydubpdeaocp")
    public suspend fun associateVpcs(vararg argument: suspend DhcpOptionsSetAssociateVpcArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DhcpOptionsSetAssociateVpcArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.associateVpcs = mapped
    }

    /**
     * @param argument Field 'associate_vpcs' has been deprecated from provider version 1.153.0 and it will be removed in the future version. Please use the new resource 'alicloud_vpc_dhcp_options_set_attachment' to attach DhcpOptionsSet and Vpc. See `associate_vpcs` below.
     */
    @Deprecated(
        message = """
  Field 'associate_vpcs' has been deprecated from provider version 1.153.0. Field 'associate_vpcs'
      has been deprecated from provider version 1.153.0 and it will be removed in the future
      version. Please use the new resource 'alicloud_vpc_dhcp_options_set_attachment' to attach
      DhcpOptionsSet and Vpc.
  """,
    )
    @JvmName("feyelfxnlibvodfs")
    public suspend fun associateVpcs(argument: suspend DhcpOptionsSetAssociateVpcArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DhcpOptionsSetAssociateVpcArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.associateVpcs = mapped
    }

    /**
     * @param values Field 'associate_vpcs' has been deprecated from provider version 1.153.0 and it will be removed in the future version. Please use the new resource 'alicloud_vpc_dhcp_options_set_attachment' to attach DhcpOptionsSet and Vpc. See `associate_vpcs` below.
     */
    @Deprecated(
        message = """
  Field 'associate_vpcs' has been deprecated from provider version 1.153.0. Field 'associate_vpcs'
      has been deprecated from provider version 1.153.0 and it will be removed in the future
      version. Please use the new resource 'alicloud_vpc_dhcp_options_set_attachment' to attach
      DhcpOptionsSet and Vpc.
  """,
    )
    @JvmName("iaxrksjvbfjwksgl")
    public suspend fun associateVpcs(vararg values: DhcpOptionsSetAssociateVpcArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.associateVpcs = mapped
    }

    /**
     * @param value The description can be blank or contain 1 to 256 characters. It must start with a letter or Chinese character but cannot start with http:// or https://.
     */
    @JvmName("beqamxsghcrrdbfp")
    public suspend fun dhcpOptionsSetDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dhcpOptionsSetDescription = mapped
    }

    /**
     * @param value The name must be 2 to 128 characters in length and can contain letters, Chinese characters, digits, underscores (_), and hyphens (-). It must start with a letter or a Chinese character.
     */
    @JvmName("xxfspvtvbgcqqqrj")
    public suspend fun dhcpOptionsSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dhcpOptionsSetName = mapped
    }

    /**
     * @param value The root domain, for example, example.com. After a DHCP options set is associated with a Virtual Private Cloud (VPC) network, the root domain in the DHCP options set is automatically synchronized to the ECS instances in the VPC network.
     */
    @JvmName("cinxpmxjrxuvieqb")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value The DNS server IP addresses. Up to four DNS server IP addresses can be specified. IP addresses must be separated with commas (,).Before you specify any DNS server IP address, all ECS instances in the associated VPC network use the IP addresses of the Alibaba Cloud DNS servers, which are 100.100.2.136 and 100.100.2.138.
     */
    @JvmName("qqdstaiyqchfcdcs")
    public suspend fun domainNameServers(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainNameServers = mapped
    }

    /**
     * @param value Whether to PreCheck only this request, value:
     * - **true**: sends a check request and does not delete the DHCP option set. Check items include whether required parameters are filled in, request format, and restrictions. If the check fails, the corresponding error is returned. If the check passes, the error code 'DryRunOperation' is returned '.
     * - **false** (default): Sends a normal request and directly deletes the DHCP option set after checking.
     */
    @JvmName("qovujlkahgleqstk")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dryRun = mapped
    }

    /**
     * @param value The lease time of the IPv6 DHCP option set.When the lease time is set to hours: Unit: h. Value range: 24h ~ 1176h,87600h ~ 175200h. Default value: 87600h.When the lease time is set to day: Unit: d. Value range: 1d ~ 49d,3650d ~ 7300d. Default value: 3650d.
     */
    @JvmName("fpjkraosaxuppivw")
    public suspend fun ipv6LeaseTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6LeaseTime = mapped
    }

    /**
     * @param value The lease time of the IPv4 DHCP option set.When the lease time is set to hours: Unit: h. Value range: 24h ~ 1176h,87600h ~ 175200h. Default value: 87600h.When the lease time is set to day: Unit: d. Value range: 1d ~ 49d,3650d ~ 7300d. Default value: 3650d.
     */
    @JvmName("sladthdpsjlxgikk")
    public suspend fun leaseTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.leaseTime = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("rxqpirgbjtmcaqkt")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value Tags of the current resource.
     */
    @JvmName("rhfblkmdpgmxpruf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags of the current resource.
     */
    @JvmName("alqjbgmledrakwvx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DhcpOptionsSetArgs = DhcpOptionsSetArgs(
        associateVpcs = associateVpcs,
        dhcpOptionsSetDescription = dhcpOptionsSetDescription,
        dhcpOptionsSetName = dhcpOptionsSetName,
        domainName = domainName,
        domainNameServers = domainNameServers,
        dryRun = dryRun,
        ipv6LeaseTime = ipv6LeaseTime,
        leaseTime = leaseTime,
        resourceGroupId = resourceGroupId,
        tags = tags,
    )
}
