@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [FlowLog].
 */
@PulumiTagMarker
public class FlowLogResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FlowLogArgs = FlowLogArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FlowLogArgsBuilder.() -> Unit) {
        val builder = FlowLogArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): FlowLog {
        val builtJavaResource = com.pulumi.alicloud.vpc.FlowLog(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return FlowLog(builtJavaResource)
    }
}

/**
 * Provides a Vpc Flow Log resource. While it uses alicloud.vpc.FlowLog to build a vpc flow log resource, it will be active by default.
 * For information about Vpc Flow Log and how to use it, see [What is Flow Log](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/flow-logs-overview).
 * > **NOTE:** Available since v1.117.0.
 * ## Import
 * Vpc Flow Log can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/flowLog:FlowLog example <id>
 * ```
 */
public class FlowLog internal constructor(
    override val javaResource: com.pulumi.alicloud.vpc.FlowLog,
) : KotlinCustomResource(javaResource, FlowLogMapper) {
    /**
     * Data aggregation interval.
     */
    public val aggregationInterval: Output<String>
        get() = javaResource.aggregationInterval().applyValue({ args0 -> args0 })

    /**
     * Business status.
     */
    public val businessStatus: Output<String>
        get() = javaResource.businessStatus().applyValue({ args0 -> args0 })

    /**
     * Creation time.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The Description of the VPC Flow Log.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The flow log ID.
     */
    public val flowLogId: Output<String>
        get() = javaResource.flowLogId().applyValue({ args0 -> args0 })

    /**
     * The Name of the VPC Flow Log.
     */
    public val flowLogName: Output<String>?
        get() = javaResource.flowLogName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the logstore.
     */
    public val logStoreName: Output<String>
        get() = javaResource.logStoreName().applyValue({ args0 -> args0 })

    /**
     * The name of the project.
     */
    public val projectName: Output<String>
        get() = javaResource.projectName().applyValue({ args0 -> args0 })

    /**
     * The ID of the resource group.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The ID of the resource.
     */
    public val resourceId: Output<String>
        get() = javaResource.resourceId().applyValue({ args0 -> args0 })

    /**
     * The resource type of the traffic captured by the flow log:-**NetworkInterface**: ENI.-**VSwitch**: All ENIs in the VSwitch.-**VPC**: All ENIs in the VPC.
     */
    public val resourceType: Output<String>
        get() = javaResource.resourceType().applyValue({ args0 -> args0 })

    /**
     * The status of the VPC Flow Log. Valid values: **Active** and **Inactive**.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The tag of the current instance resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The collected flow path. Value:**all**: indicates full acquisition.**internetGateway**: indicates public network traffic collection.
     */
    public val trafficPaths: Output<List<String>>
        get() = javaResource.trafficPaths().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The type of traffic collected. Valid values:**All**: All traffic.**Allow**: Access control allowedtraffic.**Drop**: Access control denied traffic.
     */
    public val trafficType: Output<String>
        get() = javaResource.trafficType().applyValue({ args0 -> args0 })
}

public object FlowLogMapper : ResourceMapper<FlowLog> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.vpc.FlowLog::class == javaResource::class

    override fun map(javaResource: Resource): FlowLog = FlowLog(
        javaResource as
            com.pulumi.alicloud.vpc.FlowLog,
    )
}

/**
 * @see [FlowLog].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FlowLog].
 */
public suspend fun flowLog(name: String, block: suspend FlowLogResourceBuilder.() -> Unit): FlowLog {
    val builder = FlowLogResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FlowLog].
 * @param name The _unique_ name of the resulting resource.
 */
public fun flowLog(name: String): FlowLog {
    val builder = FlowLogResourceBuilder()
    builder.name(name)
    return builder.build()
}
