@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.alicloud.vpc.FlowLogArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Vpc Flow Log resource. While it uses alicloud.vpc.FlowLog to build a vpc flow log resource, it will be active by default.
 * For information about Vpc Flow Log and how to use it, see [What is Flow Log](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/flow-logs-overview).
 * > **NOTE:** Available since v1.117.0.
 * ## Import
 * Vpc Flow Log can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/flowLog:FlowLog example <id>
 * ```
 * @property aggregationInterval Data aggregation interval.
 * @property description The Description of the VPC Flow Log.
 * @property flowLogName The Name of the VPC Flow Log.
 * @property logStoreName The name of the logstore.
 * @property projectName The name of the project.
 * @property resourceGroupId The ID of the resource group.
 * @property resourceId The ID of the resource.
 * @property resourceType The resource type of the traffic captured by the flow log:-**NetworkInterface**: ENI.-**VSwitch**: All ENIs in the VSwitch.-**VPC**: All ENIs in the VPC.
 * @property status The status of the VPC Flow Log. Valid values: **Active** and **Inactive**.
 * @property tags The tag of the current instance resource.
 * @property trafficPaths The collected flow path. Value:**all**: indicates full acquisition.**internetGateway**: indicates public network traffic collection.
 * @property trafficType The type of traffic collected. Valid values:**All**: All traffic.**Allow**: Access control allowedtraffic.**Drop**: Access control denied traffic.
 */
public data class FlowLogArgs(
    public val aggregationInterval: Output<String>? = null,
    public val description: Output<String>? = null,
    public val flowLogName: Output<String>? = null,
    public val logStoreName: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val resourceId: Output<String>? = null,
    public val resourceType: Output<String>? = null,
    public val status: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val trafficPaths: Output<List<String>>? = null,
    public val trafficType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.FlowLogArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.FlowLogArgs =
        com.pulumi.alicloud.vpc.FlowLogArgs.builder()
            .aggregationInterval(aggregationInterval?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .flowLogName(flowLogName?.applyValue({ args0 -> args0 }))
            .logStoreName(logStoreName?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 }))
            .resourceType(resourceType?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .trafficPaths(trafficPaths?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .trafficType(trafficType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FlowLogArgs].
 */
@PulumiTagMarker
public class FlowLogArgsBuilder internal constructor() {
    private var aggregationInterval: Output<String>? = null

    private var description: Output<String>? = null

    private var flowLogName: Output<String>? = null

    private var logStoreName: Output<String>? = null

    private var projectName: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var resourceId: Output<String>? = null

    private var resourceType: Output<String>? = null

    private var status: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var trafficPaths: Output<List<String>>? = null

    private var trafficType: Output<String>? = null

    /**
     * @param value Data aggregation interval.
     */
    @JvmName("qevseckaqwmucscw")
    public suspend fun aggregationInterval(`value`: Output<String>) {
        this.aggregationInterval = value
    }

    /**
     * @param value The Description of the VPC Flow Log.
     */
    @JvmName("hyblawjdbsvedeed")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The Name of the VPC Flow Log.
     */
    @JvmName("hitlklldqvueccbp")
    public suspend fun flowLogName(`value`: Output<String>) {
        this.flowLogName = value
    }

    /**
     * @param value The name of the logstore.
     */
    @JvmName("bpgwrxfkpxkdlefn")
    public suspend fun logStoreName(`value`: Output<String>) {
        this.logStoreName = value
    }

    /**
     * @param value The name of the project.
     */
    @JvmName("xbldiqrhbwnefavq")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("qglwutdjniciyutp")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The ID of the resource.
     */
    @JvmName("ghwcpohsktxyiaxa")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value The resource type of the traffic captured by the flow log:-**NetworkInterface**: ENI.-**VSwitch**: All ENIs in the VSwitch.-**VPC**: All ENIs in the VPC.
     */
    @JvmName("ctfvjvcqclbjgjug")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value The status of the VPC Flow Log. Valid values: **Active** and **Inactive**.
     */
    @JvmName("fhfamkicatnjmjmi")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The tag of the current instance resource.
     */
    @JvmName("mtuidkqinkhharjd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The collected flow path. Value:**all**: indicates full acquisition.**internetGateway**: indicates public network traffic collection.
     */
    @JvmName("essttwvjttsnwnlt")
    public suspend fun trafficPaths(`value`: Output<List<String>>) {
        this.trafficPaths = value
    }

    @JvmName("xvkahxyadmmndpjv")
    public suspend fun trafficPaths(vararg values: Output<String>) {
        this.trafficPaths = Output.all(values.asList())
    }

    /**
     * @param values The collected flow path. Value:**all**: indicates full acquisition.**internetGateway**: indicates public network traffic collection.
     */
    @JvmName("lwbuxcxhahshovib")
    public suspend fun trafficPaths(values: List<Output<String>>) {
        this.trafficPaths = Output.all(values)
    }

    /**
     * @param value The type of traffic collected. Valid values:**All**: All traffic.**Allow**: Access control allowedtraffic.**Drop**: Access control denied traffic.
     */
    @JvmName("kujnwlbvpludravs")
    public suspend fun trafficType(`value`: Output<String>) {
        this.trafficType = value
    }

    /**
     * @param value Data aggregation interval.
     */
    @JvmName("vqpfpnlgmjesrlvn")
    public suspend fun aggregationInterval(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aggregationInterval = mapped
    }

    /**
     * @param value The Description of the VPC Flow Log.
     */
    @JvmName("cfguvqnwcvvvsbsd")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The Name of the VPC Flow Log.
     */
    @JvmName("kmypgpoodttgxokh")
    public suspend fun flowLogName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.flowLogName = mapped
    }

    /**
     * @param value The name of the logstore.
     */
    @JvmName("qhhyhjwbygpqsdom")
    public suspend fun logStoreName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logStoreName = mapped
    }

    /**
     * @param value The name of the project.
     */
    @JvmName("oiiaiushwtuladeo")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("oemqaecregioewmh")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The ID of the resource.
     */
    @JvmName("wdrafrodirjgpbcy")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value The resource type of the traffic captured by the flow log:-**NetworkInterface**: ENI.-**VSwitch**: All ENIs in the VSwitch.-**VPC**: All ENIs in the VPC.
     */
    @JvmName("pdpjnslydchxnmhm")
    public suspend fun resourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    /**
     * @param value The status of the VPC Flow Log. Valid values: **Active** and **Inactive**.
     */
    @JvmName("anlxxfahcooejtab")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The tag of the current instance resource.
     */
    @JvmName("krkvjqnsolcmwqfg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tag of the current instance resource.
     */
    @JvmName("vcydwsjskwhebxxl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The collected flow path. Value:**all**: indicates full acquisition.**internetGateway**: indicates public network traffic collection.
     */
    @JvmName("hhdludtmffehegas")
    public suspend fun trafficPaths(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trafficPaths = mapped
    }

    /**
     * @param values The collected flow path. Value:**all**: indicates full acquisition.**internetGateway**: indicates public network traffic collection.
     */
    @JvmName("klqvuapesojkoktb")
    public suspend fun trafficPaths(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trafficPaths = mapped
    }

    /**
     * @param value The type of traffic collected. Valid values:**All**: All traffic.**Allow**: Access control allowedtraffic.**Drop**: Access control denied traffic.
     */
    @JvmName("ypevosrsdmofrass")
    public suspend fun trafficType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trafficType = mapped
    }

    internal fun build(): FlowLogArgs = FlowLogArgs(
        aggregationInterval = aggregationInterval,
        description = description,
        flowLogName = flowLogName,
        logStoreName = logStoreName,
        projectName = projectName,
        resourceGroupId = resourceGroupId,
        resourceId = resourceId,
        resourceType = resourceType,
        status = status,
        tags = tags,
        trafficPaths = trafficPaths,
        trafficType = trafficType,
    )
}
