@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ForwardEntry].
 */
@PulumiTagMarker
public class ForwardEntryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ForwardEntryArgs = ForwardEntryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ForwardEntryArgsBuilder.() -> Unit) {
        val builder = ForwardEntryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ForwardEntry {
        val builtJavaResource = com.pulumi.alicloud.vpc.ForwardEntry(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ForwardEntry(builtJavaResource)
    }
}

/**
 * Provides a forward resource.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "forward-entry-example-name";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "172.16.0.0/12",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "172.16.0.0/21",
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     vswitchName: name,
 * });
 * const defaultNatGateway = new alicloud.vpc.NatGateway("default", {
 *     vpcId: defaultNetwork.id,
 *     internetChargeType: "PayByLcu",
 *     natGatewayName: name,
 *     natType: "Enhanced",
 *     vswitchId: defaultSwitch.id,
 * });
 * const defaultEipAddress = new alicloud.ecs.EipAddress("default", {addressName: name});
 * const defaultEipAssociation = new alicloud.ecs.EipAssociation("default", {
 *     allocationId: defaultEipAddress.id,
 *     instanceId: defaultNatGateway.id,
 * });
 * const defaultForwardEntry = new alicloud.vpc.ForwardEntry("default", {
 *     forwardTableId: defaultNatGateway.forwardTableIds,
 *     externalIp: defaultEipAddress.ipAddress,
 *     externalPort: "80",
 *     ipProtocol: "tcp",
 *     internalIp: "172.16.0.3",
 *     internalPort: "8080",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "forward-entry-example-name"
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="172.16.0.0/12")
 * default_switch = alicloud.vpc.Switch("default",
 *     vpc_id=default_network.id,
 *     cidr_block="172.16.0.0/21",
 *     zone_id=default.zones[0].id,
 *     vswitch_name=name)
 * default_nat_gateway = alicloud.vpc.NatGateway("default",
 *     vpc_id=default_network.id,
 *     internet_charge_type="PayByLcu",
 *     nat_gateway_name=name,
 *     nat_type="Enhanced",
 *     vswitch_id=default_switch.id)
 * default_eip_address = alicloud.ecs.EipAddress("default", address_name=name)
 * default_eip_association = alicloud.ecs.EipAssociation("default",
 *     allocation_id=default_eip_address.id,
 *     instance_id=default_nat_gateway.id)
 * default_forward_entry = alicloud.vpc.ForwardEntry("default",
 *     forward_table_id=default_nat_gateway.forward_table_ids,
 *     external_ip=default_eip_address.ip_address,
 *     external_port="80",
 *     ip_protocol="tcp",
 *     internal_ip="172.16.0.3",
 *     internal_port="8080")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "forward-entry-example-name";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "172.16.0.0/12",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "172.16.0.0/21",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         VswitchName = name,
 *     });
 *     var defaultNatGateway = new AliCloud.Vpc.NatGateway("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         InternetChargeType = "PayByLcu",
 *         NatGatewayName = name,
 *         NatType = "Enhanced",
 *         VswitchId = defaultSwitch.Id,
 *     });
 *     var defaultEipAddress = new AliCloud.Ecs.EipAddress("default", new()
 *     {
 *         AddressName = name,
 *     });
 *     var defaultEipAssociation = new AliCloud.Ecs.EipAssociation("default", new()
 *     {
 *         AllocationId = defaultEipAddress.Id,
 *         InstanceId = defaultNatGateway.Id,
 *     });
 *     var defaultForwardEntry = new AliCloud.Vpc.ForwardEntry("default", new()
 *     {
 *         ForwardTableId = defaultNatGateway.ForwardTableIds,
 *         ExternalIp = defaultEipAddress.IpAddress,
 *         ExternalPort = "80",
 *         IpProtocol = "tcp",
 *         InternalIp = "172.16.0.3",
 *         InternalPort = "8080",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "forward-entry-example-name"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("172.16.0.0/12"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VpcId:       defaultNetwork.ID(),
 * 			CidrBlock:   pulumi.String("172.16.0.0/21"),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 			VswitchName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNatGateway, err := vpc.NewNatGateway(ctx, "default", &vpc.NatGatewayArgs{
 * 			VpcId:              defaultNetwork.ID(),
 * 			InternetChargeType: pulumi.String("PayByLcu"),
 * 			NatGatewayName:     pulumi.String(name),
 * 			NatType:            pulumi.String("Enhanced"),
 * 			VswitchId:          defaultSwitch.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultEipAddress, err := ecs.NewEipAddress(ctx, "default", &ecs.EipAddressArgs{
 * 			AddressName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewEipAssociation(ctx, "default", &ecs.EipAssociationArgs{
 * 			AllocationId: defaultEipAddress.ID(),
 * 			InstanceId:   defaultNatGateway.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewForwardEntry(ctx, "default", &vpc.ForwardEntryArgs{
 * 			ForwardTableId: defaultNatGateway.ForwardTableIds,
 * 			ExternalIp:     defaultEipAddress.IpAddress,
 * 			ExternalPort:   pulumi.String("80"),
 * 			IpProtocol:     pulumi.String("tcp"),
 * 			InternalIp:     pulumi.String("172.16.0.3"),
 * 			InternalPort:   pulumi.String("8080"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.vpc.NatGateway;
 * import com.pulumi.alicloud.vpc.NatGatewayArgs;
 * import com.pulumi.alicloud.ecs.EipAddress;
 * import com.pulumi.alicloud.ecs.EipAddressArgs;
 * import com.pulumi.alicloud.ecs.EipAssociation;
 * import com.pulumi.alicloud.ecs.EipAssociationArgs;
 * import com.pulumi.alicloud.vpc.ForwardEntry;
 * import com.pulumi.alicloud.vpc.ForwardEntryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("forward-entry-example-name");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("172.16.0.0/12")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("172.16.0.0/21")
 *             .zoneId(default_.zones()[0].id())
 *             .vswitchName(name)
 *             .build());
 *         var defaultNatGateway = new NatGateway("defaultNatGateway", NatGatewayArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .internetChargeType("PayByLcu")
 *             .natGatewayName(name)
 *             .natType("Enhanced")
 *             .vswitchId(defaultSwitch.id())
 *             .build());
 *         var defaultEipAddress = new EipAddress("defaultEipAddress", EipAddressArgs.builder()
 *             .addressName(name)
 *             .build());
 *         var defaultEipAssociation = new EipAssociation("defaultEipAssociation", EipAssociationArgs.builder()
 *             .allocationId(defaultEipAddress.id())
 *             .instanceId(defaultNatGateway.id())
 *             .build());
 *         var defaultForwardEntry = new ForwardEntry("defaultForwardEntry", ForwardEntryArgs.builder()
 *             .forwardTableId(defaultNatGateway.forwardTableIds())
 *             .externalIp(defaultEipAddress.ipAddress())
 *             .externalPort("80")
 *             .ipProtocol("tcp")
 *             .internalIp("172.16.0.3")
 *             .internalPort("8080")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: forward-entry-example-name
 * resources:
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 172.16.0.0/12
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 172.16.0.0/21
 *       zoneId: ${default.zones[0].id}
 *       vswitchName: ${name}
 *   defaultNatGateway:
 *     type: alicloud:vpc:NatGateway
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       internetChargeType: PayByLcu
 *       natGatewayName: ${name}
 *       natType: Enhanced
 *       vswitchId: ${defaultSwitch.id}
 *   defaultEipAddress:
 *     type: alicloud:ecs:EipAddress
 *     name: default
 *     properties:
 *       addressName: ${name}
 *   defaultEipAssociation:
 *     type: alicloud:ecs:EipAssociation
 *     name: default
 *     properties:
 *       allocationId: ${defaultEipAddress.id}
 *       instanceId: ${defaultNatGateway.id}
 *   defaultForwardEntry:
 *     type: alicloud:vpc:ForwardEntry
 *     name: default
 *     properties:
 *       forwardTableId: ${defaultNatGateway.forwardTableIds}
 *       externalIp: ${defaultEipAddress.ipAddress}
 *       externalPort: '80'
 *       ipProtocol: tcp
 *       internalIp: 172.16.0.3
 *       internalPort: '8080'
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Forward Entry can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/forwardEntry:ForwardEntry foo ftb-1aece3:fwd-232ce2
 * ```
 */
public class ForwardEntry internal constructor(
    override val javaResource: com.pulumi.alicloud.vpc.ForwardEntry,
) : KotlinCustomResource(javaResource, ForwardEntryMapper) {
    /**
     * The external ip address, the ip must along bandwidth package public ip which `alicloud.vpc.NatGateway` argument `bandwidth_packages`.
     */
    public val externalIp: Output<String>
        get() = javaResource.externalIp().applyValue({ args0 -> args0 })

    /**
     * The external port, valid value is 1~65535|any.
     */
    public val externalPort: Output<String>
        get() = javaResource.externalPort().applyValue({ args0 -> args0 })

    /**
     * The id of the forward entry on the server.
     */
    public val forwardEntryId: Output<String>
        get() = javaResource.forwardEntryId().applyValue({ args0 -> args0 })

    /**
     * The name of forward entry.
     */
    public val forwardEntryName: Output<String>
        get() = javaResource.forwardEntryName().applyValue({ args0 -> args0 })

    /**
     * The value can get from `alicloud.vpc.NatGateway` Attributes "forward_table_ids".
     */
    public val forwardTableId: Output<String>
        get() = javaResource.forwardTableId().applyValue({ args0 -> args0 })

    /**
     * The internal ip, must a private ip.
     */
    public val internalIp: Output<String>
        get() = javaResource.internalIp().applyValue({ args0 -> args0 })

    /**
     * The internal port, valid value is 1~65535|any.
     */
    public val internalPort: Output<String>
        get() = javaResource.internalPort().applyValue({ args0 -> args0 })

    /**
     * The ip protocol, valid value is tcp|udp|any.
     */
    public val ipProtocol: Output<String>
        get() = javaResource.ipProtocol().applyValue({ args0 -> args0 })

    /**
     * Field `name` has been deprecated from provider version 1.119.1. New field `forward_entry_name` instead.
     */
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.119.1. New field 'forward_entry_name'
      instead.
  """,
    )
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to remove limits on the port range. Default value is `false`.
     * > **NOTE:** A SNAT entry and a DNAT entry may use the same public IP address. If you want to specify a port number greater than 1024 in this case, set `port_break` to true.
     */
    public val portBreak: Output<Boolean>?
        get() = javaResource.portBreak().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * (Available in 1.119.1+) The status of forward entry.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object ForwardEntryMapper : ResourceMapper<ForwardEntry> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.vpc.ForwardEntry::class == javaResource::class

    override fun map(javaResource: Resource): ForwardEntry = ForwardEntry(
        javaResource as
            com.pulumi.alicloud.vpc.ForwardEntry,
    )
}

/**
 * @see [ForwardEntry].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ForwardEntry].
 */
public suspend fun forwardEntry(
    name: String,
    block: suspend ForwardEntryResourceBuilder.() -> Unit,
): ForwardEntry {
    val builder = ForwardEntryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ForwardEntry].
 * @param name The _unique_ name of the resulting resource.
 */
public fun forwardEntry(name: String): ForwardEntry {
    val builder = ForwardEntryResourceBuilder()
    builder.name(name)
    return builder.build()
}
