@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [GatewayEndpoint].
 */
@PulumiTagMarker
public class GatewayEndpointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GatewayEndpointArgs = GatewayEndpointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GatewayEndpointArgsBuilder.() -> Unit) {
        val builder = GatewayEndpointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GatewayEndpoint {
        val builtJavaResource = com.pulumi.alicloud.vpc.GatewayEndpoint(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GatewayEndpoint(builtJavaResource)
    }
}

/**
 * Provides a VPC Gateway Endpoint resource. VPC gateway endpoint.
 * For information about VPC Gateway Endpoint and how to use it, see [What is Gateway Endpoint](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/gateway-endpoint).
 * > **NOTE:** Available since v1.208.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const domain = config.get("domain") || "com.aliyun.cn-hangzhou.oss";
 * const defaultVpc = new alicloud.vpc.Network("defaultVpc", {description: "tf-example"});
 * const defaultRg = new alicloud.resourcemanager.ResourceGroup("defaultRg", {
 *     displayName: "tf-example-497",
 *     resourceGroupName: name,
 * });
 * const _default = new alicloud.vpc.GatewayEndpoint("default", {
 *     gatewayEndpointDescrption: "test-gateway-endpoint",
 *     gatewayEndpointName: name,
 *     vpcId: defaultVpc.id,
 *     resourceGroupId: defaultRg.id,
 *     serviceName: domain,
 *     policyDocument: `      {
 *         "Version": "1",
 *         "Statement": [{
 *           "Effect": "Allow",
 *           "Resource": ["*"],
 *           "Action": ["*"],
 *           "Principal": ["*"]
 *         }]
 *       }
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * domain = config.get("domain")
 * if domain is None:
 *     domain = "com.aliyun.cn-hangzhou.oss"
 * default_vpc = alicloud.vpc.Network("defaultVpc", description="tf-example")
 * default_rg = alicloud.resourcemanager.ResourceGroup("defaultRg",
 *     display_name="tf-example-497",
 *     resource_group_name=name)
 * default = alicloud.vpc.GatewayEndpoint("default",
 *     gateway_endpoint_descrption="test-gateway-endpoint",
 *     gateway_endpoint_name=name,
 *     vpc_id=default_vpc.id,
 *     resource_group_id=default_rg.id,
 *     service_name=domain,
 *     policy_document="""      {
 *         "Version": "1",
 *         "Statement": [{
 *           "Effect": "Allow",
 *           "Resource": ["*"],
 *           "Action": ["*"],
 *           "Principal": ["*"]
 *         }]
 *       }
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var domain = config.Get("domain") ?? "com.aliyun.cn-hangzhou.oss";
 *     var defaultVpc = new AliCloud.Vpc.Network("defaultVpc", new()
 *     {
 *         Description = "tf-example",
 *     });
 *     var defaultRg = new AliCloud.ResourceManager.ResourceGroup("defaultRg", new()
 *     {
 *         DisplayName = "tf-example-497",
 *         ResourceGroupName = name,
 *     });
 *     var @default = new AliCloud.Vpc.GatewayEndpoint("default", new()
 *     {
 *         GatewayEndpointDescrption = "test-gateway-endpoint",
 *         GatewayEndpointName = name,
 *         VpcId = defaultVpc.Id,
 *         ResourceGroupId = defaultRg.Id,
 *         ServiceName = domain,
 *         PolicyDocument = @"      {
 *         ""Version"": ""1"",
 *         ""Statement"": [{
 *           ""Effect"": ""Allow"",
 *           ""Resource"": [""*""],
 *           ""Action"": [""*""],
 *           ""Principal"": [""*""]
 *         }]
 *       }
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		domain := "com.aliyun.cn-hangzhou.oss"
 * 		if param := cfg.Get("domain"); param != "" {
 * 			domain = param
 * 		}
 * 		defaultVpc, err := vpc.NewNetwork(ctx, "defaultVpc", &vpc.NetworkArgs{
 * 			Description: pulumi.String("tf-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultRg, err := resourcemanager.NewResourceGroup(ctx, "defaultRg", &resourcemanager.ResourceGroupArgs{
 * 			DisplayName:       pulumi.String("tf-example-497"),
 * 			ResourceGroupName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewGatewayEndpoint(ctx, "default", &vpc.GatewayEndpointArgs{
 * 			GatewayEndpointDescrption: pulumi.String("test-gateway-endpoint"),
 * 			GatewayEndpointName:       pulumi.String(name),
 * 			VpcId:                     defaultVpc.ID(),
 * 			ResourceGroupId:           defaultRg.ID(),
 * 			ServiceName:               pulumi.String(domain),
 * 			PolicyDocument: pulumi.String(`      {
 *         "Version": "1",
 *         "Statement": [{
 *           "Effect": "Allow",
 *           "Resource": ["*"],
 *           "Action": ["*"],
 *           "Principal": ["*"]
 *         }]
 *       }
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.resourcemanager.ResourceGroup;
 * import com.pulumi.alicloud.resourcemanager.ResourceGroupArgs;
 * import com.pulumi.alicloud.vpc.GatewayEndpoint;
 * import com.pulumi.alicloud.vpc.GatewayEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var domain = config.get("domain").orElse("com.aliyun.cn-hangzhou.oss");
 *         var defaultVpc = new Network("defaultVpc", NetworkArgs.builder()
 *             .description("tf-example")
 *             .build());
 *         var defaultRg = new ResourceGroup("defaultRg", ResourceGroupArgs.builder()
 *             .displayName("tf-example-497")
 *             .resourceGroupName(name)
 *             .build());
 *         var default_ = new GatewayEndpoint("default", GatewayEndpointArgs.builder()
 *             .gatewayEndpointDescrption("test-gateway-endpoint")
 *             .gatewayEndpointName(name)
 *             .vpcId(defaultVpc.id())
 *             .resourceGroupId(defaultRg.id())
 *             .serviceName(domain)
 *             .policyDocument("""
 *       {
 *         "Version": "1",
 *         "Statement": [{
 *           "Effect": "Allow",
 *           "Resource": ["*"],
 *           "Action": ["*"],
 *           "Principal": ["*"]
 *         }]
 *       }
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 *   domain:
 *     type: string
 *     default: com.aliyun.cn-hangzhou.oss
 * resources:
 *   defaultVpc:
 *     type: alicloud:vpc:Network
 *     properties:
 *       description: tf-example
 *   defaultRg:
 *     type: alicloud:resourcemanager:ResourceGroup
 *     properties:
 *       displayName: tf-example-497
 *       resourceGroupName: ${name}
 *   default:
 *     type: alicloud:vpc:GatewayEndpoint
 *     properties:
 *       gatewayEndpointDescrption: test-gateway-endpoint
 *       gatewayEndpointName: ${name}
 *       vpcId: ${defaultVpc.id}
 *       resourceGroupId: ${defaultRg.id}
 *       serviceName: ${domain}
 *       policyDocument: |2
 *               {
 *                 "Version": "1",
 *                 "Statement": [{
 *                   "Effect": "Allow",
 *                   "Resource": ["*"],
 *                   "Action": ["*"],
 *                   "Principal": ["*"]
 *                 }]
 *               }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * VPC Gateway Endpoint can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/gatewayEndpoint:GatewayEndpoint example <id>
 * ```
 */
public class GatewayEndpoint internal constructor(
    override val javaResource: com.pulumi.alicloud.vpc.GatewayEndpoint,
) : KotlinCustomResource(javaResource, GatewayEndpointMapper) {
    /**
     * The creation time of the gateway endpoint.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The description of the gateway endpoint.
     */
    public val gatewayEndpointDescrption: Output<String>?
        get() = javaResource.gatewayEndpointDescrption().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the gateway endpoint.
     */
    public val gatewayEndpointName: Output<String>?
        get() = javaResource.gatewayEndpointName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Access control policies for cloud services. This parameter is required when the cloud service is oss. For details about the syntax and structure of access policies, see [syntax and structure of permission Policies](https://help.aliyun.com/document_detail/93739.html).
     */
    public val policyDocument: Output<String>?
        get() = javaResource.policyDocument().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the resource group to which the instance belongs.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The name of endpoint service.
     */
    public val serviceName: Output<String>
        get() = javaResource.serviceName().applyValue({ args0 -> args0 })

    /**
     * The status of VPC gateway endpoint.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The tags of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The ID of the VPC.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object GatewayEndpointMapper : ResourceMapper<GatewayEndpoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.vpc.GatewayEndpoint::class == javaResource::class

    override fun map(javaResource: Resource): GatewayEndpoint = GatewayEndpoint(
        javaResource as
            com.pulumi.alicloud.vpc.GatewayEndpoint,
    )
}

/**
 * @see [GatewayEndpoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GatewayEndpoint].
 */
public suspend fun gatewayEndpoint(
    name: String,
    block: suspend GatewayEndpointResourceBuilder.() -> Unit,
): GatewayEndpoint {
    val builder = GatewayEndpointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GatewayEndpoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun gatewayEndpoint(name: String): GatewayEndpoint {
    val builder = GatewayEndpointResourceBuilder()
    builder.name(name)
    return builder.build()
}
