@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.alicloud.vpc.GatewayEndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a VPC Gateway Endpoint resource. VPC gateway endpoint.
 * For information about VPC Gateway Endpoint and how to use it, see [What is Gateway Endpoint](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/gateway-endpoint).
 * > **NOTE:** Available since v1.208.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const domain = config.get("domain") || "com.aliyun.cn-hangzhou.oss";
 * const defaultVpc = new alicloud.vpc.Network("defaultVpc", {description: "tf-example"});
 * const defaultRg = new alicloud.resourcemanager.ResourceGroup("defaultRg", {
 *     displayName: "tf-example-497",
 *     resourceGroupName: name,
 * });
 * const _default = new alicloud.vpc.GatewayEndpoint("default", {
 *     gatewayEndpointDescrption: "test-gateway-endpoint",
 *     gatewayEndpointName: name,
 *     vpcId: defaultVpc.id,
 *     resourceGroupId: defaultRg.id,
 *     serviceName: domain,
 *     policyDocument: `      {
 *         "Version": "1",
 *         "Statement": [{
 *           "Effect": "Allow",
 *           "Resource": ["*"],
 *           "Action": ["*"],
 *           "Principal": ["*"]
 *         }]
 *       }
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * domain = config.get("domain")
 * if domain is None:
 *     domain = "com.aliyun.cn-hangzhou.oss"
 * default_vpc = alicloud.vpc.Network("defaultVpc", description="tf-example")
 * default_rg = alicloud.resourcemanager.ResourceGroup("defaultRg",
 *     display_name="tf-example-497",
 *     resource_group_name=name)
 * default = alicloud.vpc.GatewayEndpoint("default",
 *     gateway_endpoint_descrption="test-gateway-endpoint",
 *     gateway_endpoint_name=name,
 *     vpc_id=default_vpc.id,
 *     resource_group_id=default_rg.id,
 *     service_name=domain,
 *     policy_document="""      {
 *         "Version": "1",
 *         "Statement": [{
 *           "Effect": "Allow",
 *           "Resource": ["*"],
 *           "Action": ["*"],
 *           "Principal": ["*"]
 *         }]
 *       }
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var domain = config.Get("domain") ?? "com.aliyun.cn-hangzhou.oss";
 *     var defaultVpc = new AliCloud.Vpc.Network("defaultVpc", new()
 *     {
 *         Description = "tf-example",
 *     });
 *     var defaultRg = new AliCloud.ResourceManager.ResourceGroup("defaultRg", new()
 *     {
 *         DisplayName = "tf-example-497",
 *         ResourceGroupName = name,
 *     });
 *     var @default = new AliCloud.Vpc.GatewayEndpoint("default", new()
 *     {
 *         GatewayEndpointDescrption = "test-gateway-endpoint",
 *         GatewayEndpointName = name,
 *         VpcId = defaultVpc.Id,
 *         ResourceGroupId = defaultRg.Id,
 *         ServiceName = domain,
 *         PolicyDocument = @"      {
 *         ""Version"": ""1"",
 *         ""Statement"": [{
 *           ""Effect"": ""Allow"",
 *           ""Resource"": [""*""],
 *           ""Action"": [""*""],
 *           ""Principal"": [""*""]
 *         }]
 *       }
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		domain := "com.aliyun.cn-hangzhou.oss"
 * 		if param := cfg.Get("domain"); param != "" {
 * 			domain = param
 * 		}
 * 		defaultVpc, err := vpc.NewNetwork(ctx, "defaultVpc", &vpc.NetworkArgs{
 * 			Description: pulumi.String("tf-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultRg, err := resourcemanager.NewResourceGroup(ctx, "defaultRg", &resourcemanager.ResourceGroupArgs{
 * 			DisplayName:       pulumi.String("tf-example-497"),
 * 			ResourceGroupName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewGatewayEndpoint(ctx, "default", &vpc.GatewayEndpointArgs{
 * 			GatewayEndpointDescrption: pulumi.String("test-gateway-endpoint"),
 * 			GatewayEndpointName:       pulumi.String(name),
 * 			VpcId:                     defaultVpc.ID(),
 * 			ResourceGroupId:           defaultRg.ID(),
 * 			ServiceName:               pulumi.String(domain),
 * 			PolicyDocument: pulumi.String(`      {
 *         "Version": "1",
 *         "Statement": [{
 *           "Effect": "Allow",
 *           "Resource": ["*"],
 *           "Action": ["*"],
 *           "Principal": ["*"]
 *         }]
 *       }
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.resourcemanager.ResourceGroup;
 * import com.pulumi.alicloud.resourcemanager.ResourceGroupArgs;
 * import com.pulumi.alicloud.vpc.GatewayEndpoint;
 * import com.pulumi.alicloud.vpc.GatewayEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var domain = config.get("domain").orElse("com.aliyun.cn-hangzhou.oss");
 *         var defaultVpc = new Network("defaultVpc", NetworkArgs.builder()
 *             .description("tf-example")
 *             .build());
 *         var defaultRg = new ResourceGroup("defaultRg", ResourceGroupArgs.builder()
 *             .displayName("tf-example-497")
 *             .resourceGroupName(name)
 *             .build());
 *         var default_ = new GatewayEndpoint("default", GatewayEndpointArgs.builder()
 *             .gatewayEndpointDescrption("test-gateway-endpoint")
 *             .gatewayEndpointName(name)
 *             .vpcId(defaultVpc.id())
 *             .resourceGroupId(defaultRg.id())
 *             .serviceName(domain)
 *             .policyDocument("""
 *       {
 *         "Version": "1",
 *         "Statement": [{
 *           "Effect": "Allow",
 *           "Resource": ["*"],
 *           "Action": ["*"],
 *           "Principal": ["*"]
 *         }]
 *       }
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 *   domain:
 *     type: string
 *     default: com.aliyun.cn-hangzhou.oss
 * resources:
 *   defaultVpc:
 *     type: alicloud:vpc:Network
 *     properties:
 *       description: tf-example
 *   defaultRg:
 *     type: alicloud:resourcemanager:ResourceGroup
 *     properties:
 *       displayName: tf-example-497
 *       resourceGroupName: ${name}
 *   default:
 *     type: alicloud:vpc:GatewayEndpoint
 *     properties:
 *       gatewayEndpointDescrption: test-gateway-endpoint
 *       gatewayEndpointName: ${name}
 *       vpcId: ${defaultVpc.id}
 *       resourceGroupId: ${defaultRg.id}
 *       serviceName: ${domain}
 *       policyDocument: |2
 *               {
 *                 "Version": "1",
 *                 "Statement": [{
 *                   "Effect": "Allow",
 *                   "Resource": ["*"],
 *                   "Action": ["*"],
 *                   "Principal": ["*"]
 *                 }]
 *               }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * VPC Gateway Endpoint can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/gatewayEndpoint:GatewayEndpoint example <id>
 * ```
 * @property gatewayEndpointDescrption The description of the gateway endpoint.
 * @property gatewayEndpointName The name of the gateway endpoint.
 * @property policyDocument Access control policies for cloud services. This parameter is required when the cloud service is oss. For details about the syntax and structure of access policies, see [syntax and structure of permission Policies](https://help.aliyun.com/document_detail/93739.html).
 * @property resourceGroupId The ID of the resource group to which the instance belongs.
 * @property serviceName The name of endpoint service.
 * @property tags The tags of the resource.
 * @property vpcId The ID of the VPC.
 */
public data class GatewayEndpointArgs(
    public val gatewayEndpointDescrption: Output<String>? = null,
    public val gatewayEndpointName: Output<String>? = null,
    public val policyDocument: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.GatewayEndpointArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.GatewayEndpointArgs =
        com.pulumi.alicloud.vpc.GatewayEndpointArgs.builder()
            .gatewayEndpointDescrption(gatewayEndpointDescrption?.applyValue({ args0 -> args0 }))
            .gatewayEndpointName(gatewayEndpointName?.applyValue({ args0 -> args0 }))
            .policyDocument(policyDocument?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayEndpointArgs].
 */
@PulumiTagMarker
public class GatewayEndpointArgsBuilder internal constructor() {
    private var gatewayEndpointDescrption: Output<String>? = null

    private var gatewayEndpointName: Output<String>? = null

    private var policyDocument: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value The description of the gateway endpoint.
     */
    @JvmName("lalbxejurqidxksu")
    public suspend fun gatewayEndpointDescrption(`value`: Output<String>) {
        this.gatewayEndpointDescrption = value
    }

    /**
     * @param value The name of the gateway endpoint.
     */
    @JvmName("nelosttytkrpiibq")
    public suspend fun gatewayEndpointName(`value`: Output<String>) {
        this.gatewayEndpointName = value
    }

    /**
     * @param value Access control policies for cloud services. This parameter is required when the cloud service is oss. For details about the syntax and structure of access policies, see [syntax and structure of permission Policies](https://help.aliyun.com/document_detail/93739.html).
     */
    @JvmName("ojpstqbiwyumehog")
    public suspend fun policyDocument(`value`: Output<String>) {
        this.policyDocument = value
    }

    /**
     * @param value The ID of the resource group to which the instance belongs.
     */
    @JvmName("fumhfgdcujpcjsnv")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The name of endpoint service.
     */
    @JvmName("juevftljhcokyafn")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("kipynfrjgbesoijf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the VPC.
     */
    @JvmName("xuacueyaifavhgvd")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The description of the gateway endpoint.
     */
    @JvmName("rxgijovvbisvcutv")
    public suspend fun gatewayEndpointDescrption(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayEndpointDescrption = mapped
    }

    /**
     * @param value The name of the gateway endpoint.
     */
    @JvmName("oldysuecokodnpwt")
    public suspend fun gatewayEndpointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayEndpointName = mapped
    }

    /**
     * @param value Access control policies for cloud services. This parameter is required when the cloud service is oss. For details about the syntax and structure of access policies, see [syntax and structure of permission Policies](https://help.aliyun.com/document_detail/93739.html).
     */
    @JvmName("etgsfryghhcyhrxo")
    public suspend fun policyDocument(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyDocument = mapped
    }

    /**
     * @param value The ID of the resource group to which the instance belongs.
     */
    @JvmName("hfkdqhaijgvcoitb")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The name of endpoint service.
     */
    @JvmName("mfosnayflchauwst")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("wobdgcabhjlwwimn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of the resource.
     */
    @JvmName("ylyxywwuffefrvxi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ID of the VPC.
     */
    @JvmName("ydavbrnwhyhnxppx")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): GatewayEndpointArgs = GatewayEndpointArgs(
        gatewayEndpointDescrption = gatewayEndpointDescrption,
        gatewayEndpointName = gatewayEndpointName,
        policyDocument = policyDocument,
        resourceGroupId = resourceGroupId,
        serviceName = serviceName,
        tags = tags,
        vpcId = vpcId,
    )
}
