@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.alicloud.vpc.GatewayEndpointRouteTableAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a VPC Gateway Endpoint Route Table Attachment resource. VPC gateway node association route.
 * For information about VPC Gateway Endpoint Route Table Attachment and how to use it, see [What is Gateway Endpoint Route Table Attachment](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/311148).
 * > **NOTE:** Available since v1.208.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const defaulteVpc = new alicloud.vpc.Network("defaulteVpc", {description: "test"});
 * const defaultGE = new alicloud.vpc.GatewayEndpoint("defaultGE", {
 *     serviceName: "com.aliyun.cn-hangzhou.oss",
 *     policyDocument: `        {
 *           "Version": "1",
 *           "Statement": [{
 *             "Effect": "Allow",
 *             "Resource": ["*"],
 *             "Action": ["*"],
 *             "Principal": ["*"]
 *           }]
 *         }
 * `,
 *     vpcId: defaulteVpc.id,
 *     gatewayEndpointDescrption: "test-gateway-endpoint",
 *     gatewayEndpointName: `${name}1`,
 * });
 * const defaultRT = new alicloud.vpc.RouteTable("defaultRT", {
 *     vpcId: defaulteVpc.id,
 *     routeTableName: `${name}2`,
 * });
 * const _default = new alicloud.vpc.GatewayEndpointRouteTableAttachment("default", {
 *     gatewayEndpointId: defaultGE.id,
 *     routeTableId: defaultRT.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * defaulte_vpc = alicloud.vpc.Network("defaulteVpc", description="test")
 * default_ge = alicloud.vpc.GatewayEndpoint("defaultGE",
 *     service_name="com.aliyun.cn-hangzhou.oss",
 *     policy_document="""        {
 *           "Version": "1",
 *           "Statement": [{
 *             "Effect": "Allow",
 *             "Resource": ["*"],
 *             "Action": ["*"],
 *             "Principal": ["*"]
 *           }]
 *         }
 * """,
 *     vpc_id=defaulte_vpc.id,
 *     gateway_endpoint_descrption="test-gateway-endpoint",
 *     gateway_endpoint_name=f"{name}1")
 * default_rt = alicloud.vpc.RouteTable("defaultRT",
 *     vpc_id=defaulte_vpc.id,
 *     route_table_name=f"{name}2")
 * default = alicloud.vpc.GatewayEndpointRouteTableAttachment("default",
 *     gateway_endpoint_id=default_ge.id,
 *     route_table_id=default_rt.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var defaulteVpc = new AliCloud.Vpc.Network("defaulteVpc", new()
 *     {
 *         Description = "test",
 *     });
 *     var defaultGE = new AliCloud.Vpc.GatewayEndpoint("defaultGE", new()
 *     {
 *         ServiceName = "com.aliyun.cn-hangzhou.oss",
 *         PolicyDocument = @"        {
 *           ""Version"": ""1"",
 *           ""Statement"": [{
 *             ""Effect"": ""Allow"",
 *             ""Resource"": [""*""],
 *             ""Action"": [""*""],
 *             ""Principal"": [""*""]
 *           }]
 *         }
 * ",
 *         VpcId = defaulteVpc.Id,
 *         GatewayEndpointDescrption = "test-gateway-endpoint",
 *         GatewayEndpointName = $"{name}1",
 *     });
 *     var defaultRT = new AliCloud.Vpc.RouteTable("defaultRT", new()
 *     {
 *         VpcId = defaulteVpc.Id,
 *         RouteTableName = $"{name}2",
 *     });
 *     var @default = new AliCloud.Vpc.GatewayEndpointRouteTableAttachment("default", new()
 *     {
 *         GatewayEndpointId = defaultGE.Id,
 *         RouteTableId = defaultRT.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		defaulteVpc, err := vpc.NewNetwork(ctx, "defaulteVpc", &vpc.NetworkArgs{
 * 			Description: pulumi.String("test"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGE, err := vpc.NewGatewayEndpoint(ctx, "defaultGE", &vpc.GatewayEndpointArgs{
 * 			ServiceName: pulumi.String("com.aliyun.cn-hangzhou.oss"),
 * 			PolicyDocument: pulumi.String(`        {
 *           "Version": "1",
 *           "Statement": [{
 *             "Effect": "Allow",
 *             "Resource": ["*"],
 *             "Action": ["*"],
 *             "Principal": ["*"]
 *           }]
 *         }
 * `),
 * 			VpcId:                     defaulteVpc.ID(),
 * 			GatewayEndpointDescrption: pulumi.String("test-gateway-endpoint"),
 * 			GatewayEndpointName:       pulumi.Sprintf("%v1", name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultRT, err := vpc.NewRouteTable(ctx, "defaultRT", &vpc.RouteTableArgs{
 * 			VpcId:          defaulteVpc.ID(),
 * 			RouteTableName: pulumi.Sprintf("%v2", name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewGatewayEndpointRouteTableAttachment(ctx, "default", &vpc.GatewayEndpointRouteTableAttachmentArgs{
 * 			GatewayEndpointId: defaultGE.ID(),
 * 			RouteTableId:      defaultRT.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.GatewayEndpoint;
 * import com.pulumi.alicloud.vpc.GatewayEndpointArgs;
 * import com.pulumi.alicloud.vpc.RouteTable;
 * import com.pulumi.alicloud.vpc.RouteTableArgs;
 * import com.pulumi.alicloud.vpc.GatewayEndpointRouteTableAttachment;
 * import com.pulumi.alicloud.vpc.GatewayEndpointRouteTableAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var defaulteVpc = new Network("defaulteVpc", NetworkArgs.builder()
 *             .description("test")
 *             .build());
 *         var defaultGE = new GatewayEndpoint("defaultGE", GatewayEndpointArgs.builder()
 *             .serviceName("com.aliyun.cn-hangzhou.oss")
 *             .policyDocument("""
 *         {
 *           "Version": "1",
 *           "Statement": [{
 *             "Effect": "Allow",
 *             "Resource": ["*"],
 *             "Action": ["*"],
 *             "Principal": ["*"]
 *           }]
 *         }
 *             """)
 *             .vpcId(defaulteVpc.id())
 *             .gatewayEndpointDescrption("test-gateway-endpoint")
 *             .gatewayEndpointName(String.format("%s1", name))
 *             .build());
 *         var defaultRT = new RouteTable("defaultRT", RouteTableArgs.builder()
 *             .vpcId(defaulteVpc.id())
 *             .routeTableName(String.format("%s2", name))
 *             .build());
 *         var default_ = new GatewayEndpointRouteTableAttachment("default", GatewayEndpointRouteTableAttachmentArgs.builder()
 *             .gatewayEndpointId(defaultGE.id())
 *             .routeTableId(defaultRT.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   defaulteVpc:
 *     type: alicloud:vpc:Network
 *     properties:
 *       description: test
 *   defaultGE:
 *     type: alicloud:vpc:GatewayEndpoint
 *     properties:
 *       serviceName: com.aliyun.cn-hangzhou.oss
 *       policyDocument: |2
 *                 {
 *                   "Version": "1",
 *                   "Statement": [{
 *                     "Effect": "Allow",
 *                     "Resource": ["*"],
 *                     "Action": ["*"],
 *                     "Principal": ["*"]
 *                   }]
 *                 }
 *       vpcId: ${defaulteVpc.id}
 *       gatewayEndpointDescrption: test-gateway-endpoint
 *       gatewayEndpointName: ${name}1
 *   defaultRT:
 *     type: alicloud:vpc:RouteTable
 *     properties:
 *       vpcId: ${defaulteVpc.id}
 *       routeTableName: ${name}2
 *   default:
 *     type: alicloud:vpc:GatewayEndpointRouteTableAttachment
 *     properties:
 *       gatewayEndpointId: ${defaultGE.id}
 *       routeTableId: ${defaultRT.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * VPC Gateway Endpoint Route Table Attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/gatewayEndpointRouteTableAttachment:GatewayEndpointRouteTableAttachment example <gateway_endpoint_id>:<route_table_id>
 * ```
 * @property gatewayEndpointId The ID of the gateway endpoint instance to which you want to associate the route table.
 * @property routeTableId Routing table ID.
 */
public data class GatewayEndpointRouteTableAttachmentArgs(
    public val gatewayEndpointId: Output<String>? = null,
    public val routeTableId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.GatewayEndpointRouteTableAttachmentArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.GatewayEndpointRouteTableAttachmentArgs =
        com.pulumi.alicloud.vpc.GatewayEndpointRouteTableAttachmentArgs.builder()
            .gatewayEndpointId(gatewayEndpointId?.applyValue({ args0 -> args0 }))
            .routeTableId(routeTableId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayEndpointRouteTableAttachmentArgs].
 */
@PulumiTagMarker
public class GatewayEndpointRouteTableAttachmentArgsBuilder internal constructor() {
    private var gatewayEndpointId: Output<String>? = null

    private var routeTableId: Output<String>? = null

    /**
     * @param value The ID of the gateway endpoint instance to which you want to associate the route table.
     */
    @JvmName("utfnadamcrtyrijq")
    public suspend fun gatewayEndpointId(`value`: Output<String>) {
        this.gatewayEndpointId = value
    }

    /**
     * @param value Routing table ID.
     */
    @JvmName("tkcasthgsxfopgum")
    public suspend fun routeTableId(`value`: Output<String>) {
        this.routeTableId = value
    }

    /**
     * @param value The ID of the gateway endpoint instance to which you want to associate the route table.
     */
    @JvmName("emaimgyyxhvlthov")
    public suspend fun gatewayEndpointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayEndpointId = mapped
    }

    /**
     * @param value Routing table ID.
     */
    @JvmName("eprwtrvjseemveub")
    public suspend fun routeTableId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeTableId = mapped
    }

    internal fun build(): GatewayEndpointRouteTableAttachmentArgs =
        GatewayEndpointRouteTableAttachmentArgs(
            gatewayEndpointId = gatewayEndpointId,
            routeTableId = routeTableId,
        )
}
