@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [HAVip].
 */
@PulumiTagMarker
public class HAVipResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HAVipArgs = HAVipArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HAVipArgsBuilder.() -> Unit) {
        val builder = HAVipArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): HAVip {
        val builtJavaResource = com.pulumi.alicloud.vpc.HAVip(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return HAVip(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const example = new alicloud.vpc.Network("example", {
 *     vpcName: name,
 *     cidrBlock: "10.4.0.0/16",
 * });
 * const exampleSwitch = new alicloud.vpc.Switch("example", {
 *     vswitchName: name,
 *     cidrBlock: "10.4.0.0/24",
 *     vpcId: example.id,
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 * });
 * const exampleHAVip = new alicloud.vpc.HAVip("example", {
 *     vswitchId: exampleSwitch.id,
 *     description: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * example = alicloud.vpc.Network("example",
 *     vpc_name=name,
 *     cidr_block="10.4.0.0/16")
 * example_switch = alicloud.vpc.Switch("example",
 *     vswitch_name=name,
 *     cidr_block="10.4.0.0/24",
 *     vpc_id=example.id,
 *     zone_id=default.zones[0].id)
 * example_ha_vip = alicloud.vpc.HAVip("example",
 *     vswitch_id=example_switch.id,
 *     description=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var example = new AliCloud.Vpc.Network("example", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.4.0.0/16",
 *     });
 *     var exampleSwitch = new AliCloud.Vpc.Switch("example", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "10.4.0.0/24",
 *         VpcId = example.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *     });
 *     var exampleHAVip = new AliCloud.Vpc.HAVip("example", new()
 *     {
 *         VswitchId = exampleSwitch.Id,
 *         Description = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := vpc.NewNetwork(ctx, "example", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.4.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleSwitch, err := vpc.NewSwitch(ctx, "example", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("10.4.0.0/24"),
 * 			VpcId:       example.ID(),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewHAVip(ctx, "example", &vpc.HAVipArgs{
 * 			VswitchId:   exampleSwitch.ID(),
 * 			Description: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.vpc.HAVip;
 * import com.pulumi.alicloud.vpc.HAVipArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var example = new Network("example", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.4.0.0/16")
 *             .build());
 *         var exampleSwitch = new Switch("exampleSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("10.4.0.0/24")
 *             .vpcId(example.id())
 *             .zoneId(default_.zones()[0].id())
 *             .build());
 *         var exampleHAVip = new HAVip("exampleHAVip", HAVipArgs.builder()
 *             .vswitchId(exampleSwitch.id())
 *             .description(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   example:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.4.0.0/16
 *   exampleSwitch:
 *     type: alicloud:vpc:Switch
 *     name: example
 *     properties:
 *       vswitchName: ${name}
 *       cidrBlock: 10.4.0.0/24
 *       vpcId: ${example.id}
 *       zoneId: ${default.zones[0].id}
 *   exampleHAVip:
 *     type: alicloud:vpc:HAVip
 *     name: example
 *     properties:
 *       vswitchId: ${exampleSwitch.id}
 *       description: ${name}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * The havip can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/hAVip:HAVip foo havip-abc123456
 * ```
 */
public class HAVip internal constructor(
    override val javaResource: com.pulumi.alicloud.vpc.HAVip,
) : KotlinCustomResource(javaResource, HAVipMapper) {
    /**
     * The elastic IP address (EIP) associated with the HAVIP.
     */
    public val associatedEipAddresses: Output<List<String>>
        get() = javaResource.associatedEipAddresses().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The type of the instance with which the HAVIP is associated. Valid values:
     * - `EcsInstance`: an ECS instance.
     * - `NetworkInterface`: an ENI.
     */
    public val associatedInstanceType: Output<String>
        get() = javaResource.associatedInstanceType().applyValue({ args0 -> args0 })

    /**
     * The ID of the instance with which the HAVIP is associated.
     */
    public val associatedInstances: Output<List<String>>
        get() = javaResource.associatedInstances().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The time when the HAVIP was created.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The description of the HaVip instance.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the HAVIP.
     */
    public val haVipId: Output<String>
        get() = javaResource.haVipId().applyValue({ args0 -> args0 })

    /**
     * The name of the HAVIP.
     */
    public val haVipName: Output<String>
        get() = javaResource.haVipName().applyValue({ args0 -> args0 })

    /**
     * The name of the HaVip instance.
     */
    @Deprecated(
        message = """
  Field 'havip_name' has been deprecated from provider version 1.205.0. New field 'ha_vip_name'
      instead.
  """,
    )
    public val havipName: Output<String>
        get() = javaResource.havipName().applyValue({ args0 -> args0 })

    /**
     * The ip address of the HaVip. If not filled, the default will be assigned one from the vswitch.
     */
    public val ipAddress: Output<String>
        get() = javaResource.ipAddress().applyValue({ args0 -> args0 })

    /**
     * The ID of the active instance that is associated with the HAVIP.
     */
    public val masterInstanceId: Output<String>
        get() = javaResource.masterInstanceId().applyValue({ args0 -> args0 })

    /**
     * The ID of the resource group to which the HAVIP belongs.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * (Available in v1.120.0+) The status of the HaVip instance.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The list of tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The ID of the VPC to which the HAVIP belongs.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The vswitch_id of the HaVip, the field can't be changed.
     */
    public val vswitchId: Output<String>
        get() = javaResource.vswitchId().applyValue({ args0 -> args0 })
}

public object HAVipMapper : ResourceMapper<HAVip> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.vpc.HAVip::class == javaResource::class

    override fun map(javaResource: Resource): HAVip = HAVip(
        javaResource as
            com.pulumi.alicloud.vpc.HAVip,
    )
}

/**
 * @see [HAVip].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [HAVip].
 */
public suspend fun haVip(name: String, block: suspend HAVipResourceBuilder.() -> Unit): HAVip {
    val builder = HAVipResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [HAVip].
 * @param name The _unique_ name of the resulting resource.
 */
public fun haVip(name: String): HAVip {
    val builder = HAVipResourceBuilder()
    builder.name(name)
    return builder.build()
}
