@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.alicloud.vpc.HAVipArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Deprecated
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-example";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const example = new alicloud.vpc.Network("example", {
 *     vpcName: name,
 *     cidrBlock: "10.4.0.0/16",
 * });
 * const exampleSwitch = new alicloud.vpc.Switch("example", {
 *     vswitchName: name,
 *     cidrBlock: "10.4.0.0/24",
 *     vpcId: example.id,
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 * });
 * const exampleHAVip = new alicloud.vpc.HAVip("example", {
 *     vswitchId: exampleSwitch.id,
 *     description: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-example"
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * example = alicloud.vpc.Network("example",
 *     vpc_name=name,
 *     cidr_block="10.4.0.0/16")
 * example_switch = alicloud.vpc.Switch("example",
 *     vswitch_name=name,
 *     cidr_block="10.4.0.0/24",
 *     vpc_id=example.id,
 *     zone_id=default.zones[0].id)
 * example_ha_vip = alicloud.vpc.HAVip("example",
 *     vswitch_id=example_switch.id,
 *     description=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-example";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var example = new AliCloud.Vpc.Network("example", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.4.0.0/16",
 *     });
 *     var exampleSwitch = new AliCloud.Vpc.Switch("example", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "10.4.0.0/24",
 *         VpcId = example.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *     });
 *     var exampleHAVip = new AliCloud.Vpc.HAVip("example", new()
 *     {
 *         VswitchId = exampleSwitch.Id,
 *         Description = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := vpc.NewNetwork(ctx, "example", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.4.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleSwitch, err := vpc.NewSwitch(ctx, "example", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("10.4.0.0/24"),
 * 			VpcId:       example.ID(),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewHAVip(ctx, "example", &vpc.HAVipArgs{
 * 			VswitchId:   exampleSwitch.ID(),
 * 			Description: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.vpc.HAVip;
 * import com.pulumi.alicloud.vpc.HAVipArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-example");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var example = new Network("example", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.4.0.0/16")
 *             .build());
 *         var exampleSwitch = new Switch("exampleSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("10.4.0.0/24")
 *             .vpcId(example.id())
 *             .zoneId(default_.zones()[0].id())
 *             .build());
 *         var exampleHAVip = new HAVip("exampleHAVip", HAVipArgs.builder()
 *             .vswitchId(exampleSwitch.id())
 *             .description(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-example
 * resources:
 *   example:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.4.0.0/16
 *   exampleSwitch:
 *     type: alicloud:vpc:Switch
 *     name: example
 *     properties:
 *       vswitchName: ${name}
 *       cidrBlock: 10.4.0.0/24
 *       vpcId: ${example.id}
 *       zoneId: ${default.zones[0].id}
 *   exampleHAVip:
 *     type: alicloud:vpc:HAVip
 *     name: example
 *     properties:
 *       vswitchId: ${exampleSwitch.id}
 *       description: ${name}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * The havip can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/hAVip:HAVip foo havip-abc123456
 * ```
 * @property description The description of the HaVip instance.
 * @property haVipName The name of the HAVIP.
 * @property havipName The name of the HaVip instance.
 * @property ipAddress The ip address of the HaVip. If not filled, the default will be assigned one from the vswitch.
 * @property resourceGroupId The ID of the resource group to which the HAVIP belongs.
 * @property tags The list of tags.
 * @property vswitchId The vswitch_id of the HaVip, the field can't be changed.
 */
public data class HAVipArgs(
    public val description: Output<String>? = null,
    public val haVipName: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'havip_name' has been deprecated from provider version 1.205.0. New field 'ha_vip_name'
      instead.
  """,
    )
    public val havipName: Output<String>? = null,
    public val ipAddress: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vswitchId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.HAVipArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.HAVipArgs =
        com.pulumi.alicloud.vpc.HAVipArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .haVipName(haVipName?.applyValue({ args0 -> args0 }))
            .havipName(havipName?.applyValue({ args0 -> args0 }))
            .ipAddress(ipAddress?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HAVipArgs].
 */
@PulumiTagMarker
public class HAVipArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var haVipName: Output<String>? = null

    private var havipName: Output<String>? = null

    private var ipAddress: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vswitchId: Output<String>? = null

    /**
     * @param value The description of the HaVip instance.
     */
    @JvmName("engidxrdunlqqxvq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the HAVIP.
     */
    @JvmName("pejrxmyofppqfbab")
    public suspend fun haVipName(`value`: Output<String>) {
        this.haVipName = value
    }

    /**
     * @param value The name of the HaVip instance.
     */
    @Deprecated(
        message = """
  Field 'havip_name' has been deprecated from provider version 1.205.0. New field 'ha_vip_name'
      instead.
  """,
    )
    @JvmName("lxbcnjumxeavbdru")
    public suspend fun havipName(`value`: Output<String>) {
        this.havipName = value
    }

    /**
     * @param value The ip address of the HaVip. If not filled, the default will be assigned one from the vswitch.
     */
    @JvmName("cxwpipujsxfqxuca")
    public suspend fun ipAddress(`value`: Output<String>) {
        this.ipAddress = value
    }

    /**
     * @param value The ID of the resource group to which the HAVIP belongs.
     */
    @JvmName("ujeqwjubirdmvdkc")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The list of tags.
     */
    @JvmName("btosqdvjyasgltlu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The vswitch_id of the HaVip, the field can't be changed.
     */
    @JvmName("thtvalkeppahhutu")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The description of the HaVip instance.
     */
    @JvmName("wydwnhuvoiopmjku")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the HAVIP.
     */
    @JvmName("flvwsfbfbtyblfog")
    public suspend fun haVipName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.haVipName = mapped
    }

    /**
     * @param value The name of the HaVip instance.
     */
    @Deprecated(
        message = """
  Field 'havip_name' has been deprecated from provider version 1.205.0. New field 'ha_vip_name'
      instead.
  """,
    )
    @JvmName("pxnkptiqnfsoxjlm")
    public suspend fun havipName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.havipName = mapped
    }

    /**
     * @param value The ip address of the HaVip. If not filled, the default will be assigned one from the vswitch.
     */
    @JvmName("offikhyafhqcvkak")
    public suspend fun ipAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddress = mapped
    }

    /**
     * @param value The ID of the resource group to which the HAVIP belongs.
     */
    @JvmName("pxleqcxlmyluuskm")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The list of tags.
     */
    @JvmName("ppsvuicofhooskpg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The list of tags.
     */
    @JvmName("vtouwamsdlamsusc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The vswitch_id of the HaVip, the field can't be changed.
     */
    @JvmName("smwnlvtoxfkuohhb")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    internal fun build(): HAVipArgs = HAVipArgs(
        description = description,
        haVipName = haVipName,
        havipName = havipName,
        ipAddress = ipAddress,
        resourceGroupId = resourceGroupId,
        tags = tags,
        vswitchId = vswitchId,
    )
}
