@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [HAVipAttachment].
 */
@PulumiTagMarker
public class HAVipAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HAVipAttachmentArgs = HAVipAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HAVipAttachmentArgsBuilder.() -> Unit) {
        val builder = HAVipAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): HAVipAttachment {
        val builtJavaResource = com.pulumi.alicloud.vpc.HAVipAttachment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return HAVipAttachment(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const example = _default.then(_default => alicloud.ecs.getInstanceTypes({
 *     availabilityZone: _default.zones?.[0]?.id,
 *     cpuCoreCount: 1,
 *     memorySize: 2,
 * }));
 * const exampleGetImages = alicloud.ecs.getImages({
 *     nameRegex: "^ubuntu_18.*64",
 *     owners: "system",
 * });
 * const exampleNetwork = new alicloud.vpc.Network("example", {
 *     vpcName: name,
 *     cidrBlock: "10.4.0.0/16",
 * });
 * const exampleSwitch = new alicloud.vpc.Switch("example", {
 *     vswitchName: name,
 *     cidrBlock: "10.4.0.0/24",
 *     vpcId: exampleNetwork.id,
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 * });
 * const exampleHAVip = new alicloud.vpc.HAVip("example", {
 *     vswitchId: exampleSwitch.id,
 *     description: name,
 * });
 * const exampleSecurityGroup = new alicloud.ecs.SecurityGroup("example", {
 *     name: name,
 *     description: name,
 *     vpcId: exampleNetwork.id,
 * });
 * const exampleInstance = new alicloud.ecs.Instance("example", {
 *     availabilityZone: _default.then(_default => _default.zones?.[0]?.id),
 *     vswitchId: exampleSwitch.id,
 *     imageId: exampleGetImages.then(exampleGetImages => exampleGetImages.images?.[0]?.id),
 *     instanceType: example.then(example => example.instanceTypes?.[0]?.id),
 *     systemDiskCategory: "cloud_efficiency",
 *     internetChargeType: "PayByTraffic",
 *     internetMaxBandwidthOut: 5,
 *     securityGroups: [exampleSecurityGroup&#46;id],
 *     instanceName: name,
 *     userData: "echo 'net.ipv4.ip_forward=1'>> /etc/sysctl.conf",
 * });
 * const exampleHAVipAttachment = new alicloud.vpc.HAVipAttachment("example", {
 *     havipId: exampleHAVip.id,
 *     instanceId: exampleInstance.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * example = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
 *     cpu_core_count=1,
 *     memory_size=2)
 * example_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
 *     owners="system")
 * example_network = alicloud.vpc.Network("example",
 *     vpc_name=name,
 *     cidr_block="10.4.0.0/16")
 * example_switch = alicloud.vpc.Switch("example",
 *     vswitch_name=name,
 *     cidr_block="10.4.0.0/24",
 *     vpc_id=example_network.id,
 *     zone_id=default.zones[0].id)
 * example_ha_vip = alicloud.vpc.HAVip("example",
 *     vswitch_id=example_switch.id,
 *     description=name)
 * example_security_group = alicloud.ecs.SecurityGroup("example",
 *     name=name,
 *     description=name,
 *     vpc_id=example_network.id)
 * example_instance = alicloud.ecs.Instance("example",
 *     availability_zone=default.zones[0].id,
 *     vswitch_id=example_switch.id,
 *     image_id=example_get_images.images[0].id,
 *     instance_type=example.instance_types[0].id,
 *     system_disk_category="cloud_efficiency",
 *     internet_charge_type="PayByTraffic",
 *     internet_max_bandwidth_out=5,
 *     security_groups=[example_security_group&#46;id],
 *     instance_name=name,
 *     user_data="echo 'net.ipv4.ip_forward=1'>> /etc/sysctl.conf")
 * example_ha_vip_attachment = alicloud.vpc.HAVipAttachment("example",
 *     havip_id=example_ha_vip.id,
 *     instance_id=example_instance.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var example = AliCloud.Ecs.GetInstanceTypes.Invoke(new()
 *     {
 *         AvailabilityZone = @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         CpuCoreCount = 1,
 *         MemorySize = 2,
 *     });
 *     var exampleGetImages = AliCloud.Ecs.GetImages.Invoke(new()
 *     {
 *         NameRegex = "^ubuntu_18.*64",
 *         Owners = "system",
 *     });
 *     var exampleNetwork = new AliCloud.Vpc.Network("example", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.4.0.0/16",
 *     });
 *     var exampleSwitch = new AliCloud.Vpc.Switch("example", new()
 *     {
 *         VswitchName = name,
 *         CidrBlock = "10.4.0.0/24",
 *         VpcId = exampleNetwork.Id,
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *     });
 *     var exampleHAVip = new AliCloud.Vpc.HAVip("example", new()
 *     {
 *         VswitchId = exampleSwitch.Id,
 *         Description = name,
 *     });
 *     var exampleSecurityGroup = new AliCloud.Ecs.SecurityGroup("example", new()
 *     {
 *         Name = name,
 *         Description = name,
 *         VpcId = exampleNetwork.Id,
 *     });
 *     var exampleInstance = new AliCloud.Ecs.Instance("example", new()
 *     {
 *         AvailabilityZone = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         VswitchId = exampleSwitch.Id,
 *         ImageId = exampleGetImages.Apply(getImagesResult => getImagesResult.Images[0]?.Id),
 *         InstanceType = example.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes[0]?.Id),
 *         SystemDiskCategory = "cloud_efficiency",
 *         InternetChargeType = "PayByTraffic",
 *         InternetMaxBandwidthOut = 5,
 *         SecurityGroups = new[]
 *         {
 *             exampleSecurityGroup.Id,
 *         },
 *         InstanceName = name,
 *         UserData = "echo 'net.ipv4.ip_forward=1'>> /etc/sysctl.conf",
 *     });
 *     var exampleHAVipAttachment = new AliCloud.Vpc.HAVipAttachment("example", new()
 *     {
 *         HavipId = exampleHAVip.Id,
 *         InstanceId = exampleInstance.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := ecs.GetInstanceTypes(ctx, &ecs.GetInstanceTypesArgs{
 * 			AvailabilityZone: pulumi.StringRef(_default.Zones[0].Id),
 * 			CpuCoreCount:     pulumi.IntRef(1),
 * 			MemorySize:       pulumi.Float64Ref(2),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleGetImages, err := ecs.GetImages(ctx, &ecs.GetImagesArgs{
 * 			NameRegex: pulumi.StringRef("^ubuntu_18.*64"),
 * 			Owners:    pulumi.StringRef("system"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleNetwork, err := vpc.NewNetwork(ctx, "example", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.4.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleSwitch, err := vpc.NewSwitch(ctx, "example", &vpc.SwitchArgs{
 * 			VswitchName: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("10.4.0.0/24"),
 * 			VpcId:       exampleNetwork.ID(),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleHAVip, err := vpc.NewHAVip(ctx, "example", &vpc.HAVipArgs{
 * 			VswitchId:   exampleSwitch.ID(),
 * 			Description: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleSecurityGroup, err := ecs.NewSecurityGroup(ctx, "example", &ecs.SecurityGroupArgs{
 * 			Name:        pulumi.String(name),
 * 			Description: pulumi.String(name),
 * 			VpcId:       exampleNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleInstance, err := ecs.NewInstance(ctx, "example", &ecs.InstanceArgs{
 * 			AvailabilityZone:        pulumi.String(_default.Zones[0].Id),
 * 			VswitchId:               exampleSwitch.ID(),
 * 			ImageId:                 pulumi.String(exampleGetImages.Images[0].Id),
 * 			InstanceType:            pulumi.String(example.InstanceTypes[0].Id),
 * 			SystemDiskCategory:      pulumi.String("cloud_efficiency"),
 * 			InternetChargeType:      pulumi.String("PayByTraffic"),
 * 			InternetMaxBandwidthOut: pulumi.Int(5),
 * 			SecurityGroups: pulumi.StringArray{
 * 				exampleSecurityGroup.ID(),
 * 			},
 * 			InstanceName: pulumi.String(name),
 * 			UserData:     pulumi.String("echo 'net.ipv4.ip_forward=1'>> /etc/sysctl.conf"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewHAVipAttachment(ctx, "example", &vpc.HAVipAttachmentArgs{
 * 			HavipId:    exampleHAVip.ID(),
 * 			InstanceId: exampleInstance.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetInstanceTypesArgs;
 * import com.pulumi.alicloud.ecs.inputs.GetImagesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.vpc.HAVip;
 * import com.pulumi.alicloud.vpc.HAVipArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.ecs.Instance;
 * import com.pulumi.alicloud.ecs.InstanceArgs;
 * import com.pulumi.alicloud.vpc.HAVipAttachment;
 * import com.pulumi.alicloud.vpc.HAVipAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         final var example = EcsFunctions.getInstanceTypes(GetInstanceTypesArgs.builder()
 *             .availabilityZone(default_.zones()[0].id())
 *             .cpuCoreCount(1)
 *             .memorySize(2)
 *             .build());
 *         final var exampleGetImages = EcsFunctions.getImages(GetImagesArgs.builder()
 *             .nameRegex("^ubuntu_18.*64")
 *             .owners("system")
 *             .build());
 *         var exampleNetwork = new Network("exampleNetwork", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.4.0.0/16")
 *             .build());
 *         var exampleSwitch = new Switch("exampleSwitch", SwitchArgs.builder()
 *             .vswitchName(name)
 *             .cidrBlock("10.4.0.0/24")
 *             .vpcId(exampleNetwork.id())
 *             .zoneId(default_.zones()[0].id())
 *             .build());
 *         var exampleHAVip = new HAVip("exampleHAVip", HAVipArgs.builder()
 *             .vswitchId(exampleSwitch.id())
 *             .description(name)
 *             .build());
 *         var exampleSecurityGroup = new SecurityGroup("exampleSecurityGroup", SecurityGroupArgs.builder()
 *             .name(name)
 *             .description(name)
 *             .vpcId(exampleNetwork.id())
 *             .build());
 *         var exampleInstance = new Instance("exampleInstance", InstanceArgs.builder()
 *             .availabilityZone(default_.zones()[0].id())
 *             .vswitchId(exampleSwitch.id())
 *             .imageId(exampleGetImages.applyValue(getImagesResult -> getImagesResult.images()[0].id()))
 *             .instanceType(example.applyValue(getInstanceTypesResult -> getInstanceTypesResult.instanceTypes()[0].id()))
 *             .systemDiskCategory("cloud_efficiency")
 *             .internetChargeType("PayByTraffic")
 *             .internetMaxBandwidthOut(5)
 *             .securityGroups(exampleSecurityGroup.id())
 *             .instanceName(name)
 *             .userData("echo 'net.ipv4.ip_forward=1'>> /etc/sysctl.conf")
 *             .build());
 *         var exampleHAVipAttachment = new HAVipAttachment("exampleHAVipAttachment", HAVipAttachmentArgs.builder()
 *             .havipId(exampleHAVip.id())
 *             .instanceId(exampleInstance.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   exampleNetwork:
 *     type: alicloud:vpc:Network
 *     name: example
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.4.0.0/16
 *   exampleSwitch:
 *     type: alicloud:vpc:Switch
 *     name: example
 *     properties:
 *       vswitchName: ${name}
 *       cidrBlock: 10.4.0.0/24
 *       vpcId: ${exampleNetwork.id}
 *       zoneId: ${default.zones[0].id}
 *   exampleHAVip:
 *     type: alicloud:vpc:HAVip
 *     name: example
 *     properties:
 *       vswitchId: ${exampleSwitch.id}
 *       description: ${name}
 *   exampleSecurityGroup:
 *     type: alicloud:ecs:SecurityGroup
 *     name: example
 *     properties:
 *       name: ${name}
 *       description: ${name}
 *       vpcId: ${exampleNetwork.id}
 *   exampleInstance:
 *     type: alicloud:ecs:Instance
 *     name: example
 *     properties:
 *       availabilityZone: ${default.zones[0].id}
 *       vswitchId: ${exampleSwitch.id}
 *       imageId: ${exampleGetImages.images[0].id}
 *       instanceType: ${example.instanceTypes[0].id}
 *       systemDiskCategory: cloud_efficiency
 *       internetChargeType: PayByTraffic
 *       internetMaxBandwidthOut: 5
 *       securityGroups:
 *         - ${exampleSecurityGroup.id}
 *       instanceName: ${name}
 *       userData: echo 'net.ipv4.ip_forward=1'>> /etc/sysctl.conf
 *   exampleHAVipAttachment:
 *     type: alicloud:vpc:HAVipAttachment
 *     name: example
 *     properties:
 *       havipId: ${exampleHAVip.id}
 *       instanceId: ${exampleInstance.id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 *   example:
 *     fn::invoke:
 *       Function: alicloud:ecs:getInstanceTypes
 *       Arguments:
 *         availabilityZone: ${default.zones[0].id}
 *         cpuCoreCount: 1
 *         memorySize: 2
 *   exampleGetImages:
 *     fn::invoke:
 *       Function: alicloud:ecs:getImages
 *       Arguments:
 *         nameRegex: ^ubuntu_18.*64
 *         owners: system
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * VPC Ha Vip Attachment can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/hAVipAttachment:HAVipAttachment example <ha_vip_id>:<instance_id>
 * ```
 */
public class HAVipAttachment internal constructor(
    override val javaResource: com.pulumi.alicloud.vpc.HAVipAttachment,
) : KotlinCustomResource(javaResource, HAVipAttachmentMapper) {
    /**
     * Whether to force the ECS instance or Eni instance bound to AVIP to be unbound. The value is:
     * - **True**: Force unbinding.
     * - **False** (default): unbinding is not forced.
     * > **NOTE:**  If the value of this parameter is **False**, the Master instance bound to HaVip cannot be unbound.
     */
    public val force: Output<Boolean>?
        get() = javaResource.force().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the HaVip instance.
     */
    public val haVipId: Output<String>
        get() = javaResource.haVipId().applyValue({ args0 -> args0 })

    /**
     * . Field 'havip_id' has been deprecated from provider version 1.211.0. New field 'ha_vip_id' instead.
     */
    @Deprecated(
        message = """
  Field 'havip_id' has been deprecated since provider version 1.211.0. New field 'ha_vip_id'
      instead.
  """,
    )
    public val havipId: Output<String>
        get() = javaResource.havipId().applyValue({ args0 -> args0 })

    /**
     * The ID of the ECS instance bound to the HaVip instance.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * The type of the instance associated with the VIIP.
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    public val instanceType: Output<String>
        get() = javaResource.instanceType().applyValue({ args0 -> args0 })

    /**
     * The status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object HAVipAttachmentMapper : ResourceMapper<HAVipAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.vpc.HAVipAttachment::class == javaResource::class

    override fun map(javaResource: Resource): HAVipAttachment = HAVipAttachment(
        javaResource as
            com.pulumi.alicloud.vpc.HAVipAttachment,
    )
}

/**
 * @see [HAVipAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [HAVipAttachment].
 */
public suspend fun haVipAttachment(
    name: String,
    block: suspend HAVipAttachmentResourceBuilder.() -> Unit,
): HAVipAttachment {
    val builder = HAVipAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [HAVipAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun haVipAttachment(name: String): HAVipAttachment {
    val builder = HAVipAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
