@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [HaVipv2].
 */
@PulumiTagMarker
public class HaVipv2ResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HaVipv2Args = HaVipv2Args()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HaVipv2ArgsBuilder.() -> Unit) {
        val builder = HaVipv2ArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): HaVipv2 {
        val builtJavaResource = com.pulumi.alicloud.vpc.HaVipv2(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return HaVipv2(builtJavaResource)
    }
}

/**
 * Provides a Vpc Ha Vip resource. Highly available virtual IP
 * For information about Vpc Ha Vip and how to use it, see [What is Ha Vip](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/createhavip).
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-testacc-example";
 * const default = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultVpc = new alicloud.vpc.Network("defaultVpc", {
 *     description: "tf-test-acc-vpc",
 *     vpcName: name,
 *     cidrBlock: "192.168.0.0/16",
 * });
 * const defaultVswitch = new alicloud.vpc.Switch("defaultVswitch", {
 *     vpcId: defaultVpc.id,
 *     cidrBlock: "192.168.0.0/21",
 *     vswitchName: `${name}1`,
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     description: "tf-testacc-vswitch",
 * });
 * const defaultRg = new alicloud.resourcemanager.ResourceGroup("defaultRg", {
 *     displayName: "tf-testacc-rg819",
 *     resourceGroupName: `${name}2`,
 * });
 * const changeRg = new alicloud.resourcemanager.ResourceGroup("changeRg", {
 *     displayName: "tf-testacc-changerg670",
 *     resourceGroupName: `${name}3`,
 * });
 * const defaultHaVipv2 = new alicloud.vpc.HaVipv2("default", {
 *     description: "test",
 *     vswitchId: defaultVswitch.id,
 *     haVipName: name,
 *     ipAddress: "192.168.1.101",
 *     resourceGroupId: defaultRg.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-testacc-example"
 * default = alicloud.get_zones(available_resource_creation="VSwitch")
 * default_vpc = alicloud.vpc.Network("defaultVpc",
 *     description="tf-test-acc-vpc",
 *     vpc_name=name,
 *     cidr_block="192.168.0.0/16")
 * default_vswitch = alicloud.vpc.Switch("defaultVswitch",
 *     vpc_id=default_vpc.id,
 *     cidr_block="192.168.0.0/21",
 *     vswitch_name=f"{name}1",
 *     zone_id=default.zones[0].id,
 *     description="tf-testacc-vswitch")
 * default_rg = alicloud.resourcemanager.ResourceGroup("defaultRg",
 *     display_name="tf-testacc-rg819",
 *     resource_group_name=f"{name}2")
 * change_rg = alicloud.resourcemanager.ResourceGroup("changeRg",
 *     display_name="tf-testacc-changerg670",
 *     resource_group_name=f"{name}3")
 * default_ha_vipv2 = alicloud.vpc.HaVipv2("default",
 *     description="test",
 *     vswitch_id=default_vswitch.id,
 *     ha_vip_name=name,
 *     ip_address="192.168.1.101",
 *     resource_group_id=default_rg.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-testacc-example";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultVpc = new AliCloud.Vpc.Network("defaultVpc", new()
 *     {
 *         Description = "tf-test-acc-vpc",
 *         VpcName = name,
 *         CidrBlock = "192.168.0.0/16",
 *     });
 *     var defaultVswitch = new AliCloud.Vpc.Switch("defaultVswitch", new()
 *     {
 *         VpcId = defaultVpc.Id,
 *         CidrBlock = "192.168.0.0/21",
 *         VswitchName = $"{name}1",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         Description = "tf-testacc-vswitch",
 *     });
 *     var defaultRg = new AliCloud.ResourceManager.ResourceGroup("defaultRg", new()
 *     {
 *         DisplayName = "tf-testacc-rg819",
 *         ResourceGroupName = $"{name}2",
 *     });
 *     var changeRg = new AliCloud.ResourceManager.ResourceGroup("changeRg", new()
 *     {
 *         DisplayName = "tf-testacc-changerg670",
 *         ResourceGroupName = $"{name}3",
 *     });
 *     var defaultHaVipv2 = new AliCloud.Vpc.HaVipv2("default", new()
 *     {
 *         Description = "test",
 *         VswitchId = defaultVswitch.Id,
 *         HaVipName = name,
 *         IpAddress = "192.168.1.101",
 *         ResourceGroupId = defaultRg.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-testacc-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultVpc, err := vpc.NewNetwork(ctx, "defaultVpc", &vpc.NetworkArgs{
 * 			Description: pulumi.String("tf-test-acc-vpc"),
 * 			VpcName:     pulumi.String(name),
 * 			CidrBlock:   pulumi.String("192.168.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultVswitch, err := vpc.NewSwitch(ctx, "defaultVswitch", &vpc.SwitchArgs{
 * 			VpcId:       defaultVpc.ID(),
 * 			CidrBlock:   pulumi.String("192.168.0.0/21"),
 * 			VswitchName: pulumi.Sprintf("%v1", name),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 			Description: pulumi.String("tf-testacc-vswitch"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultRg, err := resourcemanager.NewResourceGroup(ctx, "defaultRg", &resourcemanager.ResourceGroupArgs{
 * 			DisplayName:       pulumi.String("tf-testacc-rg819"),
 * 			ResourceGroupName: pulumi.Sprintf("%v2", name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = resourcemanager.NewResourceGroup(ctx, "changeRg", &resourcemanager.ResourceGroupArgs{
 * 			DisplayName:       pulumi.String("tf-testacc-changerg670"),
 * 			ResourceGroupName: pulumi.Sprintf("%v3", name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewHaVipv2(ctx, "default", &vpc.HaVipv2Args{
 * 			Description:     pulumi.String("test"),
 * 			VswitchId:       defaultVswitch.ID(),
 * 			HaVipName:       pulumi.String(name),
 * 			IpAddress:       pulumi.String("192.168.1.101"),
 * 			ResourceGroupId: defaultRg.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.resourcemanager.ResourceGroup;
 * import com.pulumi.alicloud.resourcemanager.ResourceGroupArgs;
 * import com.pulumi.alicloud.vpc.HaVipv2;
 * import com.pulumi.alicloud.vpc.HaVipv2Args;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-testacc-example");
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var defaultVpc = new Network("defaultVpc", NetworkArgs.builder()
 *             .description("tf-test-acc-vpc")
 *             .vpcName(name)
 *             .cidrBlock("192.168.0.0/16")
 *             .build());
 *         var defaultVswitch = new Switch("defaultVswitch", SwitchArgs.builder()
 *             .vpcId(defaultVpc.id())
 *             .cidrBlock("192.168.0.0/21")
 *             .vswitchName(String.format("%s1", name))
 *             .zoneId(default_.zones()[0].id())
 *             .description("tf-testacc-vswitch")
 *             .build());
 *         var defaultRg = new ResourceGroup("defaultRg", ResourceGroupArgs.builder()
 *             .displayName("tf-testacc-rg819")
 *             .resourceGroupName(String.format("%s2", name))
 *             .build());
 *         var changeRg = new ResourceGroup("changeRg", ResourceGroupArgs.builder()
 *             .displayName("tf-testacc-changerg670")
 *             .resourceGroupName(String.format("%s3", name))
 *             .build());
 *         var defaultHaVipv2 = new HaVipv2("defaultHaVipv2", HaVipv2Args.builder()
 *             .description("test")
 *             .vswitchId(defaultVswitch.id())
 *             .haVipName(name)
 *             .ipAddress("192.168.1.101")
 *             .resourceGroupId(defaultRg.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-testacc-example
 * resources:
 *   defaultVpc:
 *     type: alicloud:vpc:Network
 *     properties:
 *       description: tf-test-acc-vpc
 *       vpcName: ${name}
 *       cidrBlock: 192.168.0.0/16
 *   defaultVswitch:
 *     type: alicloud:vpc:Switch
 *     properties:
 *       vpcId: ${defaultVpc.id}
 *       cidrBlock: 192.168.0.0/21
 *       vswitchName: ${name}1
 *       zoneId: ${default.zones[0].id}
 *       description: tf-testacc-vswitch
 *   defaultRg:
 *     type: alicloud:resourcemanager:ResourceGroup
 *     properties:
 *       displayName: tf-testacc-rg819
 *       resourceGroupName: ${name}2
 *   changeRg:
 *     type: alicloud:resourcemanager:ResourceGroup
 *     properties:
 *       displayName: tf-testacc-changerg670
 *       resourceGroupName: ${name}3
 *   defaultHaVipv2:
 *     type: alicloud:vpc:HaVipv2
 *     name: default
 *     properties:
 *       description: test
 *       vswitchId: ${defaultVswitch.id}
 *       haVipName: ${name}
 *       ipAddress: 192.168.1.101
 *       resourceGroupId: ${defaultRg.id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Vpc Ha Vip can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/haVipv2:HaVipv2 example <id>
 * ```
 */
public class HaVipv2 internal constructor(
    override val javaResource: com.pulumi.alicloud.vpc.HaVipv2,
) : KotlinCustomResource(javaResource, HaVipv2Mapper) {
    /**
     * EIP bound to HaVip.
     */
    public val associatedEipAddresses: Output<List<String>>
        get() = javaResource.associatedEipAddresses().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The type of the instance that is bound to the HaVip. Value:-**EcsInstance**: ECS instance.-**NetworkInterface**: ENI instance.
     */
    public val associatedInstanceType: Output<String>
        get() = javaResource.associatedInstanceType().applyValue({ args0 -> args0 })

    /**
     * An ECS instance that is bound to HaVip.
     */
    public val associatedInstances: Output<List<String>>
        get() = javaResource.associatedInstances().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The creation time of the resource.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The description of the HaVip instance. The length is 2 to 256 characters.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the resource.
     */
    public val haVipId: Output<String>
        get() = javaResource.haVipId().applyValue({ args0 -> args0 })

    /**
     * The name of the HaVip instance.
     */
    public val haVipName: Output<String>
        get() = javaResource.haVipName().applyValue({ args0 -> args0 })

    /**
     * Field 'havip_name' has been deprecated from provider version 1.205.0. New field 'ha_vip_name' instead.
     */
    @Deprecated(
        message = """
  Field 'havip_name' has been deprecated from provider version 1.205.0. New field 'ha_vip_name'
      instead.
  """,
    )
    public val havipName: Output<String>
        get() = javaResource.havipName().applyValue({ args0 -> args0 })

    /**
     * The ip address of the HaVip. If not filled, the default will be assigned one from the vswitch.
     */
    public val ipAddress: Output<String>
        get() = javaResource.ipAddress().applyValue({ args0 -> args0 })

    /**
     * The primary instance ID bound to HaVip.
     */
    public val masterInstanceId: Output<String>
        get() = javaResource.masterInstanceId().applyValue({ args0 -> args0 })

    /**
     * The ID of the resource group.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The status of this resource instance.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The tags of HaVip.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The VPC ID to which the HaVip instance belongs.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The switch ID to which the HaVip instance belongs.
     * The following arguments will be discarded. Please use new fields as soon as possible:
     */
    public val vswitchId: Output<String>
        get() = javaResource.vswitchId().applyValue({ args0 -> args0 })
}

public object HaVipv2Mapper : ResourceMapper<HaVipv2> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.vpc.HaVipv2::class == javaResource::class

    override fun map(javaResource: Resource): HaVipv2 = HaVipv2(
        javaResource as
            com.pulumi.alicloud.vpc.HaVipv2,
    )
}

/**
 * @see [HaVipv2].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [HaVipv2].
 */
public suspend fun haVipv2(name: String, block: suspend HaVipv2ResourceBuilder.() -> Unit): HaVipv2 {
    val builder = HaVipv2ResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [HaVipv2].
 * @param name The _unique_ name of the resulting resource.
 */
public fun haVipv2(name: String): HaVipv2 {
    val builder = HaVipv2ResourceBuilder()
    builder.name(name)
    return builder.build()
}
