@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Ipv4CidrBlock].
 */
@PulumiTagMarker
public class Ipv4CidrBlockResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: Ipv4CidrBlockArgs = Ipv4CidrBlockArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend Ipv4CidrBlockArgsBuilder.() -> Unit) {
        val builder = Ipv4CidrBlockArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Ipv4CidrBlock {
        val builtJavaResource = com.pulumi.alicloud.vpc.Ipv4CidrBlock(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Ipv4CidrBlock(builtJavaResource)
    }
}

/**
 * Provides a VPC Ipv4 Cidr Block resource. VPC IPv4 additional network segment.
 * For information about VPC Ipv4 Cidr Block and how to use it, see [What is Ipv4 Cidr Block](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/associatevpccidrblock).
 * > **NOTE:** Available since v1.185.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const defaultvpc = new alicloud.vpc.Network("defaultvpc", {description: name});
 * const _default = new alicloud.vpc.Ipv4CidrBlock("default", {
 *     secondaryCidrBlock: "192.168.0.0/16",
 *     vpcId: defaultvpc.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * defaultvpc = alicloud.vpc.Network("defaultvpc", description=name)
 * default = alicloud.vpc.Ipv4CidrBlock("default",
 *     secondary_cidr_block="192.168.0.0/16",
 *     vpc_id=defaultvpc.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var defaultvpc = new AliCloud.Vpc.Network("defaultvpc", new()
 *     {
 *         Description = name,
 *     });
 *     var @default = new AliCloud.Vpc.Ipv4CidrBlock("default", new()
 *     {
 *         SecondaryCidrBlock = "192.168.0.0/16",
 *         VpcId = defaultvpc.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		defaultvpc, err := vpc.NewNetwork(ctx, "defaultvpc", &vpc.NetworkArgs{
 * 			Description: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewIpv4CidrBlock(ctx, "default", &vpc.Ipv4CidrBlockArgs{
 * 			SecondaryCidrBlock: pulumi.String("192.168.0.0/16"),
 * 			VpcId:              defaultvpc.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Ipv4CidrBlock;
 * import com.pulumi.alicloud.vpc.Ipv4CidrBlockArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var defaultvpc = new Network("defaultvpc", NetworkArgs.builder()
 *             .description(name)
 *             .build());
 *         var default_ = new Ipv4CidrBlock("default", Ipv4CidrBlockArgs.builder()
 *             .secondaryCidrBlock("192.168.0.0/16")
 *             .vpcId(defaultvpc.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   defaultvpc:
 *     type: alicloud:vpc:Network
 *     properties:
 *       description: ${name}
 *   default:
 *     type: alicloud:vpc:Ipv4CidrBlock
 *     properties:
 *       secondaryCidrBlock: 192.168.0.0/16
 *       vpcId: ${defaultvpc.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * VPC Ipv4 Cidr Block can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/ipv4CidrBlock:Ipv4CidrBlock example <vpc_id>:<secondary_cidr_block>
 * ```
 */
public class Ipv4CidrBlock internal constructor(
    override val javaResource: com.pulumi.alicloud.vpc.Ipv4CidrBlock,
) : KotlinCustomResource(javaResource, Ipv4CidrBlockMapper) {
    /**
     * The IPv4 CIDR block. Take note of the following requirements:
     * * You can specify one of the following standard IPv4 CIDR blocks or their subnets as the secondary IPv4 CIDR block: 192.168.0.0/16, 172.16.0.0/12, and 10.0.0.0/8.
     * * You can also use a custom CIDR block other than 100.64.0.0/10, 224.0.0.0/4, 127.0.0.0/8, 169.254.0.0/16, or their subnets as the secondary IPv4 CIDR block of the VPC.
     * * The CIDR block cannot start with 0. The subnet mask must be 8 to 28 bits in length.
     * * The secondary CIDR block cannot overlap with the primary CIDR block or an existing secondary CIDR block.
     */
    public val secondaryCidrBlock: Output<String>
        get() = javaResource.secondaryCidrBlock().applyValue({ args0 -> args0 })

    /**
     * The ID of the VPC.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object Ipv4CidrBlockMapper : ResourceMapper<Ipv4CidrBlock> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.vpc.Ipv4CidrBlock::class == javaResource::class

    override fun map(javaResource: Resource): Ipv4CidrBlock = Ipv4CidrBlock(
        javaResource as
            com.pulumi.alicloud.vpc.Ipv4CidrBlock,
    )
}

/**
 * @see [Ipv4CidrBlock].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Ipv4CidrBlock].
 */
public suspend fun ipv4CidrBlock(
    name: String,
    block: suspend Ipv4CidrBlockResourceBuilder.() -> Unit,
): Ipv4CidrBlock {
    val builder = Ipv4CidrBlockResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Ipv4CidrBlock].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ipv4CidrBlock(name: String): Ipv4CidrBlock {
    val builder = Ipv4CidrBlockResourceBuilder()
    builder.name(name)
    return builder.build()
}
