@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Ipv4Gateway].
 */
@PulumiTagMarker
public class Ipv4GatewayResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: Ipv4GatewayArgs = Ipv4GatewayArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend Ipv4GatewayArgsBuilder.() -> Unit) {
        val builder = Ipv4GatewayArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Ipv4Gateway {
        val builtJavaResource = com.pulumi.alicloud.vpc.Ipv4Gateway(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Ipv4Gateway(builtJavaResource)
    }
}

/**
 * Provides a Vpc Ipv4 Gateway resource.
 * For information about Vpc Ipv4 Gateway and how to use it, see [What is Ipv4 Gateway](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/createipv4gateway).
 * > **NOTE:** Available in v1.181.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-testacc-example";
 * const _default = new alicloud.resourcemanager.ResourceGroup("default", {
 *     displayName: "tf-testAcc-rg665",
 *     resourceGroupName: name,
 * });
 * const modify = new alicloud.resourcemanager.ResourceGroup("modify", {
 *     displayName: "tf-testAcc-rg298",
 *     resourceGroupName: `${name}1`,
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: `${name}2`,
 *     cidrBlock: "10.0.0.0/8",
 * });
 * const defaultIpv4Gateway = new alicloud.vpc.Ipv4Gateway("default", {
 *     ipv4GatewayName: name,
 *     ipv4GatewayDescription: "tf-testAcc-Ipv4Gateway",
 *     resourceGroupId: _default.id,
 *     vpcId: defaultNetwork.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-testacc-example"
 * default = alicloud.resourcemanager.ResourceGroup("default",
 *     display_name="tf-testAcc-rg665",
 *     resource_group_name=name)
 * modify = alicloud.resourcemanager.ResourceGroup("modify",
 *     display_name="tf-testAcc-rg298",
 *     resource_group_name=f"{name}1")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=f"{name}2",
 *     cidr_block="10.0.0.0/8")
 * default_ipv4_gateway = alicloud.vpc.Ipv4Gateway("default",
 *     ipv4_gateway_name=name,
 *     ipv4_gateway_description="tf-testAcc-Ipv4Gateway",
 *     resource_group_id=default.id,
 *     vpc_id=default_network.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-testacc-example";
 *     var @default = new AliCloud.ResourceManager.ResourceGroup("default", new()
 *     {
 *         DisplayName = "tf-testAcc-rg665",
 *         ResourceGroupName = name,
 *     });
 *     var modify = new AliCloud.ResourceManager.ResourceGroup("modify", new()
 *     {
 *         DisplayName = "tf-testAcc-rg298",
 *         ResourceGroupName = $"{name}1",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = $"{name}2",
 *         CidrBlock = "10.0.0.0/8",
 *     });
 *     var defaultIpv4Gateway = new AliCloud.Vpc.Ipv4Gateway("default", new()
 *     {
 *         Ipv4GatewayName = name,
 *         Ipv4GatewayDescription = "tf-testAcc-Ipv4Gateway",
 *         ResourceGroupId = @default.Id,
 *         VpcId = defaultNetwork.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-testacc-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := resourcemanager.NewResourceGroup(ctx, "default", &resourcemanager.ResourceGroupArgs{
 * 			DisplayName:       pulumi.String("tf-testAcc-rg665"),
 * 			ResourceGroupName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = resourcemanager.NewResourceGroup(ctx, "modify", &resourcemanager.ResourceGroupArgs{
 * 			DisplayName:       pulumi.String("tf-testAcc-rg298"),
 * 			ResourceGroupName: pulumi.Sprintf("%v1", name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.Sprintf("%v2", name),
 * 			CidrBlock: pulumi.String("10.0.0.0/8"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewIpv4Gateway(ctx, "default", &vpc.Ipv4GatewayArgs{
 * 			Ipv4GatewayName:        pulumi.String(name),
 * 			Ipv4GatewayDescription: pulumi.String("tf-testAcc-Ipv4Gateway"),
 * 			ResourceGroupId:        _default.ID(),
 * 			VpcId:                  defaultNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourceGroup;
 * import com.pulumi.alicloud.resourcemanager.ResourceGroupArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Ipv4Gateway;
 * import com.pulumi.alicloud.vpc.Ipv4GatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-testacc-example");
 *         var default_ = new ResourceGroup("default", ResourceGroupArgs.builder()
 *             .displayName("tf-testAcc-rg665")
 *             .resourceGroupName(name)
 *             .build());
 *         var modify = new ResourceGroup("modify", ResourceGroupArgs.builder()
 *             .displayName("tf-testAcc-rg298")
 *             .resourceGroupName(String.format("%s1", name))
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(String.format("%s2", name))
 *             .cidrBlock("10.0.0.0/8")
 *             .build());
 *         var defaultIpv4Gateway = new Ipv4Gateway("defaultIpv4Gateway", Ipv4GatewayArgs.builder()
 *             .ipv4GatewayName(name)
 *             .ipv4GatewayDescription("tf-testAcc-Ipv4Gateway")
 *             .resourceGroupId(default_.id())
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-testacc-example
 * resources:
 *   default:
 *     type: alicloud:resourcemanager:ResourceGroup
 *     properties:
 *       displayName: tf-testAcc-rg665
 *       resourceGroupName: ${name}
 *   modify:
 *     type: alicloud:resourcemanager:ResourceGroup
 *     properties:
 *       displayName: tf-testAcc-rg298
 *       resourceGroupName: ${name}1
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}2
 *       cidrBlock: 10.0.0.0/8
 *   defaultIpv4Gateway:
 *     type: alicloud:vpc:Ipv4Gateway
 *     name: default
 *     properties:
 *       ipv4GatewayName: ${name}
 *       ipv4GatewayDescription: tf-testAcc-Ipv4Gateway
 *       resourceGroupId: ${default.id}
 *       vpcId: ${defaultNetwork.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Vpc Ipv4 Gateway can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/ipv4Gateway:Ipv4Gateway example <id>
 * ```
 */
public class Ipv4Gateway internal constructor(
    override val javaResource: com.pulumi.alicloud.vpc.Ipv4Gateway,
) : KotlinCustomResource(javaResource, Ipv4GatewayMapper) {
    /**
     * The creation time of the resource.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Whether to PreCheck only this request. Value:-**true**: The check request is sent without creating an IPv4 Gateway. Check items include whether required parameters, request format, and business restrictions are filled in. If the check does not pass, the corresponding error is returned. If the check passes, the error code 'DryRunOperation' is returned '.-**false** (default): Sends a normal request, returns an HTTP 2xx status code and directly creates an IPv4 Gateway.
     */
    public val dryRun: Output<Boolean>?
        get() = javaResource.dryRun().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Whether the IPv4 gateway is active or not. Valid values are **true** and **false**.
     */
    public val enabled: Output<Boolean>
        get() = javaResource.enabled().applyValue({ args0 -> args0 })

    /**
     * The description of the IPv4 gateway. The description must be 2 to 256 characters in length. It must start with a letter but cannot start with http:// or https://.
     */
    public val ipv4GatewayDescription: Output<String>?
        get() = javaResource.ipv4GatewayDescription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource primary key field.
     */
    public val ipv4GatewayId: Output<String>
        get() = javaResource.ipv4GatewayId().applyValue({ args0 -> args0 })

    /**
     * The name of the IPv4 gateway. The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). It must start with a letter.
     */
    public val ipv4GatewayName: Output<String>?
        get() = javaResource.ipv4GatewayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ID of the route table associated with IPv4 Gateway.
     */
    public val ipv4GatewayRouteTableId: Output<String>
        get() = javaResource.ipv4GatewayRouteTableId().applyValue({ args0 -> args0 })

    /**
     * The ID of the resource group to which the instance belongs.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The tags of the current resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The ID of the virtual private cloud (VPC) where you want to create the IPv4 gateway. You can create only one IPv4 gateway in a VPC.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object Ipv4GatewayMapper : ResourceMapper<Ipv4Gateway> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.vpc.Ipv4Gateway::class == javaResource::class

    override fun map(javaResource: Resource): Ipv4Gateway = Ipv4Gateway(
        javaResource as
            com.pulumi.alicloud.vpc.Ipv4Gateway,
    )
}

/**
 * @see [Ipv4Gateway].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Ipv4Gateway].
 */
public suspend fun ipv4Gateway(name: String, block: suspend Ipv4GatewayResourceBuilder.() -> Unit): Ipv4Gateway {
    val builder = Ipv4GatewayResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Ipv4Gateway].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ipv4Gateway(name: String): Ipv4Gateway {
    val builder = Ipv4GatewayResourceBuilder()
    builder.name(name)
    return builder.build()
}
