@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.alicloud.vpc.Ipv4GatewayArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Vpc Ipv4 Gateway resource.
 * For information about Vpc Ipv4 Gateway and how to use it, see [What is Ipv4 Gateway](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/createipv4gateway).
 * > **NOTE:** Available in v1.181.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-testacc-example";
 * const _default = new alicloud.resourcemanager.ResourceGroup("default", {
 *     displayName: "tf-testAcc-rg665",
 *     resourceGroupName: name,
 * });
 * const modify = new alicloud.resourcemanager.ResourceGroup("modify", {
 *     displayName: "tf-testAcc-rg298",
 *     resourceGroupName: `${name}1`,
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: `${name}2`,
 *     cidrBlock: "10.0.0.0/8",
 * });
 * const defaultIpv4Gateway = new alicloud.vpc.Ipv4Gateway("default", {
 *     ipv4GatewayName: name,
 *     ipv4GatewayDescription: "tf-testAcc-Ipv4Gateway",
 *     resourceGroupId: _default.id,
 *     vpcId: defaultNetwork.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-testacc-example"
 * default = alicloud.resourcemanager.ResourceGroup("default",
 *     display_name="tf-testAcc-rg665",
 *     resource_group_name=name)
 * modify = alicloud.resourcemanager.ResourceGroup("modify",
 *     display_name="tf-testAcc-rg298",
 *     resource_group_name=f"{name}1")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=f"{name}2",
 *     cidr_block="10.0.0.0/8")
 * default_ipv4_gateway = alicloud.vpc.Ipv4Gateway("default",
 *     ipv4_gateway_name=name,
 *     ipv4_gateway_description="tf-testAcc-Ipv4Gateway",
 *     resource_group_id=default.id,
 *     vpc_id=default_network.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-testacc-example";
 *     var @default = new AliCloud.ResourceManager.ResourceGroup("default", new()
 *     {
 *         DisplayName = "tf-testAcc-rg665",
 *         ResourceGroupName = name,
 *     });
 *     var modify = new AliCloud.ResourceManager.ResourceGroup("modify", new()
 *     {
 *         DisplayName = "tf-testAcc-rg298",
 *         ResourceGroupName = $"{name}1",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = $"{name}2",
 *         CidrBlock = "10.0.0.0/8",
 *     });
 *     var defaultIpv4Gateway = new AliCloud.Vpc.Ipv4Gateway("default", new()
 *     {
 *         Ipv4GatewayName = name,
 *         Ipv4GatewayDescription = "tf-testAcc-Ipv4Gateway",
 *         ResourceGroupId = @default.Id,
 *         VpcId = defaultNetwork.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-testacc-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := resourcemanager.NewResourceGroup(ctx, "default", &resourcemanager.ResourceGroupArgs{
 * 			DisplayName:       pulumi.String("tf-testAcc-rg665"),
 * 			ResourceGroupName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = resourcemanager.NewResourceGroup(ctx, "modify", &resourcemanager.ResourceGroupArgs{
 * 			DisplayName:       pulumi.String("tf-testAcc-rg298"),
 * 			ResourceGroupName: pulumi.Sprintf("%v1", name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.Sprintf("%v2", name),
 * 			CidrBlock: pulumi.String("10.0.0.0/8"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewIpv4Gateway(ctx, "default", &vpc.Ipv4GatewayArgs{
 * 			Ipv4GatewayName:        pulumi.String(name),
 * 			Ipv4GatewayDescription: pulumi.String("tf-testAcc-Ipv4Gateway"),
 * 			ResourceGroupId:        _default.ID(),
 * 			VpcId:                  defaultNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourceGroup;
 * import com.pulumi.alicloud.resourcemanager.ResourceGroupArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Ipv4Gateway;
 * import com.pulumi.alicloud.vpc.Ipv4GatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-testacc-example");
 *         var default_ = new ResourceGroup("default", ResourceGroupArgs.builder()
 *             .displayName("tf-testAcc-rg665")
 *             .resourceGroupName(name)
 *             .build());
 *         var modify = new ResourceGroup("modify", ResourceGroupArgs.builder()
 *             .displayName("tf-testAcc-rg298")
 *             .resourceGroupName(String.format("%s1", name))
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(String.format("%s2", name))
 *             .cidrBlock("10.0.0.0/8")
 *             .build());
 *         var defaultIpv4Gateway = new Ipv4Gateway("defaultIpv4Gateway", Ipv4GatewayArgs.builder()
 *             .ipv4GatewayName(name)
 *             .ipv4GatewayDescription("tf-testAcc-Ipv4Gateway")
 *             .resourceGroupId(default_.id())
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-testacc-example
 * resources:
 *   default:
 *     type: alicloud:resourcemanager:ResourceGroup
 *     properties:
 *       displayName: tf-testAcc-rg665
 *       resourceGroupName: ${name}
 *   modify:
 *     type: alicloud:resourcemanager:ResourceGroup
 *     properties:
 *       displayName: tf-testAcc-rg298
 *       resourceGroupName: ${name}1
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${name}2
 *       cidrBlock: 10.0.0.0/8
 *   defaultIpv4Gateway:
 *     type: alicloud:vpc:Ipv4Gateway
 *     name: default
 *     properties:
 *       ipv4GatewayName: ${name}
 *       ipv4GatewayDescription: tf-testAcc-Ipv4Gateway
 *       resourceGroupId: ${default.id}
 *       vpcId: ${defaultNetwork.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Vpc Ipv4 Gateway can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/ipv4Gateway:Ipv4Gateway example <id>
 * ```
 * @property dryRun Whether to PreCheck only this request. Value:-**true**: The check request is sent without creating an IPv4 Gateway. Check items include whether required parameters, request format, and business restrictions are filled in. If the check does not pass, the corresponding error is returned. If the check passes, the error code 'DryRunOperation' is returned '.-**false** (default): Sends a normal request, returns an HTTP 2xx status code and directly creates an IPv4 Gateway.
 * @property enabled Whether the IPv4 gateway is active or not. Valid values are **true** and **false**.
 * @property ipv4GatewayDescription The description of the IPv4 gateway. The description must be 2 to 256 characters in length. It must start with a letter but cannot start with http:// or https://.
 * @property ipv4GatewayName The name of the IPv4 gateway. The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). It must start with a letter.
 * @property resourceGroupId The ID of the resource group to which the instance belongs.
 * @property tags The tags of the current resource.
 * @property vpcId The ID of the virtual private cloud (VPC) where you want to create the IPv4 gateway. You can create only one IPv4 gateway in a VPC.
 */
public data class Ipv4GatewayArgs(
    public val dryRun: Output<Boolean>? = null,
    public val enabled: Output<Boolean>? = null,
    public val ipv4GatewayDescription: Output<String>? = null,
    public val ipv4GatewayName: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.Ipv4GatewayArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.Ipv4GatewayArgs =
        com.pulumi.alicloud.vpc.Ipv4GatewayArgs.builder()
            .dryRun(dryRun?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .ipv4GatewayDescription(ipv4GatewayDescription?.applyValue({ args0 -> args0 }))
            .ipv4GatewayName(ipv4GatewayName?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [Ipv4GatewayArgs].
 */
@PulumiTagMarker
public class Ipv4GatewayArgsBuilder internal constructor() {
    private var dryRun: Output<Boolean>? = null

    private var enabled: Output<Boolean>? = null

    private var ipv4GatewayDescription: Output<String>? = null

    private var ipv4GatewayName: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value Whether to PreCheck only this request. Value:-**true**: The check request is sent without creating an IPv4 Gateway. Check items include whether required parameters, request format, and business restrictions are filled in. If the check does not pass, the corresponding error is returned. If the check passes, the error code 'DryRunOperation' is returned '.-**false** (default): Sends a normal request, returns an HTTP 2xx status code and directly creates an IPv4 Gateway.
     */
    @JvmName("xrgffoqqcjjjksri")
    public suspend fun dryRun(`value`: Output<Boolean>) {
        this.dryRun = value
    }

    /**
     * @param value Whether the IPv4 gateway is active or not. Valid values are **true** and **false**.
     */
    @JvmName("utrscbrhidrxgvxo")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The description of the IPv4 gateway. The description must be 2 to 256 characters in length. It must start with a letter but cannot start with http:// or https://.
     */
    @JvmName("potmjgwbfjpjuhaj")
    public suspend fun ipv4GatewayDescription(`value`: Output<String>) {
        this.ipv4GatewayDescription = value
    }

    /**
     * @param value The name of the IPv4 gateway. The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). It must start with a letter.
     */
    @JvmName("pmxjujophviyswda")
    public suspend fun ipv4GatewayName(`value`: Output<String>) {
        this.ipv4GatewayName = value
    }

    /**
     * @param value The ID of the resource group to which the instance belongs.
     */
    @JvmName("fiicfwaorvykykft")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The tags of the current resource.
     */
    @JvmName("wsmayvoduykptugj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the virtual private cloud (VPC) where you want to create the IPv4 gateway. You can create only one IPv4 gateway in a VPC.
     */
    @JvmName("nbbrxuefmfbaoifx")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value Whether to PreCheck only this request. Value:-**true**: The check request is sent without creating an IPv4 Gateway. Check items include whether required parameters, request format, and business restrictions are filled in. If the check does not pass, the corresponding error is returned. If the check passes, the error code 'DryRunOperation' is returned '.-**false** (default): Sends a normal request, returns an HTTP 2xx status code and directly creates an IPv4 Gateway.
     */
    @JvmName("rxrqudipimhfvynj")
    public suspend fun dryRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dryRun = mapped
    }

    /**
     * @param value Whether the IPv4 gateway is active or not. Valid values are **true** and **false**.
     */
    @JvmName("fmmnjegbrodwthsj")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The description of the IPv4 gateway. The description must be 2 to 256 characters in length. It must start with a letter but cannot start with http:// or https://.
     */
    @JvmName("rglstdjuplhntnbu")
    public suspend fun ipv4GatewayDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv4GatewayDescription = mapped
    }

    /**
     * @param value The name of the IPv4 gateway. The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (_), and hyphens (-). It must start with a letter.
     */
    @JvmName("yreniamxmitnjglq")
    public suspend fun ipv4GatewayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv4GatewayName = mapped
    }

    /**
     * @param value The ID of the resource group to which the instance belongs.
     */
    @JvmName("ifbjkudasgvihldd")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The tags of the current resource.
     */
    @JvmName("scqyxkxqdxcdekpd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of the current resource.
     */
    @JvmName("ricjjguubvxgcgyy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ID of the virtual private cloud (VPC) where you want to create the IPv4 gateway. You can create only one IPv4 gateway in a VPC.
     */
    @JvmName("yuvlxumutctqgkdq")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): Ipv4GatewayArgs = Ipv4GatewayArgs(
        dryRun = dryRun,
        enabled = enabled,
        ipv4GatewayDescription = ipv4GatewayDescription,
        ipv4GatewayName = ipv4GatewayName,
        resourceGroupId = resourceGroupId,
        tags = tags,
        vpcId = vpcId,
    )
}
