@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Ipv6Address].
 */
@PulumiTagMarker
public class Ipv6AddressResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: Ipv6AddressArgs = Ipv6AddressArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend Ipv6AddressArgsBuilder.() -> Unit) {
        val builder = Ipv6AddressArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Ipv6Address {
        val builtJavaResource = com.pulumi.alicloud.vpc.Ipv6Address(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Ipv6Address(builtJavaResource)
    }
}

/**
 * Provides a VPC Ipv6 Address resource.
 * For information about VPC Ipv6 Address and how to use it, see [What is Ipv6 Address](https://next.api.alibabacloud.com/document/Vpc/2016-04-28/AllocateIpv6Address).
 * > **NOTE:** Available since v1.216.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.resourcemanager.getResourceGroups({});
 * const defaultGetZones = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const vpc = new alicloud.vpc.Network("vpc", {
 *     ipv6Isp: "BGP",
 *     cidrBlock: "172.168.0.0/16",
 *     enableIpv6: true,
 *     vpcName: name,
 * });
 * const vswich = new alicloud.vpc.Switch("vswich", {
 *     vpcId: vpc.id,
 *     cidrBlock: "172.168.0.0/24",
 *     zoneId: defaultGetZones.then(defaultGetZones => defaultGetZones.zones?.[0]?.id),
 *     vswitchName: name,
 *     ipv6CidrBlockMask: 1,
 * });
 * const defaultIpv6Address = new alicloud.vpc.Ipv6Address("default", {
 *     resourceGroupId: _default.then(_default => _default.ids?.[0]),
 *     vswitchId: vswich.id,
 *     ipv6AddressDescription: "create_description",
 *     ipv6AddressName: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.resourcemanager.get_resource_groups()
 * default_get_zones = alicloud.get_zones(available_resource_creation="VSwitch")
 * vpc = alicloud.vpc.Network("vpc",
 *     ipv6_isp="BGP",
 *     cidr_block="172.168.0.0/16",
 *     enable_ipv6=True,
 *     vpc_name=name)
 * vswich = alicloud.vpc.Switch("vswich",
 *     vpc_id=vpc.id,
 *     cidr_block="172.168.0.0/24",
 *     zone_id=default_get_zones.zones[0].id,
 *     vswitch_name=name,
 *     ipv6_cidr_block_mask=1)
 * default_ipv6_address = alicloud.vpc.Ipv6Address("default",
 *     resource_group_id=default.ids[0],
 *     vswitch_id=vswich.id,
 *     ipv6_address_description="create_description",
 *     ipv6_address_name=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var defaultGetZones = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var vpc = new AliCloud.Vpc.Network("vpc", new()
 *     {
 *         Ipv6Isp = "BGP",
 *         CidrBlock = "172.168.0.0/16",
 *         EnableIpv6 = true,
 *         VpcName = name,
 *     });
 *     var vswich = new AliCloud.Vpc.Switch("vswich", new()
 *     {
 *         VpcId = vpc.Id,
 *         CidrBlock = "172.168.0.0/24",
 *         ZoneId = defaultGetZones.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         VswitchName = name,
 *         Ipv6CidrBlockMask = 1,
 *     });
 *     var defaultIpv6Address = new AliCloud.Vpc.Ipv6Address("default", new()
 *     {
 *         ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Ids[0])),
 *         VswitchId = vswich.Id,
 *         Ipv6AddressDescription = "create_description",
 *         Ipv6AddressName = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetZones, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		vpc, err := vpc.NewNetwork(ctx, "vpc", &vpc.NetworkArgs{
 * 			Ipv6Isp:    pulumi.String("BGP"),
 * 			CidrBlock:  pulumi.String("172.168.0.0/16"),
 * 			EnableIpv6: pulumi.Bool(true),
 * 			VpcName:    pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		vswich, err := vpc.NewSwitch(ctx, "vswich", &vpc.SwitchArgs{
 * 			VpcId:             vpc.ID(),
 * 			CidrBlock:         pulumi.String("172.168.0.0/24"),
 * 			ZoneId:            pulumi.String(defaultGetZones.Zones[0].Id),
 * 			VswitchName:       pulumi.String(name),
 * 			Ipv6CidrBlockMask: pulumi.Int(1),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewIpv6Address(ctx, "default", &vpc.Ipv6AddressArgs{
 * 			ResourceGroupId:        pulumi.String(_default.Ids[0]),
 * 			VswitchId:              vswich.ID(),
 * 			Ipv6AddressDescription: pulumi.String("create_description"),
 * 			Ipv6AddressName:        pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.vpc.Ipv6Address;
 * import com.pulumi.alicloud.vpc.Ipv6AddressArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = ResourcemanagerFunctions.getResourceGroups();
 *         final var defaultGetZones = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var vpc = new Network("vpc", NetworkArgs.builder()
 *             .ipv6Isp("BGP")
 *             .cidrBlock("172.168.0.0/16")
 *             .enableIpv6(true)
 *             .vpcName(name)
 *             .build());
 *         var vswich = new Switch("vswich", SwitchArgs.builder()
 *             .vpcId(vpc.id())
 *             .cidrBlock("172.168.0.0/24")
 *             .zoneId(defaultGetZones.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *             .vswitchName(name)
 *             .ipv6CidrBlockMask("1")
 *             .build());
 *         var defaultIpv6Address = new Ipv6Address("defaultIpv6Address", Ipv6AddressArgs.builder()
 *             .resourceGroupId(default_.ids()[0])
 *             .vswitchId(vswich.id())
 *             .ipv6AddressDescription("create_description")
 *             .ipv6AddressName(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   vpc:
 *     type: alicloud:vpc:Network
 *     properties:
 *       ipv6Isp: BGP
 *       cidrBlock: 172.168.0.0/16
 *       enableIpv6: true
 *       vpcName: ${name}
 *   vswich:
 *     type: alicloud:vpc:Switch
 *     properties:
 *       vpcId: ${vpc.id}
 *       cidrBlock: 172.168.0.0/24
 *       zoneId: ${defaultGetZones.zones[0].id}
 *       vswitchName: ${name}
 *       ipv6CidrBlockMask: '1'
 *   defaultIpv6Address:
 *     type: alicloud:vpc:Ipv6Address
 *     name: default
 *     properties:
 *       resourceGroupId: ${default.ids[0]}
 *       vswitchId: ${vswich.id}
 *       ipv6AddressDescription: create_description
 *       ipv6AddressName: ${name}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 *   defaultGetZones:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * VPC Ipv6 Address can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/ipv6Address:Ipv6Address example <id>
 * ```
 */
public class Ipv6Address internal constructor(
    override val javaResource: com.pulumi.alicloud.vpc.Ipv6Address,
) : KotlinCustomResource(javaResource, Ipv6AddressMapper) {
    /**
     * The creation time of the resource.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * IPv6 address.
     */
    public val ipv6Address: Output<String>
        get() = javaResource.ipv6Address().applyValue({ args0 -> args0 })

    /**
     * The description of the IPv6 Address. The description must be 2 to 256 characters in length. It cannot start with http:// or https://.
     */
    public val ipv6AddressDescription: Output<String>
        get() = javaResource.ipv6AddressDescription().applyValue({ args0 -> args0 })

    /**
     * The name of the IPv6 Address. The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter but cannot start with http:// or https://.
     */
    public val ipv6AddressName: Output<String>?
        get() = javaResource.ipv6AddressName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the resource group to which the instance belongs.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The status of the resource.  Available, Pending and Deleting.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The tags for the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The VSwitchId of the IPv6 address.
     */
    public val vswitchId: Output<String>
        get() = javaResource.vswitchId().applyValue({ args0 -> args0 })
}

public object Ipv6AddressMapper : ResourceMapper<Ipv6Address> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.vpc.Ipv6Address::class == javaResource::class

    override fun map(javaResource: Resource): Ipv6Address = Ipv6Address(
        javaResource as
            com.pulumi.alicloud.vpc.Ipv6Address,
    )
}

/**
 * @see [Ipv6Address].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Ipv6Address].
 */
public suspend fun ipv6Address(name: String, block: suspend Ipv6AddressResourceBuilder.() -> Unit): Ipv6Address {
    val builder = Ipv6AddressResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Ipv6Address].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ipv6Address(name: String): Ipv6Address {
    val builder = Ipv6AddressResourceBuilder()
    builder.name(name)
    return builder.build()
}
