@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.alicloud.vpc.Ipv6AddressArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a VPC Ipv6 Address resource.
 * For information about VPC Ipv6 Address and how to use it, see [What is Ipv6 Address](https://next.api.alibabacloud.com/document/Vpc/2016-04-28/AllocateIpv6Address).
 * > **NOTE:** Available since v1.216.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.resourcemanager.getResourceGroups({});
 * const defaultGetZones = alicloud.getZones({
 *     availableResourceCreation: "VSwitch",
 * });
 * const vpc = new alicloud.vpc.Network("vpc", {
 *     ipv6Isp: "BGP",
 *     cidrBlock: "172.168.0.0/16",
 *     enableIpv6: true,
 *     vpcName: name,
 * });
 * const vswich = new alicloud.vpc.Switch("vswich", {
 *     vpcId: vpc.id,
 *     cidrBlock: "172.168.0.0/24",
 *     zoneId: defaultGetZones.then(defaultGetZones => defaultGetZones.zones?.[0]?.id),
 *     vswitchName: name,
 *     ipv6CidrBlockMask: 1,
 * });
 * const defaultIpv6Address = new alicloud.vpc.Ipv6Address("default", {
 *     resourceGroupId: _default.then(_default => _default.ids?.[0]),
 *     vswitchId: vswich.id,
 *     ipv6AddressDescription: "create_description",
 *     ipv6AddressName: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.resourcemanager.get_resource_groups()
 * default_get_zones = alicloud.get_zones(available_resource_creation="VSwitch")
 * vpc = alicloud.vpc.Network("vpc",
 *     ipv6_isp="BGP",
 *     cidr_block="172.168.0.0/16",
 *     enable_ipv6=True,
 *     vpc_name=name)
 * vswich = alicloud.vpc.Switch("vswich",
 *     vpc_id=vpc.id,
 *     cidr_block="172.168.0.0/24",
 *     zone_id=default_get_zones.zones[0].id,
 *     vswitch_name=name,
 *     ipv6_cidr_block_mask=1)
 * default_ipv6_address = alicloud.vpc.Ipv6Address("default",
 *     resource_group_id=default.ids[0],
 *     vswitch_id=vswich.id,
 *     ipv6_address_description="create_description",
 *     ipv6_address_name=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var defaultGetZones = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var vpc = new AliCloud.Vpc.Network("vpc", new()
 *     {
 *         Ipv6Isp = "BGP",
 *         CidrBlock = "172.168.0.0/16",
 *         EnableIpv6 = true,
 *         VpcName = name,
 *     });
 *     var vswich = new AliCloud.Vpc.Switch("vswich", new()
 *     {
 *         VpcId = vpc.Id,
 *         CidrBlock = "172.168.0.0/24",
 *         ZoneId = defaultGetZones.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         VswitchName = name,
 *         Ipv6CidrBlockMask = 1,
 *     });
 *     var defaultIpv6Address = new AliCloud.Vpc.Ipv6Address("default", new()
 *     {
 *         ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Ids[0])),
 *         VswitchId = vswich.Id,
 *         Ipv6AddressDescription = "create_description",
 *         Ipv6AddressName = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetZones, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		vpc, err := vpc.NewNetwork(ctx, "vpc", &vpc.NetworkArgs{
 * 			Ipv6Isp:    pulumi.String("BGP"),
 * 			CidrBlock:  pulumi.String("172.168.0.0/16"),
 * 			EnableIpv6: pulumi.Bool(true),
 * 			VpcName:    pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		vswich, err := vpc.NewSwitch(ctx, "vswich", &vpc.SwitchArgs{
 * 			VpcId:             vpc.ID(),
 * 			CidrBlock:         pulumi.String("172.168.0.0/24"),
 * 			ZoneId:            pulumi.String(defaultGetZones.Zones[0].Id),
 * 			VswitchName:       pulumi.String(name),
 * 			Ipv6CidrBlockMask: pulumi.Int(1),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewIpv6Address(ctx, "default", &vpc.Ipv6AddressArgs{
 * 			ResourceGroupId:        pulumi.String(_default.Ids[0]),
 * 			VswitchId:              vswich.ID(),
 * 			Ipv6AddressDescription: pulumi.String("create_description"),
 * 			Ipv6AddressName:        pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.vpc.Ipv6Address;
 * import com.pulumi.alicloud.vpc.Ipv6AddressArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = ResourcemanagerFunctions.getResourceGroups();
 *         final var defaultGetZones = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var vpc = new Network("vpc", NetworkArgs.builder()
 *             .ipv6Isp("BGP")
 *             .cidrBlock("172.168.0.0/16")
 *             .enableIpv6(true)
 *             .vpcName(name)
 *             .build());
 *         var vswich = new Switch("vswich", SwitchArgs.builder()
 *             .vpcId(vpc.id())
 *             .cidrBlock("172.168.0.0/24")
 *             .zoneId(defaultGetZones.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
 *             .vswitchName(name)
 *             .ipv6CidrBlockMask("1")
 *             .build());
 *         var defaultIpv6Address = new Ipv6Address("defaultIpv6Address", Ipv6AddressArgs.builder()
 *             .resourceGroupId(default_.ids()[0])
 *             .vswitchId(vswich.id())
 *             .ipv6AddressDescription("create_description")
 *             .ipv6AddressName(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   vpc:
 *     type: alicloud:vpc:Network
 *     properties:
 *       ipv6Isp: BGP
 *       cidrBlock: 172.168.0.0/16
 *       enableIpv6: true
 *       vpcName: ${name}
 *   vswich:
 *     type: alicloud:vpc:Switch
 *     properties:
 *       vpcId: ${vpc.id}
 *       cidrBlock: 172.168.0.0/24
 *       zoneId: ${defaultGetZones.zones[0].id}
 *       vswitchName: ${name}
 *       ipv6CidrBlockMask: '1'
 *   defaultIpv6Address:
 *     type: alicloud:vpc:Ipv6Address
 *     name: default
 *     properties:
 *       resourceGroupId: ${default.ids[0]}
 *       vswitchId: ${vswich.id}
 *       ipv6AddressDescription: create_description
 *       ipv6AddressName: ${name}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 *   defaultGetZones:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * VPC Ipv6 Address can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/ipv6Address:Ipv6Address example <id>
 * ```
 * @property ipv6AddressDescription The description of the IPv6 Address. The description must be 2 to 256 characters in length. It cannot start with http:// or https://.
 * @property ipv6AddressName The name of the IPv6 Address. The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter but cannot start with http:// or https://.
 * @property resourceGroupId The ID of the resource group to which the instance belongs.
 * @property tags The tags for the resource.
 * @property vswitchId The VSwitchId of the IPv6 address.
 */
public data class Ipv6AddressArgs(
    public val ipv6AddressDescription: Output<String>? = null,
    public val ipv6AddressName: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vswitchId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.Ipv6AddressArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.Ipv6AddressArgs =
        com.pulumi.alicloud.vpc.Ipv6AddressArgs.builder()
            .ipv6AddressDescription(ipv6AddressDescription?.applyValue({ args0 -> args0 }))
            .ipv6AddressName(ipv6AddressName?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [Ipv6AddressArgs].
 */
@PulumiTagMarker
public class Ipv6AddressArgsBuilder internal constructor() {
    private var ipv6AddressDescription: Output<String>? = null

    private var ipv6AddressName: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vswitchId: Output<String>? = null

    /**
     * @param value The description of the IPv6 Address. The description must be 2 to 256 characters in length. It cannot start with http:// or https://.
     */
    @JvmName("aflvjvybfmfrudrh")
    public suspend fun ipv6AddressDescription(`value`: Output<String>) {
        this.ipv6AddressDescription = value
    }

    /**
     * @param value The name of the IPv6 Address. The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter but cannot start with http:// or https://.
     */
    @JvmName("xhmqlqeiogujrwqu")
    public suspend fun ipv6AddressName(`value`: Output<String>) {
        this.ipv6AddressName = value
    }

    /**
     * @param value The ID of the resource group to which the instance belongs.
     */
    @JvmName("qkooqnyervkwtyre")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The tags for the resource.
     */
    @JvmName("kjhsbbmuqxgllils")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The VSwitchId of the IPv6 address.
     */
    @JvmName("lnisltnjwxvlydvr")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The description of the IPv6 Address. The description must be 2 to 256 characters in length. It cannot start with http:// or https://.
     */
    @JvmName("ibpdjmcerbdeuyjj")
    public suspend fun ipv6AddressDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6AddressDescription = mapped
    }

    /**
     * @param value The name of the IPv6 Address. The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter but cannot start with http:// or https://.
     */
    @JvmName("dbpnbklfvibrveuj")
    public suspend fun ipv6AddressName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6AddressName = mapped
    }

    /**
     * @param value The ID of the resource group to which the instance belongs.
     */
    @JvmName("buuuujhqjqosxcek")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The tags for the resource.
     */
    @JvmName("qgjyrurehwiodflo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags for the resource.
     */
    @JvmName("hxkrbfcugfvydeou")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The VSwitchId of the IPv6 address.
     */
    @JvmName("rjerkkonaiioadko")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    internal fun build(): Ipv6AddressArgs = Ipv6AddressArgs(
        ipv6AddressDescription = ipv6AddressDescription,
        ipv6AddressName = ipv6AddressName,
        resourceGroupId = resourceGroupId,
        tags = tags,
        vswitchId = vswitchId,
    )
}
