@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Ipv6Gateway].
 */
@PulumiTagMarker
public class Ipv6GatewayResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: Ipv6GatewayArgs = Ipv6GatewayArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend Ipv6GatewayArgsBuilder.() -> Unit) {
        val builder = Ipv6GatewayArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Ipv6Gateway {
        val builtJavaResource = com.pulumi.alicloud.vpc.Ipv6Gateway(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Ipv6Gateway(builtJavaResource)
    }
}

/**
 * Provides a Vpc Ipv6 Gateway resource. Gateway Based on Internet Protocol Version 6.
 * For information about Vpc Ipv6 Gateway and how to use it, see [What is Ipv6 Gateway](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/createipv6gateway).
 * > **NOTE:** Available in v1.142.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-testacc-example";
 * const defaultVpc = new alicloud.vpc.Network("defaultVpc", {
 *     description: "tf-testacc",
 *     enableIpv6: true,
 * });
 * const defaultRg = new alicloud.resourcemanager.ResourceGroup("defaultRg", {
 *     displayName: "tf-testacc-ipv6gateway503",
 *     resourceGroupName: `${name}1`,
 * });
 * const changeRg = new alicloud.resourcemanager.ResourceGroup("changeRg", {
 *     displayName: "tf-testacc-ipv6gateway311",
 *     resourceGroupName: `${name}2`,
 * });
 * const _default = new alicloud.vpc.Ipv6Gateway("default", {
 *     description: "test",
 *     ipv6GatewayName: name,
 *     vpcId: defaultVpc.id,
 *     resourceGroupId: defaultRg.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-testacc-example"
 * default_vpc = alicloud.vpc.Network("defaultVpc",
 *     description="tf-testacc",
 *     enable_ipv6=True)
 * default_rg = alicloud.resourcemanager.ResourceGroup("defaultRg",
 *     display_name="tf-testacc-ipv6gateway503",
 *     resource_group_name=f"{name}1")
 * change_rg = alicloud.resourcemanager.ResourceGroup("changeRg",
 *     display_name="tf-testacc-ipv6gateway311",
 *     resource_group_name=f"{name}2")
 * default = alicloud.vpc.Ipv6Gateway("default",
 *     description="test",
 *     ipv6_gateway_name=name,
 *     vpc_id=default_vpc.id,
 *     resource_group_id=default_rg.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-testacc-example";
 *     var defaultVpc = new AliCloud.Vpc.Network("defaultVpc", new()
 *     {
 *         Description = "tf-testacc",
 *         EnableIpv6 = true,
 *     });
 *     var defaultRg = new AliCloud.ResourceManager.ResourceGroup("defaultRg", new()
 *     {
 *         DisplayName = "tf-testacc-ipv6gateway503",
 *         ResourceGroupName = $"{name}1",
 *     });
 *     var changeRg = new AliCloud.ResourceManager.ResourceGroup("changeRg", new()
 *     {
 *         DisplayName = "tf-testacc-ipv6gateway311",
 *         ResourceGroupName = $"{name}2",
 *     });
 *     var @default = new AliCloud.Vpc.Ipv6Gateway("default", new()
 *     {
 *         Description = "test",
 *         Ipv6GatewayName = name,
 *         VpcId = defaultVpc.Id,
 *         ResourceGroupId = defaultRg.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-testacc-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		defaultVpc, err := vpc.NewNetwork(ctx, "defaultVpc", &vpc.NetworkArgs{
 * 			Description: pulumi.String("tf-testacc"),
 * 			EnableIpv6:  pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultRg, err := resourcemanager.NewResourceGroup(ctx, "defaultRg", &resourcemanager.ResourceGroupArgs{
 * 			DisplayName:       pulumi.String("tf-testacc-ipv6gateway503"),
 * 			ResourceGroupName: pulumi.Sprintf("%v1", name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = resourcemanager.NewResourceGroup(ctx, "changeRg", &resourcemanager.ResourceGroupArgs{
 * 			DisplayName:       pulumi.String("tf-testacc-ipv6gateway311"),
 * 			ResourceGroupName: pulumi.Sprintf("%v2", name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewIpv6Gateway(ctx, "default", &vpc.Ipv6GatewayArgs{
 * 			Description:     pulumi.String("test"),
 * 			Ipv6GatewayName: pulumi.String(name),
 * 			VpcId:           defaultVpc.ID(),
 * 			ResourceGroupId: defaultRg.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.resourcemanager.ResourceGroup;
 * import com.pulumi.alicloud.resourcemanager.ResourceGroupArgs;
 * import com.pulumi.alicloud.vpc.Ipv6Gateway;
 * import com.pulumi.alicloud.vpc.Ipv6GatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-testacc-example");
 *         var defaultVpc = new Network("defaultVpc", NetworkArgs.builder()
 *             .description("tf-testacc")
 *             .enableIpv6(true)
 *             .build());
 *         var defaultRg = new ResourceGroup("defaultRg", ResourceGroupArgs.builder()
 *             .displayName("tf-testacc-ipv6gateway503")
 *             .resourceGroupName(String.format("%s1", name))
 *             .build());
 *         var changeRg = new ResourceGroup("changeRg", ResourceGroupArgs.builder()
 *             .displayName("tf-testacc-ipv6gateway311")
 *             .resourceGroupName(String.format("%s2", name))
 *             .build());
 *         var default_ = new Ipv6Gateway("default", Ipv6GatewayArgs.builder()
 *             .description("test")
 *             .ipv6GatewayName(name)
 *             .vpcId(defaultVpc.id())
 *             .resourceGroupId(defaultRg.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-testacc-example
 * resources:
 *   defaultVpc:
 *     type: alicloud:vpc:Network
 *     properties:
 *       description: tf-testacc
 *       enableIpv6: true
 *   defaultRg:
 *     type: alicloud:resourcemanager:ResourceGroup
 *     properties:
 *       displayName: tf-testacc-ipv6gateway503
 *       resourceGroupName: ${name}1
 *   changeRg:
 *     type: alicloud:resourcemanager:ResourceGroup
 *     properties:
 *       displayName: tf-testacc-ipv6gateway311
 *       resourceGroupName: ${name}2
 *   default:
 *     type: alicloud:vpc:Ipv6Gateway
 *     properties:
 *       description: test
 *       ipv6GatewayName: ${name}
 *       vpcId: ${defaultVpc.id}
 *       resourceGroupId: ${defaultRg.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Vpc Ipv6 Gateway can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/ipv6Gateway:Ipv6Gateway example <id>
 * ```
 */
public class Ipv6Gateway internal constructor(
    override val javaResource: com.pulumi.alicloud.vpc.Ipv6Gateway,
) : KotlinCustomResource(javaResource, Ipv6GatewayMapper) {
    /**
     * The status of the IPv6 gateway.
     */
    public val businessStatus: Output<String>
        get() = javaResource.businessStatus().applyValue({ args0 -> args0 })

    /**
     * The creation time of the resource.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The description of the IPv6 gateway. The description must be 2 to 256 characters in length. It cannot start with http:// or https://.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The expiration time of IPv6 gateway.
     */
    public val expiredTime: Output<String>
        get() = javaResource.expiredTime().applyValue({ args0 -> args0 })

    /**
     * The charge type of IPv6 gateway.
     */
    public val instanceChargeType: Output<String>
        get() = javaResource.instanceChargeType().applyValue({ args0 -> args0 })

    /**
     * Resource primary key attribute field.
     */
    public val ipv6GatewayId: Output<String>
        get() = javaResource.ipv6GatewayId().applyValue({ args0 -> args0 })

    /**
     * The name of the IPv6 gateway. The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter but cannot start with http:// or https://.
     */
    public val ipv6GatewayName: Output<String>?
        get() = javaResource.ipv6GatewayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the resource group to which the instance belongs.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * IPv6 gateways do not distinguish between specifications. This parameter is no longer used.
     */
    @Deprecated(
        message = """
  Field 'Spec' has been deprecated from provider version 1.205.0. IPv6 gateways do not distinguish
      between specifications. This parameter is no longer used.
  """,
    )
    public val spec: Output<String>
        get() = javaResource.spec().applyValue({ args0 -> args0 })

    /**
     * The status of the resource. Valid values: Available, Pending and Deleting.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The tags for the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The ID of the virtual private cloud (VPC) for which you want to create the IPv6 gateway.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object Ipv6GatewayMapper : ResourceMapper<Ipv6Gateway> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.vpc.Ipv6Gateway::class == javaResource::class

    override fun map(javaResource: Resource): Ipv6Gateway = Ipv6Gateway(
        javaResource as
            com.pulumi.alicloud.vpc.Ipv6Gateway,
    )
}

/**
 * @see [Ipv6Gateway].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Ipv6Gateway].
 */
public suspend fun ipv6Gateway(name: String, block: suspend Ipv6GatewayResourceBuilder.() -> Unit): Ipv6Gateway {
    val builder = Ipv6GatewayResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Ipv6Gateway].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ipv6Gateway(name: String): Ipv6Gateway {
    val builder = Ipv6GatewayResourceBuilder()
    builder.name(name)
    return builder.build()
}
