@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin

import com.pulumi.alicloud.vpc.Ipv6GatewayArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Deprecated
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Vpc Ipv6 Gateway resource. Gateway Based on Internet Protocol Version 6.
 * For information about Vpc Ipv6 Gateway and how to use it, see [What is Ipv6 Gateway](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/createipv6gateway).
 * > **NOTE:** Available in v1.142.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf-testacc-example";
 * const defaultVpc = new alicloud.vpc.Network("defaultVpc", {
 *     description: "tf-testacc",
 *     enableIpv6: true,
 * });
 * const defaultRg = new alicloud.resourcemanager.ResourceGroup("defaultRg", {
 *     displayName: "tf-testacc-ipv6gateway503",
 *     resourceGroupName: `${name}1`,
 * });
 * const changeRg = new alicloud.resourcemanager.ResourceGroup("changeRg", {
 *     displayName: "tf-testacc-ipv6gateway311",
 *     resourceGroupName: `${name}2`,
 * });
 * const _default = new alicloud.vpc.Ipv6Gateway("default", {
 *     description: "test",
 *     ipv6GatewayName: name,
 *     vpcId: defaultVpc.id,
 *     resourceGroupId: defaultRg.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf-testacc-example"
 * default_vpc = alicloud.vpc.Network("defaultVpc",
 *     description="tf-testacc",
 *     enable_ipv6=True)
 * default_rg = alicloud.resourcemanager.ResourceGroup("defaultRg",
 *     display_name="tf-testacc-ipv6gateway503",
 *     resource_group_name=f"{name}1")
 * change_rg = alicloud.resourcemanager.ResourceGroup("changeRg",
 *     display_name="tf-testacc-ipv6gateway311",
 *     resource_group_name=f"{name}2")
 * default = alicloud.vpc.Ipv6Gateway("default",
 *     description="test",
 *     ipv6_gateway_name=name,
 *     vpc_id=default_vpc.id,
 *     resource_group_id=default_rg.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf-testacc-example";
 *     var defaultVpc = new AliCloud.Vpc.Network("defaultVpc", new()
 *     {
 *         Description = "tf-testacc",
 *         EnableIpv6 = true,
 *     });
 *     var defaultRg = new AliCloud.ResourceManager.ResourceGroup("defaultRg", new()
 *     {
 *         DisplayName = "tf-testacc-ipv6gateway503",
 *         ResourceGroupName = $"{name}1",
 *     });
 *     var changeRg = new AliCloud.ResourceManager.ResourceGroup("changeRg", new()
 *     {
 *         DisplayName = "tf-testacc-ipv6gateway311",
 *         ResourceGroupName = $"{name}2",
 *     });
 *     var @default = new AliCloud.Vpc.Ipv6Gateway("default", new()
 *     {
 *         Description = "test",
 *         Ipv6GatewayName = name,
 *         VpcId = defaultVpc.Id,
 *         ResourceGroupId = defaultRg.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf-testacc-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		defaultVpc, err := vpc.NewNetwork(ctx, "defaultVpc", &vpc.NetworkArgs{
 * 			Description: pulumi.String("tf-testacc"),
 * 			EnableIpv6:  pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultRg, err := resourcemanager.NewResourceGroup(ctx, "defaultRg", &resourcemanager.ResourceGroupArgs{
 * 			DisplayName:       pulumi.String("tf-testacc-ipv6gateway503"),
 * 			ResourceGroupName: pulumi.Sprintf("%v1", name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = resourcemanager.NewResourceGroup(ctx, "changeRg", &resourcemanager.ResourceGroupArgs{
 * 			DisplayName:       pulumi.String("tf-testacc-ipv6gateway311"),
 * 			ResourceGroupName: pulumi.Sprintf("%v2", name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = vpc.NewIpv6Gateway(ctx, "default", &vpc.Ipv6GatewayArgs{
 * 			Description:     pulumi.String("test"),
 * 			Ipv6GatewayName: pulumi.String(name),
 * 			VpcId:           defaultVpc.ID(),
 * 			ResourceGroupId: defaultRg.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.resourcemanager.ResourceGroup;
 * import com.pulumi.alicloud.resourcemanager.ResourceGroupArgs;
 * import com.pulumi.alicloud.vpc.Ipv6Gateway;
 * import com.pulumi.alicloud.vpc.Ipv6GatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf-testacc-example");
 *         var defaultVpc = new Network("defaultVpc", NetworkArgs.builder()
 *             .description("tf-testacc")
 *             .enableIpv6(true)
 *             .build());
 *         var defaultRg = new ResourceGroup("defaultRg", ResourceGroupArgs.builder()
 *             .displayName("tf-testacc-ipv6gateway503")
 *             .resourceGroupName(String.format("%s1", name))
 *             .build());
 *         var changeRg = new ResourceGroup("changeRg", ResourceGroupArgs.builder()
 *             .displayName("tf-testacc-ipv6gateway311")
 *             .resourceGroupName(String.format("%s2", name))
 *             .build());
 *         var default_ = new Ipv6Gateway("default", Ipv6GatewayArgs.builder()
 *             .description("test")
 *             .ipv6GatewayName(name)
 *             .vpcId(defaultVpc.id())
 *             .resourceGroupId(defaultRg.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf-testacc-example
 * resources:
 *   defaultVpc:
 *     type: alicloud:vpc:Network
 *     properties:
 *       description: tf-testacc
 *       enableIpv6: true
 *   defaultRg:
 *     type: alicloud:resourcemanager:ResourceGroup
 *     properties:
 *       displayName: tf-testacc-ipv6gateway503
 *       resourceGroupName: ${name}1
 *   changeRg:
 *     type: alicloud:resourcemanager:ResourceGroup
 *     properties:
 *       displayName: tf-testacc-ipv6gateway311
 *       resourceGroupName: ${name}2
 *   default:
 *     type: alicloud:vpc:Ipv6Gateway
 *     properties:
 *       description: test
 *       ipv6GatewayName: ${name}
 *       vpcId: ${defaultVpc.id}
 *       resourceGroupId: ${defaultRg.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Vpc Ipv6 Gateway can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:vpc/ipv6Gateway:Ipv6Gateway example <id>
 * ```
 * @property description The description of the IPv6 gateway. The description must be 2 to 256 characters in length. It cannot start with http:// or https://.
 * @property ipv6GatewayName The name of the IPv6 gateway. The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter but cannot start with http:// or https://.
 * @property resourceGroupId The ID of the resource group to which the instance belongs.
 * @property spec IPv6 gateways do not distinguish between specifications. This parameter is no longer used.
 * @property tags The tags for the resource.
 * @property vpcId The ID of the virtual private cloud (VPC) for which you want to create the IPv6 gateway.
 */
public data class Ipv6GatewayArgs(
    public val description: Output<String>? = null,
    public val ipv6GatewayName: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'Spec' has been deprecated from provider version 1.205.0. IPv6 gateways do not distinguish
      between specifications. This parameter is no longer used.
  """,
    )
    public val spec: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.vpc.Ipv6GatewayArgs> {
    override fun toJava(): com.pulumi.alicloud.vpc.Ipv6GatewayArgs =
        com.pulumi.alicloud.vpc.Ipv6GatewayArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .ipv6GatewayName(ipv6GatewayName?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .spec(spec?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [Ipv6GatewayArgs].
 */
@PulumiTagMarker
public class Ipv6GatewayArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var ipv6GatewayName: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var spec: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value The description of the IPv6 gateway. The description must be 2 to 256 characters in length. It cannot start with http:// or https://.
     */
    @JvmName("ewpdesreeisftkgs")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the IPv6 gateway. The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter but cannot start with http:// or https://.
     */
    @JvmName("qevwhvwarihposwv")
    public suspend fun ipv6GatewayName(`value`: Output<String>) {
        this.ipv6GatewayName = value
    }

    /**
     * @param value The ID of the resource group to which the instance belongs.
     */
    @JvmName("leiorxcbnwknmjeo")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value IPv6 gateways do not distinguish between specifications. This parameter is no longer used.
     */
    @Deprecated(
        message = """
  Field 'Spec' has been deprecated from provider version 1.205.0. IPv6 gateways do not distinguish
      between specifications. This parameter is no longer used.
  """,
    )
    @JvmName("ayjorsugyelpigbe")
    public suspend fun spec(`value`: Output<String>) {
        this.spec = value
    }

    /**
     * @param value The tags for the resource.
     */
    @JvmName("dtigvdqtrmusiayo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the virtual private cloud (VPC) for which you want to create the IPv6 gateway.
     */
    @JvmName("hfviewfhnndtrlmv")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The description of the IPv6 gateway. The description must be 2 to 256 characters in length. It cannot start with http:// or https://.
     */
    @JvmName("uewrigxudfhuhtdb")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the IPv6 gateway. The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter but cannot start with http:// or https://.
     */
    @JvmName("dljwcqccaccqyjvv")
    public suspend fun ipv6GatewayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6GatewayName = mapped
    }

    /**
     * @param value The ID of the resource group to which the instance belongs.
     */
    @JvmName("gofywkdiwktisaxm")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value IPv6 gateways do not distinguish between specifications. This parameter is no longer used.
     */
    @Deprecated(
        message = """
  Field 'Spec' has been deprecated from provider version 1.205.0. IPv6 gateways do not distinguish
      between specifications. This parameter is no longer used.
  """,
    )
    @JvmName("tkljnajwiwgliyjc")
    public suspend fun spec(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spec = mapped
    }

    /**
     * @param value The tags for the resource.
     */
    @JvmName("jstlmbnwtlsyrguw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags for the resource.
     */
    @JvmName("bwfefyfffcklyomc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ID of the virtual private cloud (VPC) for which you want to create the IPv6 gateway.
     */
    @JvmName("kxpwipnmdtrajnvn")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): Ipv6GatewayArgs = Ipv6GatewayArgs(
        description = description,
        ipv6GatewayName = ipv6GatewayName,
        resourceGroupId = resourceGroupId,
        spec = spec,
        tags = tags,
        vpcId = vpcId,
    )
}
